/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.AttributeConstants;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.faces.component.html.HtmlSelectManyMenu;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MenuRenderer
extends DomBasicInputRenderer {
    private static Logger log = Logger.getLogger(MenuRenderer.class.getName());
    private static final String[] selectOneMenuPassThruAttributes = AttributeConstants.getAttributes(22);
    private static final String[] selectManyMenuPassThruAttributes = AttributeConstants.getAttributes(20);
    private static final String[] selectOneListboxPassThruAttributes = AttributeConstants.getAttributes(21);
    private static final String[] selectManyListboxPassThruAttributes = AttributeConstants.getAttributes(19);

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        MenuRenderer.validateParameters(facesContext, uiComponent, null);
        if (MenuRenderer.isStatic(uiComponent)) {
            return;
        }
        String clientId = uiComponent.getClientId(facesContext);
        if (uiComponent instanceof UISelectMany) {
            Map requestParameterValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
            if (requestParameterValuesMap.containsKey(clientId)) {
                String[] decodedValue = (String[])requestParameterValuesMap.get(clientId);
                this.setSubmittedValue(uiComponent, decodedValue);
            } else {
                this.setSubmittedValue(uiComponent, new String[0]);
            }
        } else if (uiComponent instanceof UISelectOne) {
            Map requestParameterValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
            String decodedValue = null;
            decodedValue = requestParameterValuesMap != null && requestParameterValuesMap.containsKey(clientId) ? ((String[])requestParameterValuesMap.get(clientId))[0] : "";
            ((UISelectOne)uiComponent).setSubmittedValue((Object)decodedValue);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        MenuRenderer.validateParameters(facesContext, uiComponent, null);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
        MenuRenderer.validateParameters(facesContext, uiComponent, null);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        MenuRenderer.validateParameters(facesContext, uiComponent, null);
        this.renderSelect(facesContext, uiComponent);
        JavascriptContext.fireEffect(uiComponent, facesContext);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object newSubmittedValue) throws ConverterException {
        if (uiComponent instanceof UISelectOne) {
            if (newSubmittedValue == null || "".equals(newSubmittedValue)) {
                return null;
            }
            return super.getConvertedValue(facesContext, (UIComponent)((UISelectOne)uiComponent), newSubmittedValue);
        }
        return this.convertSelectValue(facesContext, (UISelectMany)uiComponent, (String[])newSubmittedValue);
    }

    public Object convertSelectValue(FacesContext facesContext, UIComponent uiComponent, Object newSubmittedValue) throws ConverterException {
        if (uiComponent instanceof UISelectOne) {
            if (newSubmittedValue == null || "".equals(newSubmittedValue)) {
                return null;
            }
            return super.getConvertedValue(facesContext, (UIComponent)((UISelectOne)uiComponent), newSubmittedValue);
        }
        return this.convertSelectValue(facesContext, (UISelectMany)uiComponent, (String[])newSubmittedValue);
    }

    public Object convertSelectValue(FacesContext facesContext, UISelectMany uiSelectMany, String[] newSubmittedValues) throws ConverterException {
        ValueBinding valueBinding = uiSelectMany.getValueBinding("value");
        if (valueBinding == null) {
            Class<?> componentType = new Object[1].getClass().getComponentType();
            return this.convertArray(facesContext, uiSelectMany, componentType, newSubmittedValues);
        }
        Class valueBindingClass = valueBinding.getType(facesContext);
        if (valueBindingClass == null) {
            throw new ConverterException("Inconvertible type in value binding");
        }
        if (List.class.isAssignableFrom(valueBindingClass)) {
            Converter converter = uiSelectMany.getConverter();
            if (converter == null) {
                converter = MenuRenderer.getConverterForClass(valueBindingClass);
            }
            ArrayList<String> submittedValuesAsList = new ArrayList<String>(newSubmittedValues.length);
            for (int index = 0; index < newSubmittedValues.length; ++index) {
                Object convertedValue = newSubmittedValues[index];
                if (converter != null) {
                    convertedValue = converter.getAsObject(facesContext, (UIComponent)uiSelectMany, newSubmittedValues[index]);
                }
                submittedValuesAsList.add((String)convertedValue);
            }
            return submittedValuesAsList;
        }
        if (valueBindingClass.isArray()) {
            Class<?> componentType = valueBindingClass.getComponentType();
            return this.convertArray(facesContext, uiSelectMany, componentType, newSubmittedValues);
        }
        throw new ConverterException("Non-list and Non-array values are inconvertible");
    }

    protected Object convertArray(FacesContext facesContext, UISelectMany uiSelectMany, Class componentType, String[] newSubmittedValues) throws ConverterException {
        if (componentType.equals(String.class)) {
            return newSubmittedValues;
        }
        if (newSubmittedValues == null) {
            return Array.newInstance(componentType, 0);
        }
        int numberOfValues = newSubmittedValues.length;
        Object convertedValues = Array.newInstance(componentType, numberOfValues);
        Converter converter = uiSelectMany.getConverter();
        if (converter == null) {
            converter = MenuRenderer.getConverterForClass(componentType);
        }
        if (converter == null) {
            if (componentType.equals(Object.class)) {
                return newSubmittedValues;
            }
            throw new ConverterException("Converter is null");
        }
        for (int index = 0; index < numberOfValues; ++index) {
            Object nextConvertedElement = converter.getAsObject(facesContext, (UIComponent)uiSelectMany, newSubmittedValues[index]);
            if (!componentType.isPrimitive()) {
                Array.set(convertedValues, index, nextConvertedElement);
                continue;
            }
            if (componentType.equals(Boolean.TYPE)) {
                Array.setBoolean(convertedValues, index, (Boolean)nextConvertedElement);
                continue;
            }
            if (componentType.equals(Integer.TYPE)) {
                Array.setInt(convertedValues, index, (Integer)nextConvertedElement);
                continue;
            }
            if (componentType.equals(Long.TYPE)) {
                Array.setLong(convertedValues, index, (Long)nextConvertedElement);
                continue;
            }
            if (componentType.equals(Short.TYPE)) {
                Array.setShort(convertedValues, index, (Short)nextConvertedElement);
                continue;
            }
            if (componentType.equals(Byte.TYPE)) {
                Array.setByte(convertedValues, index, (Byte)nextConvertedElement);
                continue;
            }
            if (componentType.equals(Float.TYPE)) {
                Array.setFloat(convertedValues, index, ((Float)nextConvertedElement).floatValue());
                continue;
            }
            if (componentType.equals(Double.TYPE)) {
                Array.setDouble(convertedValues, index, (Double)nextConvertedElement);
                continue;
            }
            if (!componentType.equals(Character.TYPE)) continue;
            Array.setChar(convertedValues, index, ((Character)nextConvertedElement).charValue());
        }
        return convertedValues;
    }

    protected void renderOption(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, Element optionGroup, Object[] submittedValues, Object selectedValues) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element select = (Element)domContext.getRootNode();
        Element option = domContext.createElement("option");
        if (optionGroup == null) {
            select.appendChild(option);
        } else {
            optionGroup.appendChild(option);
        }
        String valueString = this.formatComponentValue(facesContext, uiComponent, selectItem.getValue());
        option.setAttribute("value", valueString);
        boolean selected = this.isValueSelected(facesContext, selectItem, uiComponent, submittedValues, selectedValues);
        if ((uiComponent instanceof HtmlSelectOneMenu || uiComponent instanceof HtmlSelectOneListbox) && submittedValues == null && selectedValues == null && (selectItem.getValue() == "" || selectItem.getValue() == null)) {
            selected = true;
        }
        if (selected) {
            option.setAttribute("selected", "selected");
        }
        if (selectItem.isDisabled()) {
            option.setAttribute("disabled", "disabled");
        }
        Document doc = domContext.getDocument();
        String label = selectItem.getLabel();
        Text labelNode = selectItem.isEscape() ? domContext.createTextNode(label == null ? valueString : label) : domContext.createTextNodeUnescaped(label == null ? valueString : label);
        option.appendChild(labelNode);
    }

    protected boolean isValueSelected(FacesContext facesContext, SelectItem selectItem, UIComponent uiComponent, Object[] submittedValues, Object selectedValues) {
        if (submittedValues != null) {
            String valueString = this.formatComponentValue(facesContext, uiComponent, selectItem.getValue());
            return this.isSelected(valueString, submittedValues);
        }
        return this.isSelected(selectItem.getValue(), selectedValues, facesContext, uiComponent);
    }

    void renderSelect(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element root;
        HashSet<String> excludes = new HashSet<String>();
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            root = domContext.createElement("select");
            domContext.setRootNode(root);
            MenuRenderer.setRootElementId(facesContext, root, uiComponent);
            root.setAttribute("name", uiComponent.getClientId(facesContext));
            String styleClass = null;
            styleClass = (String)uiComponent.getAttributes().get("styleClass");
            if (null != styleClass) {
                root.setAttribute("class", styleClass);
            }
            if (!this.getMultipleText(uiComponent).equals("")) {
                root.setAttribute("multiple", "multiple");
            }
        }
        root = (Element)domContext.getRootNode();
        int itemCount = this.countSelectOptionsRecursive(facesContext, uiComponent);
        Object size = uiComponent.getAttributes().get("size");
        if (null == size || size instanceof Integer && ((Integer)size == Integer.MIN_VALUE || (Integer)size == 0)) {
            this.renderSizeAttribute(root, itemCount);
            excludes.add("size");
        } else {
            this.renderSizeAttribute(root, Integer.valueOf(size.toString()));
        }
        Object currentValue = null;
        currentValue = ((UIInput)uiComponent).getSubmittedValue();
        if (null == currentValue) {
            currentValue = "";
        }
        this.addJavaScript(facesContext, uiComponent, root, currentValue.toString(), excludes);
        if (uiComponent instanceof HtmlSelectOneMenu) {
            PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, selectOneMenuPassThruAttributes);
            this.addJavaScriptOverride(facesContext, uiComponent, root, currentValue.toString(), excludes);
        } else if (uiComponent instanceof HtmlSelectManyMenu) {
            PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, selectManyMenuPassThruAttributes);
            this.addJavaScriptOverride(facesContext, uiComponent, root, currentValue.toString(), excludes);
        } else if (uiComponent instanceof HtmlSelectOneListbox) {
            PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, selectOneListboxPassThruAttributes);
            this.addJavaScriptOverride(facesContext, uiComponent, root, currentValue.toString(), excludes);
        } else if (uiComponent instanceof HtmlSelectManyListbox) {
            PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, selectManyListboxPassThruAttributes);
            this.addJavaScriptOverride(facesContext, uiComponent, root, currentValue.toString(), excludes);
        }
        String[] attributes = new String[]{"disabled", "readonly"};
        for (int i = 0; i < attributes.length; ++i) {
            Object attribute = uiComponent.getAttributes().get(attributes[i]);
            if (!(attribute instanceof Boolean) || !((Boolean)attribute).booleanValue()) continue;
            root.setAttribute(attributes[i], attributes[i]);
        }
        excludes.clear();
        domContext.stepInto(uiComponent);
        this.renderOptions(facesContext, uiComponent);
        domContext.stepOver();
    }

    public String getEventType(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlSelectOneListbox) {
            return "onchange";
        }
        if (uiComponent instanceof HtmlSelectOneMenu) {
            return "onchange";
        }
        if (uiComponent instanceof HtmlSelectManyListbox) {
            return "onchange";
        }
        if (uiComponent instanceof HtmlSelectManyMenu) {
            return "onchange";
        }
        if (uiComponent instanceof HtmlSelectManyCheckbox) {
            return "onclick";
        }
        return "";
    }

    int countSelectOptionsRecursive(FacesContext facesContext, UIComponent uiComponent) {
        int counter = 0;
        Iterator selectItems = this.getSelectItems(uiComponent);
        while (selectItems.hasNext()) {
            ++counter;
            SelectItem nextSelectItem = (SelectItem)selectItems.next();
            if (!(nextSelectItem instanceof SelectItemGroup)) continue;
            counter += ((SelectItemGroup)nextSelectItem).getSelectItems().length;
        }
        return counter;
    }

    void renderOptions(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element rootSelectElement = (Element)domContext.getRootNode();
        DOMContext.removeChildrenByTagName(rootSelectElement, "option");
        DOMContext.removeChildrenByTagName(rootSelectElement, "optgroup");
        Iterator selectItems = this.getSelectItems(uiComponent);
        Object[] submittedValues = null;
        Object selectedValues = null;
        if (selectItems.hasNext() && (submittedValues = this.getSubmittedSelectedValues(uiComponent)) == null) {
            selectedValues = this.getCurrentSelectedValues(uiComponent);
        }
        while (selectItems.hasNext()) {
            SelectItem nextSelectItem = (SelectItem)selectItems.next();
            if (nextSelectItem instanceof SelectItemGroup) {
                Element optGroup = domContext.createElement("optgroup");
                rootSelectElement.appendChild(optGroup);
                optGroup.setAttribute("label", nextSelectItem.getLabel());
                domContext.setCursorParent(optGroup);
                SelectItem[] selectItemsArray = ((SelectItemGroup)nextSelectItem).getSelectItems();
                for (int i = 0; i < selectItemsArray.length; ++i) {
                    this.renderOption(facesContext, uiComponent, selectItemsArray[i], optGroup, submittedValues, selectedValues);
                }
                continue;
            }
            this.renderOption(facesContext, uiComponent, nextSelectItem, null, submittedValues, selectedValues);
        }
    }

    boolean isSelected(Object sentinel, Object selectedValues, FacesContext facesContext, UIComponent uiComponent) {
        boolean isSelected = false;
        if (selectedValues == null || sentinel == null) {
            return isSelected;
        }
        String formattedSentinel = this.formatComponentValue(facesContext, uiComponent, sentinel);
        int length = Array.getLength(selectedValues);
        for (int index = 0; index < length; ++index) {
            Object nextSelectedValue = Array.get(selectedValues, index);
            String formattedSelectedValue = this.formatComponentValue(facesContext, uiComponent, nextSelectedValue);
            if (nextSelectedValue == null && sentinel == null) {
                isSelected = true;
                break;
            }
            if (nextSelectedValue != null && nextSelectedValue.equals(sentinel)) {
                isSelected = true;
                break;
            }
            if (sentinel instanceof String) {
                if (this.isConversionMatched(sentinel.toString(), nextSelectedValue)) {
                    isSelected = true;
                    break;
                }
                if (!formattedSelectedValue.equals(sentinel)) continue;
                isSelected = true;
                break;
            }
            if (formattedSelectedValue == null || !formattedSelectedValue.equals(formattedSentinel)) continue;
            isSelected = true;
            break;
        }
        return isSelected;
    }

    boolean isSelected(Object sentinelValue, Object[] selectedValues) {
        boolean valueIsSelected = false;
        if (selectedValues != null) {
            Iterator<Object> selectedValuesIterator = Arrays.asList(selectedValues).iterator();
            while (selectedValuesIterator.hasNext()) {
                if (!selectedValuesIterator.next().equals(sentinelValue)) continue;
                valueIsSelected = true;
                break;
            }
        }
        return valueIsSelected;
    }

    protected void renderSizeAttribute(Element targetElement, int size) throws IOException {
        targetElement.setAttribute("size", "1");
    }

    String getSelectedTextString() {
        return " selected";
    }

    public String getMultipleText(UIComponent component) {
        if (component instanceof UISelectMany) {
            return " multiple ";
        }
        return "";
    }

    protected Object[] getSubmittedSelectedValues(UIComponent uiComponent) {
        UISelectOne uiSelectOne;
        Object submittedValue;
        if (uiComponent instanceof UISelectMany) {
            UISelectMany uiSelectMany = (UISelectMany)uiComponent;
            return (Object[])uiSelectMany.getSubmittedValue();
        }
        if (uiComponent instanceof UISelectOne && (submittedValue = (uiSelectOne = (UISelectOne)uiComponent).getSubmittedValue()) != null) {
            return new Object[]{submittedValue};
        }
        return null;
    }

    protected Object getCurrentSelectedValues(UIComponent uiComponent) {
        UISelectOne uiSelectOne;
        Object currentSelectedValues = null;
        if (uiComponent instanceof UISelectMany) {
            UISelectMany uiSelectMany = (UISelectMany)uiComponent;
            currentSelectedValues = uiSelectMany.getValue();
            if (currentSelectedValues instanceof List) {
                return ((List)currentSelectedValues).toArray();
            }
            return currentSelectedValues;
        }
        if (uiComponent instanceof UISelectOne && (currentSelectedValues = (uiSelectOne = (UISelectOne)uiComponent).getValue()) != null) {
            return new Object[]{currentSelectedValues};
        }
        return null;
    }

    protected Iterator getSelectItems(UIComponent uiComponent) {
        ArrayList<Object> selectItems = new ArrayList<Object>();
        if (uiComponent.getChildCount() == 0) {
            return selectItems.iterator();
        }
        for (UIComponent nextSelectItemChild : uiComponent.getChildren()) {
            SelectItem selectItem;
            Object selectItemsValue;
            if (nextSelectItemChild instanceof UISelectItem) {
                Object selectItemValue = ((UISelectItem)nextSelectItemChild).getValue();
                if (selectItemValue != null && selectItemValue instanceof SelectItem) {
                    selectItems.add(selectItemValue);
                    continue;
                }
                this.assignDataIfNull(nextSelectItemChild);
                selectItems.add(new SelectItem(((UISelectItem)nextSelectItemChild).getItemValue(), ((UISelectItem)nextSelectItemChild).getItemLabel(), ((UISelectItem)nextSelectItemChild).getItemDescription(), ((UISelectItem)nextSelectItemChild).isItemDisabled()));
                continue;
            }
            if (!(nextSelectItemChild instanceof UISelectItems) || (selectItemsValue = ((UISelectItems)nextSelectItemChild).getValue()) == null) continue;
            Object itemLabelEscaped = nextSelectItemChild.getAttributes().get("itemLabelEscaped");
            boolean isItemLabelEscaped = true;
            if (itemLabelEscaped != null) {
                isItemLabelEscaped = Boolean.valueOf(itemLabelEscaped.toString());
            }
            if (selectItemsValue instanceof SelectItem) {
                if (itemLabelEscaped != null) {
                    selectItem = (SelectItem)selectItemsValue;
                    selectItem.setEscape(isItemLabelEscaped);
                }
                selectItems.add(selectItemsValue);
                continue;
            }
            if (selectItemsValue instanceof Collection) {
                for (Object item : (Collection)selectItemsValue) {
                    if (item instanceof SelectItem) {
                        if (itemLabelEscaped != null) {
                            selectItem = (SelectItem)item;
                            selectItem.setEscape(isItemLabelEscaped);
                        }
                        selectItems.add(item);
                        continue;
                    }
                    if (nextSelectItemChild.getAttributes().containsKey("var")) {
                        String var = nextSelectItemChild.getAttributes().get("var").toString();
                        Map map = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
                        Object oldValue = map.put(var, item);
                        String itemLabel = String.valueOf(nextSelectItemChild.getAttributes().get("itemLabel"));
                        Object itemValue = nextSelectItemChild.getAttributes().get("itemValue");
                        selectItem = new SelectItem(itemValue != null ? itemValue : item, itemLabel);
                        selectItem.setEscape(isItemLabelEscaped);
                        selectItems.add(selectItem);
                        continue;
                    }
                    selectItem = new SelectItem(item);
                    selectItem.setEscape(isItemLabelEscaped);
                    selectItems.add(selectItem);
                }
                continue;
            }
            if (selectItemsValue instanceof SelectItem[]) {
                SelectItem[] selectItemArray = (SelectItem[])selectItemsValue;
                for (int i = 0; i < selectItemArray.length; ++i) {
                    if (itemLabelEscaped != null) {
                        selectItemArray[i].setEscape(isItemLabelEscaped);
                    }
                    selectItems.add(selectItemArray[i]);
                }
                continue;
            }
            if (selectItemsValue instanceof Object[]) {
                Map map = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
                for (Object item : (Object[])selectItemsValue) {
                    if (nextSelectItemChild.getAttributes().containsKey("var")) {
                        String var = nextSelectItemChild.getAttributes().get("var").toString();
                        Object oldValue = map.put(var, item);
                        String itemLabel = String.valueOf(nextSelectItemChild.getAttributes().get("itemLabel"));
                        Object itemValue = nextSelectItemChild.getAttributes().get("itemValue");
                        selectItem = new SelectItem(itemValue != null ? itemValue : item, itemLabel);
                        selectItem.setEscape(isItemLabelEscaped);
                        selectItems.add(selectItem);
                        continue;
                    }
                    selectItem = new SelectItem(item);
                    selectItem.setEscape(isItemLabelEscaped);
                    selectItems.add(selectItem);
                }
                continue;
            }
            if (selectItemsValue instanceof Map) {
                for (Object nextKey : ((Map)selectItemsValue).keySet()) {
                    Object nextValue;
                    if (nextKey == null || (nextValue = ((Map)selectItemsValue).get(nextKey)) == null) continue;
                    selectItem = new SelectItem((Object)nextValue.toString(), nextKey.toString());
                    selectItem.setEscape(isItemLabelEscaped);
                    selectItems.add(selectItem);
                }
                continue;
            }
            if (selectItemsValue instanceof String[]) {
                String[] stringItemArray = (String[])selectItemsValue;
                for (int i = 0; i < stringItemArray.length; ++i) {
                    selectItem = new SelectItem((Object)stringItemArray[i]);
                    selectItem.setEscape(isItemLabelEscaped);
                    selectItems.add(selectItem);
                }
                continue;
            }
            if (!(selectItemsValue instanceof Enum[])) continue;
            Enum[] enumArray = (Enum[])selectItemsValue;
            for (int i = 0; i < enumArray.length; ++i) {
                selectItem = new SelectItem((Object)enumArray[i]);
                selectItem.setEscape(isItemLabelEscaped);
                selectItems.add(selectItem);
            }
        }
        return selectItems.iterator();
    }

    private void assignDataIfNull(Object selectItem) {
        UISelectItem uiSelectItem = (UISelectItem)selectItem;
        if (uiSelectItem.getItemValue() == null && uiSelectItem.getItemLabel() != null) {
            uiSelectItem.setItemValue((Object)uiSelectItem.getItemLabel());
        }
        if (uiSelectItem.getItemLabel() == null && uiSelectItem.getItemValue() != null) {
            uiSelectItem.setItemLabel(uiSelectItem.getItemValue().toString());
        }
    }

    protected void addJavaScript(FacesContext facesContext, UIComponent uiComponent, Element root, String currentValue, Set excludes) {
    }

    protected void addJavaScriptOverride(FacesContext facesContext, UIComponent uiComponent, Element root, String currentValue, Set excludes) {
    }

    private boolean isConversionMatched(String sentinel, Object selectedValue) {
        boolean match = false;
        if (sentinel.length() == 0) {
            if (selectedValue == null) {
                match = true;
            }
        } else if (selectedValue instanceof Long) {
            if (selectedValue.equals(Long.valueOf(sentinel))) {
                match = true;
            }
        } else if (selectedValue instanceof Byte) {
            if (selectedValue.equals(Byte.valueOf(sentinel))) {
                match = true;
            }
        } else if (selectedValue instanceof Integer) {
            if (selectedValue.equals(Integer.valueOf(sentinel))) {
                match = true;
            }
        } else if (selectedValue instanceof Short) {
            if (selectedValue.equals(Short.valueOf(sentinel))) {
                match = true;
            }
        } else if (selectedValue instanceof Double) {
            if (selectedValue.equals(Double.valueOf(sentinel))) {
                match = true;
            }
        } else if (selectedValue instanceof Float) {
            if (selectedValue.equals(Float.valueOf(sentinel))) {
                match = true;
            }
        } else if (selectedValue instanceof Boolean && selectedValue.equals(Boolean.valueOf(sentinel))) {
            match = true;
        }
        return match;
    }
}

