/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.style;

import com.icesoft.faces.component.style.OutputStyle;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.util.CoreUtils;
import java.beans.Beans;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OutputStyleRenderer
extends DomBasicRenderer {
    private static Log log = LogFactory.getLog((Class)OutputStyleRenderer.class);
    private static final String IE_EXTENTION = "_ie";
    private static final String IE_7_EXTENTION = "_ie7";
    private static final String SAFARI_EXTENTION = "_safari";
    private static final String CSS_EXTENTION = ".css";
    private static final String DT_EXTENTION = "_dt";
    private static final int DEFAULT_TYPE = 0;
    private static final int IE = 1;
    private static final int SAFARI = 2;
    private static final int DT = 3;
    private static final int IE_7 = 4;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, OutputStyle.class);
        try {
            DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
            if (!domContext.isInitialized()) {
                OutputStyle outputStyle = (OutputStyle)uiComponent;
                Element styleEle = this.buildCssElement(domContext);
                String href = outputStyle.getHref();
                styleEle.setAttribute("href", OutputStyleRenderer.getResourceURL((FacesContext)facesContext, (String)href));
                domContext.setRootNode((Node)styleEle);
                int browserType = this.browserType(facesContext, uiComponent);
                if (browserType != 0) {
                    if (!href.endsWith(CSS_EXTENTION)) throw new RuntimeException("OutputStyle file attribute must end in .css. Current Value is [" + href + "]");
                    int i = href.indexOf(CSS_EXTENTION);
                    if (i <= 0) throw new RuntimeException("OutputStyle file attribute is too short. Needs at least one character before .css. Current Value is [" + href + "]");
                    String start = href.substring(0, i);
                    Element ieStyleEle = this.buildCssElement(domContext);
                    String extention = IE_EXTENTION;
                    if (browserType == 2) {
                        extention = SAFARI_EXTENTION;
                    }
                    if (browserType == 3) {
                        extention = DT_EXTENTION;
                    }
                    if (browserType == 4) {
                        extention = IE_7_EXTENTION;
                    }
                    String hrefURL = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)(start + extention + CSS_EXTENTION));
                    ieStyleEle.setAttribute("href", hrefURL);
                    styleEle.getParentNode().appendChild(ieStyleEle);
                }
            }
            domContext.stepOver();
            domContext.streamWrite(facesContext, uiComponent);
            return;
        }
        catch (Exception e) {
            log.error((Object)"Error in OutputStyleRenderer", (Throwable)e);
        }
    }

    private Element buildCssElement(DOMContext domContext) {
        Element styleEle = domContext.createElement("link");
        styleEle.setAttribute("rel", "stylesheet");
        styleEle.setAttribute("type", "text/css");
        return styleEle;
    }

    private int browserType(FacesContext facesContext, UIComponent uiComponent) {
        int result = 0;
        String useragent = ((OutputStyle)uiComponent).getUserAgent();
        if (useragent != null) {
            return this._browserType(useragent);
        }
        Object o = facesContext.getExternalContext().getRequest();
        if (o != null) {
            if (o instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)o;
                useragent = request.getHeader("user-agent");
                if (useragent == null) {
                    useragent = ((OutputStyle)uiComponent).getUserAgent();
                }
                if (useragent == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Not able to find user agent. Returning default");
                    }
                    return 0;
                }
                if (((OutputStyle)uiComponent).getUserAgent() == null) {
                    ((OutputStyle)uiComponent).setUserAgent(useragent.toLowerCase());
                }
                String user = useragent.toLowerCase();
                result = this._browserType(user);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("OutputStyleRenderer: Request is not HttpServletRequest. Its [" + o.getClass().getName() + "]"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"IceStyleReader: facesContext.getExternalContext().getRequest() is null");
        }
        return result;
    }

    private int _browserType(String user) {
        int result = 0;
        if (Beans.isDesignTime()) {
            result = 3;
        } else if (user.indexOf("msie") != -1) {
            result = 1;
            if (user.indexOf("msie 7") != -1) {
                result = 4;
            }
        } else if (user.indexOf("safari") != -1) {
            result = 2;
        }
        return result;
    }
}

