/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.accordion;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.component.accordion.Accordion;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.JSFUtils;
import org.icemobile.component.IAccordion;
import org.icemobile.renderkit.AccordionCoreRenderer;

public class AccordionRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(AccordionRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        Accordion accordion = (Accordion)component;
        String clientId = accordion.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String indexStr = (String)params.get(clientId + "_hidden");
        if (null != indexStr) {
            String submittedStr = indexStr;
            int ind = indexStr.indexOf(",");
            if (ind > -1) {
                String[] split = indexStr.split(",");
                submittedStr = split[0];
                accordion.setHashVal(indexStr);
            } else {
                accordion.setHashVal(null);
            }
            if (null != submittedStr) {
                String oldId = accordion.getSelectedId();
                String newId = JSFUtils.getIdOfChildByClientId(context, (UIComponent)accordion, indexStr);
                if (null != newId && !newId.equals(oldId)) {
                    accordion.setSelectedId(newId);
                    component.queueEvent((FacesEvent)new ValueChangeEvent(component, (Object)oldId, (Object)newId));
                }
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        IAccordion accordion = (IAccordion)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        AccordionCoreRenderer renderer = new AccordionCoreRenderer();
        renderer.encodeBegin(accordion, writer, false);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        JSFUtils.renderChildren(facesContext, uiComponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        IAccordion accordion = (IAccordion)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        AccordionCoreRenderer renderer = new AccordionCoreRenderer();
        renderer.encodeEnd(accordion, writer, false);
    }
}

