/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.camera;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.camera.Camera;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.renderkit.DeviceCoreRenderer;

public class CameraRenderer
extends Renderer {
    private static Logger logger = Logger.getLogger(CameraRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Camera camera = (Camera)uiComponent;
        String clientId = camera.getClientId();
        try {
            HashMap map;
            boolean valid;
            if (!camera.isDisabled() && (valid = this.extractImages(facesContext, map = new HashMap(), clientId)) && map != null) {
                camera.setValue(map);
                uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean extractImages(FacesContext facesContext, Map map, String clientId) throws IOException {
        return MobiJSFUtils.decodeComponentFile(facesContext, clientId, map);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Camera camera = (Camera)uiComponent;
        String oldLabel = camera.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)camera)) {
            camera.setButtonLabel(camera.getCaptureMessageLabel());
        }
        DeviceCoreRenderer renderer = new DeviceCoreRenderer();
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        renderer.encode(camera, writer, false);
        camera.setButtonLabel(oldLabel);
    }
}

