/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.carousel;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.component.carousel.Carousel;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icemobile.renderkit.CarouselCoreRenderer;

public class CarouselRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(CarouselRenderer.class.getName());
    private static final String JS_NAME = "carousel.js";
    private static final String JS_MIN_NAME = "carousel-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.carousel";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Carousel carousel;
        String clientId;
        String hiddenField;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(hiddenField = (clientId = (carousel = (Carousel)uiComponent).getClientId(facesContext)) + "_hidden")) {
            try {
                Integer selected = Integer.parseInt((String)params.get(hiddenField));
                int old = carousel.getSelectedItem();
                if (old != selected) {
                    carousel.setSelectedItem(selected);
                    uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, (Object)old, (Object)selected));
                    this.decodeBehaviors(facesContext, (UIComponent)carousel);
                }
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Error creating carousel value change event.", e);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        boolean hasBehaviors;
        Carousel carousel = (Carousel)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        this.writeJavascriptFile(facesContext, uiComponent, JS_NAME, JS_MIN_NAME, JS_LIBRARY);
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        CarouselCoreRenderer renderer = new CarouselCoreRenderer();
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", clientId + "_iSlib");
        if (!this.isScriptLoaded(facesContext, "iscroll.js")) {
            renderer.encodeIScrollLib(carousel, writer);
            this.setScriptLoaded(facesContext, "iscroll.js");
        }
        writer.endElement("div");
        renderer.encodeBegin(carousel, writer);
        this.encodeCarouselList(carousel, facesContext);
        boolean bl = hasBehaviors = !carousel.getClientBehaviors().isEmpty();
        if (hasBehaviors) {
            ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
            String behaviors = this.encodeClientBehaviors(facesContext, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            carousel.setBehaviors(behaviors);
        } else {
            carousel.setBehaviors(null);
        }
        renderer.encodeEnd(carousel, writer);
        ((Carousel)uiComponent).setRowIndex(-1);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    private void encodeCarouselList(Carousel carousel, FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (carousel.getVar() != null) {
            carousel.setRowIndex(-1);
            for (int i = 0; i < carousel.getRowCount(); ++i) {
                carousel.setRowIndex(i);
                writer.startElement("li", null);
                this.renderChildren(facesContext, (UIComponent)carousel);
                writer.endElement("li");
            }
        } else if (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER)) {
            logger.finer("Carousel must define the var and value attributes");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

