/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.contentpane;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.api.ContentPaneController;
import org.icefaces.mobi.component.accordion.Accordion;
import org.icefaces.mobi.component.contentpane.ContentPane;
import org.icefaces.mobi.component.contentstack.ContentStack;
import org.icefaces.mobi.component.tabset.TabSet;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.JSFUtils;
import org.icemobile.component.IContentPane;
import org.icemobile.renderkit.AccordionPaneCoreRenderer;
import org.icemobile.renderkit.ContentPaneCoreRenderer;

public class ContentPaneRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(ContentPaneRenderer.class.getName());

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIComponent parent = uiComponent.getParent();
        IContentPane pane = (IContentPane)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        boolean amSelected = this.iAmSelected(facesContext, uiComponent);
        if (parent instanceof Accordion) {
            AccordionPaneCoreRenderer renderer = new AccordionPaneCoreRenderer();
            renderer.encodeBegin(pane, writer, false, amSelected);
        } else if (parent instanceof TabSet) {
            this.encodeTabSetPage(facesContext, uiComponent);
        } else {
            ContentStack stack = (ContentStack)parent;
            ContentPaneCoreRenderer renderer = new ContentPaneCoreRenderer();
            renderer.encodeBegin(pane, writer, amSelected);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ContentPane pane = (ContentPane)uiComponent;
        if (pane.isClient()) {
            JSFUtils.renderChildren(facesContext, uiComponent);
        } else if (this.iAmSelected(facesContext, uiComponent)) {
            JSFUtils.renderChildren(facesContext, uiComponent);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        IContentPane pane = (IContentPane)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        if (pane.isAccordionPane()) {
            AccordionPaneCoreRenderer renderer = new AccordionPaneCoreRenderer();
            renderer.encodeEnd(pane, writer, false);
        } else {
            ContentPaneCoreRenderer crenderer = new ContentPaneCoreRenderer();
            crenderer.encodeEnd(pane, writer);
        }
    }

    private boolean iAmSelected(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent parent = uiComponent.getParent();
        String selectedId = null;
        if (parent instanceof ContentPaneController) {
            ContentPaneController paneController = (ContentPaneController)parent;
            selectedId = paneController.getSelectedId();
            if (null == selectedId) {
                UIComponent pComp = parent;
                logger.warning("Parent controller of contentPane must have value for selectedId=" + pComp.getClientId());
                return false;
            }
        } else {
            logger.warning("Parent must implement ContentPaneController-> has instead=" + parent.getClass().getName());
            return false;
        }
        String id = uiComponent.getId();
        return id.equals(selectedId);
    }

    private void encodeTabSetPage(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        ContentPane pane = (ContentPane)uiComponent;
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_wrapper"), "id");
        String pageClass = "mobi-tabpage-hidden".toString();
        boolean selected = this.iAmSelected(facesContext, uiComponent);
        if (this.iAmSelected(facesContext, uiComponent)) {
            pageClass = "mobi-tabpage";
        }
        writer.writeAttribute("class", (Object)pageClass, "class");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (pane.getStyle() != null) {
            writer.writeAttribute("style", (Object)pane.getStyle(), "style");
        }
        if (pane.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)pane.getStyleClass(), "styleClass");
        }
    }
}

