/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.contentstack;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.contentnavbar.ContentNavBar;
import org.icefaces.mobi.component.contentpane.ContentPane;
import org.icefaces.mobi.component.contentstack.ContentStack;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.utils.JSFUtils;
import org.icefaces.mobi.utils.MobiJSFUtils;

public class ContentStackRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(ContentStackRenderer.class.getName());
    private static final String JS_NAME = "layoutmenu.js";
    private static final String JS_MIN_NAME = "layoutmenu-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.layoutmenu";

    public void decode(FacesContext facesContext, UIComponent component) {
        ContentStack stack = (ContentStack)component;
        String clientId = stack.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String indexStr = (String)params.get(clientId + "_hidden");
        String newStr = (String)params.get(clientId);
        if (newStr != null) {
            logger.info("submitted " + newStr + " from request");
        }
        String oldIndex = stack.getCurrentId();
        if (null != indexStr && !oldIndex.equals(indexStr)) {
            stack.setCurrentId(indexStr);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        ContentStack container = (ContentStack)uiComponent;
        if (container.getContentMenuId() == null && this.hasNavBarChild((UIComponent)container) != null) {
            container.setNavBar(true);
        } else {
            container.setNavBar(false);
        }
        if (container.hasNavBar().booleanValue()) {
            this.writeJavascriptFile(facesContext, uiComponent, JS_NAME, JS_MIN_NAME, JS_LIBRARY);
        }
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (container.getContentMenuId() != null) {
            boolean singleView;
            if (null == container.getSingleView()) {
                UIComponent stackMenuComp = JSFUtils.findChildComponent(uiComponent, container.getContentMenuId());
                if (stackMenuComp != null) {
                    container.setSingleView(true);
                } else {
                    container.setSingleView(false);
                }
            }
            if (singleView = container.getSingleView().booleanValue()) {
                writer.writeAttribute("class", (Object)"mobi-contentStack-container", null);
            }
            writer.startElement("div", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "_panes"), "id");
            if (singleView) {
                writer.writeAttribute("class", (Object)"mobi-contentStack-panes", "class");
            }
        }
        if (container.hasNavBar().booleanValue()) {
            writer.startElement("div", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "_panes"), "id");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        for (UIComponent child : uiComponent.getChildren()) {
            if (child instanceof ContentPane || !logger.isLoggable(Level.FINER)) continue;
            logger.finer("all children must be of type ContentPane");
            return;
        }
        super.renderChildren(facesContext, uiComponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        ContentStack stack = (ContentStack)uiComponent;
        this.encodeHidden(facesContext, uiComponent);
        writer.endElement("div");
        if (stack.getContentMenuId() != null || stack.hasNavBar().booleanValue()) {
            this.encodeScript(facesContext, uiComponent);
            writer.endElement("div");
        }
    }

    private void encodeScript(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        ContentStack stack = (ContentStack)uiComponent;
        String clientId = stack.getClientId(facesContext);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_initScr"), "id");
        writer.startElement("script", uiComponent);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String selectedPaneId = stack.getSelectedId();
        String selectedPaneClientId = null;
        String homeId = null;
        boolean client = false;
        int hashcode = MobiJSFUtils.generateHashCode(stack.getSelectedId());
        UIComponent selPane = stack.findComponent(selectedPaneId);
        StringBuilder sb = new StringBuilder("mobi.layoutMenu.initClient('").append(clientId).append("'");
        sb.append(",{stackId: '").append(clientId).append("'");
        sb.append(",selectedId: '").append(selectedPaneId).append("'");
        sb.append(", single: ").append(stack.getSingleView());
        sb.append(",hash: ").append(hashcode);
        if (null != selPane) {
            selectedPaneClientId = selPane.getClientId(facesContext);
            sb.append(",selClientId: '").append(selectedPaneClientId).append("'");
            client = ((ContentPane)selPane).isClient();
        }
        if (stack.getContentMenuId() != null) {
            UIComponent menu = stack.findComponent(stack.getContentMenuId());
            if (null != menu) {
                homeId = menu.getClientId(facesContext);
            }
            sb.append(",home: '").append(homeId).append("'");
        }
        sb.append(",client: ").append(client);
        sb.append("});");
        writer.write(sb.toString());
        writer.endElement("script");
        writer.endElement("span");
    }

    private UIComponent hasNavBarChild(UIComponent comp) {
        if (comp instanceof ContentNavBar) {
            return comp;
        }
        UIComponent child = null;
        UIComponent retComp = null;
        Iterator children = comp.getFacetsAndChildren();
        while (children.hasNext() && retComp == null) {
            child = (UIComponent)children.next();
            if (child instanceof ContentNavBar) {
                retComp = child;
                break;
            }
            retComp = this.hasNavBarChild(child);
            if (retComp == null) continue;
            break;
        }
        return retComp;
    }
}

