/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.dataview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.icefaces.mobi.component.dataview.ActivationMode;
import org.icefaces.mobi.component.dataview.DataViewBase;
import org.icefaces.mobi.component.dataview.DataViewColumns;
import org.icefaces.mobi.component.dataview.DataViewDetails;
import org.icefaces.mobi.component.dataview.DataViewRenderer;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.component.IDataView;
import org.icemobile.model.DataViewColumnModel;
import org.icemobile.model.DataViewColumnsModel;
import org.icemobile.model.DataViewDataModel;
import org.icemobile.model.DataViewLazyDataModel;
import org.icemobile.model.DataViewListDataModel;
import org.icemobile.model.IndexedIterator;
import org.icemobile.util.ClientDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataView
extends DataViewBase
implements IDataView,
NamingContainer {
    private static Logger logger = Logger.getLogger(DataViewRenderer.class.getName());
    protected static final DataViewDataModel EMPTY_DATA_MODEL = new DataViewListDataModel(Collections.EMPTY_LIST);
    private Map<String, Object> requestMap;
    private boolean decodedActive = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block11: {
            if (!this.isVisitable(context)) {
                return false;
            }
            FacesContext facesContext = context.getFacesContext();
            this.pushComponentToEL(facesContext, null);
            if (!this.decodedActive && ActivationMode.client.equals((Object)this.getActivationMode()) && !context.getFacesContext().getCurrentPhaseId().equals(PhaseId.RESTORE_VIEW)) {
                this.decodeIndex(facesContext);
            }
            try {
                VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
                if (result == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result != VisitResult.ACCEPT) break block11;
                Iterator kids = this.getFacetsAndChildren();
                while (kids.hasNext()) {
                    UIComponent kid = (UIComponent)kids.next();
                    boolean details = kid instanceof DataViewDetails;
                    if (details) {
                        this.initDetailContext(facesContext);
                    }
                    boolean done = kid.visitTree(context, callback);
                    if (details) {
                        this.clearDetailContext(facesContext);
                    }
                    if (!done) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.popComponentFromEL(facesContext);
            }
        }
        return false;
    }

    public void processUpdates(FacesContext context) {
        this.initDetailContext(context);
        super.processUpdates(context);
        this.clearDetailContext(context);
        if (!this.decodedActive) {
            this.decodeIndex(context);
        }
    }

    public void processValidators(FacesContext context) {
        this.initDetailContext(context);
        super.processValidators(context);
        this.clearDetailContext(context);
    }

    public void processDecodes(FacesContext context) {
        if (ActivationMode.client.equals((Object)this.getActivationMode()) && !this.decodedActive) {
            this.decodeIndex(context);
        }
        this.initDetailContext(context);
        super.processDecodes(context);
        this.clearDetailContext(context);
    }

    public Object processSaveState(FacesContext context) {
        this.initDetailContext(context);
        Object o = super.processSaveState(context);
        this.clearDetailContext(context);
        return o;
    }

    public void processRestoreState(FacesContext context, Object state) {
        this.initDetailContext(context);
        super.processRestoreState(context, state);
        this.clearDetailContext(context);
        if (ActivationMode.client.equals((Object)this.getActivationMode()) && !this.decodedActive) {
            this.decodeIndex(context);
        }
    }

    private void decodeIndex(FacesContext context) {
        String indexStr = (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId() + "_active");
        if (indexStr != null && indexStr.length() > 0) {
            int newIndex = Integer.parseInt(indexStr);
            if (newIndex >= 0) {
                this.setActiveRowIndex(newIndex);
            } else {
                this.setActiveRowIndex(null);
            }
        }
        this.decodedActive = true;
    }

    public void clearDetailContext(FacesContext context) {
        this.getRequestMap(context).remove(this.getVar());
    }

    public void initDetailContext(FacesContext context) {
        Integer index = this.getActiveRowIndex();
        if (index != null && index >= 0) {
            this.getRequestMap(context).put(this.getVar(), this.getDataModel().getDataByIndex(index));
        }
    }

    private Map<String, Object> getRequestMap(FacesContext context) {
        if (this.requestMap == null) {
            this.requestMap = context.getExternalContext().getRequestMap();
        }
        return this.requestMap;
    }

    protected DataViewColumns getColumns() {
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof DataViewColumns)) continue;
            return (DataViewColumns)child;
        }
        logger.log(Level.WARNING, "DataView: " + this.getClientId() + " - doesn't have the nessecary 'ace:dataViewColumns' child component.");
        return null;
    }

    protected DataViewDataModel getDataModel() {
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof List) {
                return new DataViewListDataModel((List)value);
            }
            if (value instanceof DataViewLazyDataModel) {
                return (DataViewDataModel)value;
            }
            logger.log(Level.WARNING, "DataView: " + this.getClientId() + " - Invalid type for 'value' attribute.");
            return EMPTY_DATA_MODEL;
        }
        logger.log(Level.WARNING, "DataView: " + this.getClientId() + " - 'value' attribute is null.");
        return EMPTY_DATA_MODEL;
    }

    protected DataViewDetails getDetails() {
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof DataViewDetails)) continue;
            return (DataViewDetails)child;
        }
        logger.log(Level.WARNING, "DataView: " + this.getClientId() + " - doesn't have the nessecary 'ace:dataViewDetails' child component.");
        return null;
    }

    @Override
    public ClientDescriptor getClient() {
        return MobiJSFUtils.getClientDescriptor();
    }

    protected Integer[] getReactiveColumnPriorities() {
        DataViewColumnsModel model = this.getColumns().getModel();
        Integer[] priorities = new Integer[model.size()];
        Integer highest = null;
        ArrayList<Integer> unrenderedIntegers = new ArrayList<Integer>();
        IndexedIterator columnIter = model.iterator();
        while (columnIter.hasNext()) {
            DataViewColumnModel columnModel = (DataViewColumnModel)columnIter.next();
            Integer pri = columnModel.getReactivePriority();
            int index = columnIter.getIndex();
            if (columnModel.isRendered()) {
                priorities[index] = pri;
                if (highest != null && (pri == null || pri <= highest)) continue;
                highest = pri;
                continue;
            }
            unrenderedIntegers.add(index);
        }
        if (highest == null) {
            highest = -1;
        }
        for (int i = 0; i < priorities.length; ++i) {
            Integer pri = priorities[i];
            if (pri != null || unrenderedIntegers.contains(i)) continue;
            priorities[i] = highest = Integer.valueOf(highest + 1);
        }
        Integer[] finalPri = new Integer[model.size()];
        int finalIndex = 0;
        for (int i = 0; i < priorities.length; ++i) {
            if (priorities[i] == null) continue;
            finalPri[finalIndex++] = priorities[i];
        }
        Integer[] trimPri = new Integer[finalIndex];
        for (int i = 0; i < finalPri.length && finalPri[i] != null; ++i) {
            trimPri[i] = finalPri[i];
        }
        return trimPri;
    }
}

