/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.deviceresource;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletRequest;
import org.icefaces.mobi.component.deviceresource.DeviceResource;
import org.icefaces.mobi.utils.Attribute;
import org.icefaces.mobi.utils.JSFUtils;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icemobile.util.CSSUtils;
import org.icemobile.util.ClientDescriptor;
import org.icemobile.util.SXUtils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class DeviceResourceRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static Logger log = Logger.getLogger(DeviceResourceRenderer.class.getName());
    public static final String CSS_LOCATION = "org.icefaces.component.skins";
    public static final String UTIL_RESOURCE = "org.icefaces.component.util";
    public static final String RESOURCE_URL_ERROR = "RES_NOT_FOUND";
    public static final String IOS_APP_ID = "485908934";
    public static final String META_CONTENTTYPE = "<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>";
    public static final String META_VIEWPORT = "<meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0'/>";
    public static final String META_IOS_WEBAPPCAPABLE = "<meta name='apple-mobile-web-app-capable' content='yes'/>";
    public static final String META_IOS_APPSTATUSBAR = "<meta name='apple-mobile-web-app-status-bar-style' content='black'/>";
    public static final String META_IOS_SMARTAPPBANNER = "<meta name='apple-itunes-app' content=\"app-id=%s, app-argument=%s\"/>";
    public static final String LINK_SHORTCUT_ICON = "<link href='%s/resources/images/favicon.ico' rel='shortcut icon' type='image/x-icon'/>";
    public static final String LINK_FAV_ICON = "<link href='%s/resources/images/favicon.ico' rel='icon' type='image/x-icon'/>";
    public static final String SCRIPT_ICEMOBILE = "<script type='text/javascript' src='%s%s/javascript/icemobile.js'></script>";
    public static final String SCRIPT_SIMULATOR = "simulator-interface.js";
    public static final String CSS_SIMULATOR = "simulator.css";

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        FacesContext context = FacesContext.getCurrentInstance();
        if (log.isLoggable(Level.FINER)) {
            log.finer("processEvent for component = " + component.getClass().getName());
        }
        context.getViewRoot().addComponentResource(context, component, "head");
    }

    public void encodeEnd(FacesContext context, UIComponent uiComponent) throws IOException {
        CSSUtils.Theme theme;
        DeviceResource comp = (DeviceResource)uiComponent;
        boolean ios6 = false;
        boolean desktop = false;
        boolean isSimulated = false;
        ClientDescriptor client = ClientDescriptor.getInstance((HttpServletRequest)context.getExternalContext().getRequest());
        ios6 = client.isIOS6();
        if (!ios6) {
            desktop = client.isDesktopBrowser();
        }
        if (desktop) {
            isSimulated = client.isSimulator();
        }
        String contextRoot = context.getExternalContext().getRequestContextPath();
        ResponseWriter writer = context.getResponseWriter();
        writer.write(META_CONTENTTYPE);
        writer.write(String.format(LINK_FAV_ICON, contextRoot));
        writer.write(String.format(LINK_SHORTCUT_ICON, contextRoot));
        if (!desktop) {
            writer.write(META_VIEWPORT);
            if (ios6) {
                writer.write(META_IOS_WEBAPPCAPABLE);
                writer.write(META_IOS_APPSTATUSBAR);
                if (this.isNeedAppBanner(context, comp, client)) {
                    String smartAppMeta = String.format(META_IOS_SMARTAPPBANNER, IOS_APP_ID, SXUtils.getRegisterSXURL(MobiJSFUtils.getRequest(context), "javax.faces.resource/auxupload.txt.jsf"));
                    writer.write(smartAppMeta);
                    context.getAttributes().put("org.icemobile.iosSmartAppBanner", Boolean.TRUE);
                }
            }
        }
        if ((theme = CSSUtils.Theme.getEnum((String)comp.getAttributes().get("theme"))) == null) {
            String targetView = (String)comp.getAttributes().get("view");
            theme = CSSUtils.deriveTheme(targetView, JSFUtils.getRequest());
        }
        if (theme == CSSUtils.Theme.ANDROID || theme == CSSUtils.Theme.HONEYCOMB) {
            theme = CSSUtils.Theme.ANDROID_DARK;
        }
        this.writeOutDeviceStyleSheets(context, comp, theme);
        if (client.isAndroid2OS()) {
            this.writeOverthrow(context);
        }
        if (isSimulated) {
            this.writeSimulatorResources(context, comp, theme);
        }
        this.encodeMarkers(writer, theme, client);
    }

    private void writeOverthrow(FacesContext context) throws IOException {
        Resource ot = context.getApplication().getResourceHandler().createResource("overthrow.js", UTIL_RESOURCE);
        String src = ot.getRequestPath();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    private boolean isNeedAppBanner(FacesContext facesContext, DeviceResource comp, ClientDescriptor client) {
        ProjectStage projectStage = facesContext.getApplication().getProjectStage();
        if (ProjectStage.Development == projectStage) {
            return false;
        }
        return comp.isIncludeIOSSmartAppBanner() && !client.isSXRegistered();
    }

    private void writeOutDeviceStyleSheets(FacesContext facesContext, DeviceResource comp, CSSUtils.Theme theme) throws IOException {
        boolean prod = facesContext.isProjectStage(ProjectStage.Production);
        String cssFile = CSSUtils.getThemeCSSFileName(theme, prod);
        String library = this.deriveLibrary(facesContext.getAttributes());
        Resource resource = facesContext.getApplication().getResourceHandler().createResource(cssFile, library, "text/css");
        String resourceUrl = RESOURCE_URL_ERROR;
        if (resource != null) {
            resourceUrl = facesContext.getExternalContext().encodeResourceURL(resource.getRequestPath());
        } else if (log.isLoggable(Level.WARNING)) {
            log.warning("Warning could not load resource " + library + "/" + (Object)((Object)theme));
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("link", (UIComponent)comp);
        writer.writeAttribute("type", (Object)"text/css", "type");
        writer.writeAttribute("rel", (Object)"stylesheet", "rel");
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, (UIComponent)comp, new Attribute[]{new Attribute("media", null)});
        writer.writeURIAttribute("href", (Object)resourceUrl, "href");
        writer.endElement("link");
    }

    private void writeSimulatorResources(FacesContext facesContext, DeviceResource component, CSSUtils.Theme theme) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Resource simulatorCss = facesContext.getApplication().getResourceHandler().createResource(CSS_SIMULATOR, CSS_LOCATION, "text/css");
        writer.startElement("link", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/css", "type");
        writer.writeAttribute("rel", (Object)"stylesheet", "rel");
        writer.writeURIAttribute("href", (Object)simulatorCss.getRequestPath(), "href");
        writer.endElement("link");
        Resource simulatorScript = facesContext.getApplication().getResourceHandler().createResource(SCRIPT_SIMULATOR, UTIL_RESOURCE);
        String src = simulatorScript.getRequestPath();
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)src, null);
        writer.endElement("script");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)"console.log('Welcome to the Matrix');", null);
        writer.endElement("script");
    }

    public void encodeMarkers(ResponseWriter writer, CSSUtils.Theme theme, ClientDescriptor client) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String markers = " " + theme.fileName() + " ui-mobile";
        if (client.isIE10Browser()) {
            markers = markers + " ie10";
        }
        if (client.isAndroidBrowserOrWebView()) {
            markers = markers + " android-browser";
        }
        if (client.isDesktopBrowser()) {
            markers = markers + " desktop";
        }
        writer.writeText((Object)("document.documentElement.className = document.documentElement.className+'" + markers + "'; if (window.addEventListener) window.addEventListener('load', function() {document.body.className = 'ui-body-c';});"), null);
        writer.endElement("script");
    }

    private String deriveLibrary(Map attributes) {
        String library = (String)attributes.get("library");
        if (library == null) {
            library = CSS_LOCATION;
        }
        return library;
    }
}

