/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.geolocation;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.geolocation.Geolocation;
import org.icefaces.mobi.renderkit.CoreRenderer;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.util.ClientDescriptor;

public class GeolocationRenderer
extends CoreRenderer {
    private static Logger log = Logger.getLogger(GeolocationRenderer.class.getName());
    private static final String JS_NAME = "geolocation.js";
    private static final String JS_MIN_NAME = "geolocation-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.geolocation";
    private final int UNDEFINED_TIMEOUT_VALUE = 0;
    private final int UNDEFINED_MAXAGE_VALUE = 3600;

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Geolocation geolocation = (Geolocation)uiComponent;
        if (geolocation.isDisabled()) {
            return;
        }
        String clientId = geolocation.getClientId();
        try {
            Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
            String nameHidden = clientId + "_field";
            String locationString = String.valueOf(requestParameterMap.get(nameHidden));
            if (null == locationString) {
                log.warning("No Location string present in GEOLocation upload");
                return;
            }
            if ("".equals(locationString)) {
                log.warning("Empty Location string in GEOLocation upload (position not found yet?)");
                return;
            }
            String[] params = locationString.split(",");
            Double[] decoded = new Double[4];
            for (int i = 0; i < params.length; ++i) {
                try {
                    decoded[i] = Double.parseDouble(params[i]);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Malformed geolocation " + i + " " + locationString, e);
                }
            }
            if (null != decoded[0]) {
                geolocation.setLatitude(decoded[0]);
            }
            if (null != decoded[1]) {
                geolocation.setLongitude(decoded[1]);
            }
            if (null != decoded[2]) {
                geolocation.setAltitude(decoded[2]);
            }
            if (null != decoded[3]) {
                geolocation.setDirection(decoded[3]);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error decoding geo-location request paramaters.", e);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Geolocation locator = (Geolocation)uiComponent;
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_locHidden"), null);
        writer.writeAttribute("name", (Object)(clientId + "_field"), null);
        writer.writeAttribute("value", (Object)"", null);
        boolean disabled = locator.isDisabled();
        boolean singleSubmit = locator.isSingleSubmit();
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        if (!disabled) {
            StringBuilder sb = new StringBuilder(255);
            String highPrecision = locator.getEnableHighPrecision();
            boolean includeHighPrecision = "asneeded".equalsIgnoreCase(highPrecision) ? this.sniffDevices() : Boolean.valueOf(highPrecision).booleanValue();
            int maxAge = locator.getMaximumAge();
            int timeout = locator.getTimeout();
            boolean continuous = locator.isContinuousUpdates();
            if (continuous) {
                sb.append("ice.mobi.geolocation.watchLocation('").append(clientId).append("','");
            } else {
                sb.append("ice.mobi.geolocation.getLocation('").append(clientId).append("','");
            }
            sb.append(includeHighPrecision).append("', '");
            sb.append(maxAge).append("', '").append(timeout).append("'); ");
            if (singleSubmit) {
                String ssCall = "ice.se(null, '" + clientId + "');";
                sb.append(ssCall);
            }
            writer.startElement("span", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
            writer.startElement("script", uiComponent);
            writer.write(sb.toString());
            writer.endElement("script");
            writer.endElement("span");
        }
        writer.endElement("span");
    }

    private boolean sniffDevices() {
        ClientDescriptor client = MobiJSFUtils.getClientDescriptor();
        return client.isAndroidOS() & client.isTabletBrowser() || client.isBlackBerryOS() || client.isBlackBerry10OS();
    }
}

