/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.googleanalytics;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.googleanalytics.GoogleAnalytics;
import org.icefaces.mobi.renderkit.CoreRenderer;

public class GoogleAnalyticsRenderer
extends CoreRenderer {
    private static String GAR_NAME = GoogleAnalyticsRenderer.class.getName();
    private static Logger log = Logger.getLogger(GAR_NAME);

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        GoogleAnalytics ga = (GoogleAnalytics)uiComponent;
        String account = ga.getAccount();
        if (account == null && (account = System.getProperty("org.icemobile.googleAnalyticsAccount")) == null) {
            Object warnOnce = facesContext.getExternalContext().getApplicationMap().get(GAR_NAME);
            if (null != warnOnce) {
                return;
            }
            log.warning("The Google Analytics account has not been set for the <mobi:googleAnalytics> tag. Please use the 'account' tag attribute, or the 'org.icemobile.googleAnalyticsAccount' system environment variable. The Google Analytics script will not be generated.");
            facesContext.getExternalContext().getApplicationMap().put(GAR_NAME, GAR_NAME);
            return;
        }
        String domain = ga.getDomain();
        if (domain == null) {
            domain = System.getProperty("org.icemobile.googleAnalyticsDomain");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(this.getScript(account, domain));
        writer.endElement("script");
    }

    private String getScript(String account, String domain) {
        String script = "var _gaq = _gaq || [];";
        script = script + "_gaq.push(['_setAccount', '" + account + "']);";
        if (domain != null && domain.length() > 0) {
            script = script + "_gaq.push(['_setDomainName', '" + domain + "']);";
        }
        script = script + "_gaq.push(['_trackPageview']);(function() {var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);})();";
        return script;
    }
}

