/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.mobisx;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.impl.application.AuxUploadSetup;
import org.icefaces.mobi.component.mobisx.IceMobileSX;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.util.ClientDescriptor;

public class IceMobileSXRenderer
extends Renderer {
    private static Logger logger = Logger.getLogger(IceMobileSXRenderer.class.getName());
    private static String ITUNES_LINK = "http://itunes.apple.com/us/app/icemobile-sx/id485908934?mt=8";

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        ClientDescriptor client = MobiJSFUtils.getClientDescriptor();
        IceMobileSX sx = (IceMobileSX)uiComponent;
        if (client.isIOS() && !client.isSXRegistered() && !client.isICEmobileContainer()) {
            writer.startElement("span", uiComponent);
            writer.startElement("input", uiComponent);
            writer.writeAttribute("type", (Object)"button", "type");
            writer.writeAttribute("id", (Object)clientId, "id");
            StringBuilder baseClass = new StringBuilder("mobi-button mobi-button-important ");
            String styleClass = sx.getStyleClass();
            if (styleClass != null) {
                baseClass.append(" ").append(styleClass);
            }
            writer.writeAttribute("class", (Object)baseClass.toString(), null);
            String style = sx.getStyle();
            if (style != null && style.trim().length() > 0) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            String value = "Enable";
            Object oVal = sx.getValue();
            if (null != oVal) {
                value = oVal.toString();
            }
            writer.writeAttribute("value", (Object)value, "value");
            String sessionIdParam = MobiJSFUtils.getSessionIdCookie(facesContext);
            String uploadURL = AuxUploadSetup.getInstance().getUploadURL();
            StringBuilder sb = new StringBuilder("mobi.registerAuxUpload('");
            sb.append(sessionIdParam).append("','").append(uploadURL).append("');");
            writer.writeAttribute("onclick", (Object)sb.toString(), "onclick");
            writer.endElement("input");
            if (0 == uiComponent.getChildCount()) {
                writer.startElement("a", uiComponent);
                writer.writeAttribute("href", (Object)ITUNES_LINK, null);
                writer.writeText((Object)"ICEmobile-SX", null);
                writer.endElement("a");
                writer.writeText((Object)" Surf Expander.", null);
            }
            writer.endElement("span");
        }
    }
}

