/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.viewselector;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.FacetHandler;
import javax.faces.view.facelets.Tag;
import org.icefaces.mobi.component.viewselector.ViewSelector;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.util.ClientDescriptor;

public class ViewSelectorHandler
extends ComponentHandler {
    private static final Logger logger = Logger.getLogger(ViewSelectorHandler.class.getName());

    public ViewSelectorHandler(ComponentConfig componentConfig) {
        super(componentConfig);
        Tag tag = componentConfig.getTag();
    }

    public void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        super.onComponentCreated(ctx, c, parent);
    }

    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        if (c instanceof ViewSelector) {
            String facetName = this.returnFacetNameToInclude(ctx, c);
            if (this.nextHandler instanceof CompositeFaceletHandler) {
                FaceletHandler[] h = ((CompositeFaceletHandler)this.nextHandler).getHandlers();
                for (int i = 0; i < h.length; ++i) {
                    if (h[i] instanceof FacetHandler) {
                        FacetHandler faceHand = (FacetHandler)h[i];
                        String name = faceHand.getFacetName(ctx);
                        if (!facetName.equals(name)) continue;
                        h[i].apply(ctx, c);
                        break;
                    }
                    logger.warning("ViewSelector must have children that are facets - see docs");
                }
            } else {
                logger.warning(" ViewSelector requires 2 facets to be defined - see docs");
            }
        }
    }

    protected String returnFacetNameToInclude(FaceletContext ctx, UIComponent c) {
        FacesContext facesContext = ctx.getFacesContext();
        Map contextMap = facesContext.getAttributes();
        if ((String)contextMap.get("mobile_view_type") != null) {
            return (String)contextMap.get("mobile_view_type");
        }
        String name = null;
        String defaultView = null;
        ViewSelector v = (ViewSelector)c;
        String defView = v.getDefaultView();
        if (defView != null) {
            defaultView = String.valueOf(defView);
            if (defaultView.equals("large") || defaultView.equals("small")) {
                name = defaultView.equals("large") ? "large" : "small";
                contextMap.put("mobile_view_type", name);
            } else {
                logger.warning("Must have 2 facets for ViewSelector named see docs");
            }
        } else {
            name = (String)contextMap.get("mobile_view_type");
            if (name == null) {
                ClientDescriptor client = MobiJSFUtils.getClientDescriptor();
                if (client.isTabletBrowser() || client.isDesktopBrowser()) {
                    name = "large";
                } else if (client.isHandheldBrowser()) {
                    name = "small";
                }
                if (name != null) {
                    contextMap.put("mobile_view_type", name);
                } else {
                    logger.warning("Cannot determine device type. problem with View selection");
                }
            }
        }
        return name;
    }
}

