/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.viewselector;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.viewselector.ViewSelector;
import org.icefaces.mobi.utils.JSFUtils;

public class ViewSelectorRenderer
extends Renderer {
    private static Logger logger = Logger.getLogger(ViewSelectorRenderer.class.getName());

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ViewSelector viewSelector = (ViewSelector)component;
        Map contextMap = facesContext.getAttributes();
        if (!contextMap.containsKey("mobile_view_type")) {
            logger.info("Error:- handler has not been able to determine type of view");
            return;
        }
        String name = (String)contextMap.get("mobile_view_type");
        if (viewSelector.getFacet("large") != null || viewSelector.getFacet("small") != null) {
            if ("small".equals(name)) {
                UIComponent viewFacet = viewSelector.getFacet("small");
                if (viewFacet != null) {
                    JSFUtils.renderChild(facesContext, viewFacet);
                } else {
                    logger.warning("Small view detected but no small Facet defined in viewSelector element.");
                }
            } else if ("large".equals(name)) {
                UIComponent viewFacet = viewSelector.getFacet("large");
                if (viewFacet != null) {
                    JSFUtils.renderChild(facesContext, viewFacet);
                } else {
                    logger.warning("Large view detected but no large Facet defined in viewSelector element.");
                }
            }
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

