/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.impl.application.AuxUploadSetup;
import org.icefaces.impl.util.CoreUtils;
import org.icefaces.impl.util.DOMUtils;
import org.icefaces.util.EnvUtils;
import org.icemobile.util.ClientDescriptor;
import org.icemobile.util.SXUtils;
import org.icemobile.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobiJSFUtils {
    private static Logger logger = Logger.getLogger(Utils.class.getName());
    static String COOKIE_FORMAT = "org.icemobile.cookieformat";
    private static Map<String, String> CONTENT_TYPES = new HashMap<String, String>();

    public static HttpServletRequest getRequest(FacesContext facesContext) {
        return (HttpServletRequest)facesContext.getExternalContext().getRequest();
    }

    public static ClientDescriptor getClientDescriptor() {
        HttpServletRequest request = MobiJSFUtils.getRequest(FacesContext.getCurrentInstance());
        ClientDescriptor client = ClientDescriptor.getInstance(request);
        return client;
    }

    public static boolean decodeComponentFile(FacesContext facesContext, String clientId, Map fileMeta) throws IOException {
        String simulatedFile;
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        boolean isValid = false;
        String partUploadName = clientId;
        Part part = null;
        InputStream fileStream = null;
        String contentType = null;
        Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
        try {
            part = request.getPart(partUploadName);
            if (null == part) {
                part = (Part)auxMap.get(partUploadName);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (null == part) {
            Map commonsMeta = (Map)request.getAttribute("org.icemobile.file." + clientId);
            if (null == commonsMeta) {
                commonsMeta = (Map)auxMap.get("org.icemobile.file." + clientId);
            }
            if (null != commonsMeta) {
                contentType = (String)commonsMeta.get("contentType");
                fileStream = (InputStream)commonsMeta.get("stream");
            }
        }
        if (null != part) {
            contentType = part.getContentType();
            fileStream = part.getInputStream();
        }
        String fileName = Long.toString(Math.abs(UUID.randomUUID().getMostSignificantBits()), 32);
        String fileExtension = Utils.FILE_EXT_BY_CONTENT_TYPE.get(contentType);
        if (null == contentType && null != (simulatedFile = request.getParameter(partUploadName))) {
            fileExtension = simulatedFile.substring(simulatedFile.lastIndexOf("."));
            contentType = CONTENT_TYPES.get(fileExtension);
            fileStream = MobiJSFUtils.class.getClassLoader().getResourceAsStream("META-INF/resources/org.icefaces.component.skins/simulator/" + simulatedFile);
        }
        fileName = null != fileExtension ? fileName + fileExtension : fileName + ".oth";
        isValid = MobiJSFUtils.createMapOfFile(fileMeta, request, fileStream, fileName, contentType, facesContext);
        return isValid;
    }

    public static boolean createMapOfFile(Map map, HttpServletRequest request, InputStream fileStream, String fileName, String contentType, FacesContext facesContext) throws IOException {
        String UPLOADS_FOLDER = "uploads";
        String FILE_SEPARATOR = System.getProperty("file.separator");
        String folder = CoreUtils.getRealPath((FacesContext)facesContext, (String)FILE_SEPARATOR);
        String sessionId = CoreUtils.getSessionId((FacesContext)facesContext);
        String relativePath = "";
        if (sessionId != null && sessionId.length() > 0) {
            relativePath = relativePath + FILE_SEPARATOR + "uploads" + FILE_SEPARATOR + sessionId + FILE_SEPARATOR + fileName;
            folder = folder + "uploads" + FILE_SEPARATOR + sessionId + FILE_SEPARATOR;
        } else {
            relativePath = relativePath + "uploads" + FILE_SEPARATOR + fileName;
            folder = folder + "uploads" + FILE_SEPARATOR;
        }
        File dirFile = new File(folder);
        File newFile = new File(dirFile, fileName);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        try {
            Utils.copyStream(fileStream, new FileOutputStream(newFile));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error writing uploaded file to disk ", e);
        }
        map.put("file", newFile);
        map.put("contentType", contentType);
        map.put("relativePath", relativePath);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("wrote " + newFile.getAbsolutePath());
        }
        return newFile.length() > 0L;
    }

    public static boolean uploadInProgress(UIComponent comp) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String partUploadName = comp.getClientId(facesContext);
        return MobiJSFUtils.uploadInProgress(partUploadName);
    }

    public static boolean uploadInProgress(String clientId) {
        Map auxMap = AuxUploadResourceHandler.pollAuxRequestMap();
        if (null == auxMap) {
            return false;
        }
        boolean inProgress = auxMap.containsKey(clientId) || auxMap.containsKey("org.icemobile.file." + clientId);
        return inProgress;
    }

    public static String getICEmobileSXScript(String command, Map<String, String> params, UIComponent comp) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        String sessionID = MobiJSFUtils.getSessionIdCookie(facesContext);
        return SXUtils.getICEmobileSXScript(request, command, params, comp.getClientId(facesContext), sessionID, "javax.faces.resource/auxupload.txt.jsf");
    }

    public static String getICEmobileSXScript(String command, UIComponent comp) {
        return MobiJSFUtils.getICEmobileSXScript(command, null, comp);
    }

    public static String getSessionIdCookie() {
        return MobiJSFUtils.getSessionIdCookie(FacesContext.getCurrentInstance());
    }

    public static String getSessionIdCookie(FacesContext facesContext) {
        String sessionID = EnvUtils.getSafeSession((FacesContext)facesContext).getId();
        String cookieFormat = (String)facesContext.getExternalContext().getInitParameterMap().get(COOKIE_FORMAT);
        if (null == cookieFormat) {
            return sessionID;
        }
        StringBuilder out = new StringBuilder();
        Formatter cookieFormatter = new Formatter(out);
        cookieFormatter.format(cookieFormat, sessionID);
        cookieFormatter.close();
        return out.toString();
    }

    public static String getICEmobileRegisterSXScript() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String sessionIdParam = MobiJSFUtils.getSessionIdCookie(facesContext);
        String uploadURL = AuxUploadSetup.getInstance().getUploadURL();
        return "mobi.registerAuxUpload('" + sessionIdParam + "','" + uploadURL + "');";
    }

    public static String getPostURL() {
        return AuxUploadSetup.getInstance().getUploadURL();
    }

    public static int generateHashCode(Object value) {
        int hashCode = 0;
        if (value != null) {
            hashCode = value.toString().hashCode();
        }
        return hashCode;
    }

    public static String asParameterString(List<UIParameter> children) {
        StringBuffer builder = new StringBuffer();
        builder.append("function(p){");
        for (UIParameter param : children) {
            builder.append("p('" + DOMUtils.escapeAnsi((String)param.getName()) + "'").append(",'").append(DOMUtils.escapeAnsi((String)((String)param.getValue())).replace(' ', '+')).append("');");
        }
        builder.append("}");
        return builder.toString();
    }

    public static String asParameterStringForMobiAjax(List<UIParameter> children) {
        if (children.isEmpty()) {
            return "{}";
        }
        StringBuffer builder = new StringBuffer();
        builder.append("{");
        boolean first = true;
        for (UIParameter param : children) {
            if (!first) {
                builder.append(", ");
            }
            builder.append("'").append(DOMUtils.escapeAnsi((String)param.getName())).append("'");
            builder.append(": '").append(DOMUtils.escapeAnsi((String)((String)param.getValue())).replace(' ', '+')).append("'");
            first = false;
        }
        builder.append("}");
        return builder.toString();
    }

    static {
        CONTENT_TYPES.put(".png", "image/png");
        CONTENT_TYPES.put(".jpg", "image/jpg");
        CONTENT_TYPES.put(".mp3", "audio/mp3");
        CONTENT_TYPES.put(".mp4", "video/mp4");
    }
}

