/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.application;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.icemobile.application.AbstractResource;
import org.icemobile.application.ResourceStore;

public class ByteArrayResource
extends AbstractResource {
    private byte[] bytes;
    private ResourceStore<ByteArrayResource> store;

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public void delete() {
        this.bytes = null;
        if (this.store != null) {
            this.store.remove(this);
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setStore(ResourceStore store) {
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputStream(InputStream stream) {
        ByteArrayOutputStream bos = null;
        try {
            int len;
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String toString() {
        return "ByteArrayResource [bytes=" + this.contentLength() + ", store=" + this.store + ", id=" + this.id + ", contentType=" + this.contentType + ", token=" + this.token + ", name=" + this.name + ", uuid=" + this.uuid + "]";
    }

    public long contentLength() {
        return this.bytes == null ? 0L : (long)this.bytes.length;
    }
}

