/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.icemobile.application.AbstractResource;
import org.icemobile.application.ResourceStore;

public class FileResource
extends AbstractResource {
    private File wrappedFile;
    private ResourceStore<FileResource> store;

    public File getFile() {
        return this.wrappedFile;
    }

    public void setFile(File file) {
        this.wrappedFile = file;
    }

    public void delete() {
        if (this.wrappedFile.exists()) {
            this.wrappedFile.delete();
        }
        if (this.store != null) {
            this.store.remove(this);
        }
    }

    public void setStore(ResourceStore store) {
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputStream(InputStream is) {
        FileOutputStream fos = null;
        try {
            int len;
            fos = new FileOutputStream(this.wrappedFile);
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public InputStream getInputStream() {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.wrappedFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return stream;
    }

    public String toString() {
        return "FileResource [wrappedFile=" + this.wrappedFile + ", store=" + this.store + ", id=" + this.id + ", contentType=" + this.contentType + ", token=" + this.token + ", name=" + this.name + ", uuid=" + this.uuid + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long contentLength() {
        if (this.wrappedFile == null) {
            return 0L;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.wrappedFile);
            long result = is.getChannel().size();
            is.close();
            long l = result;
            return l;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            long l = 0L;
            return l;
        }
        catch (IOException e) {
            e.printStackTrace();
            long l = 0L;
            return l;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

