/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.impl.application;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import org.icepush.PushContext;

public class PushBackOffPhaseListener
implements PhaseListener {
    private static final Logger log = Logger.getLogger(PushBackOffPhaseListener.class.getName());

    public void afterPhase(PhaseEvent phaseEvent) {
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        String browserID;
        FacesContext facesContext = phaseEvent.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (PhaseId.RENDER_RESPONSE == phaseEvent.getPhaseId() && null != (browserID = PushBackOffPhaseListener.getBrowserID(facesContext))) {
            try {
                PushContext pushContext = PushContext.getInstance((ServletContext)((ServletContext)externalContext.getContext()));
                pushContext.backOff(browserID, 300L);
            }
            catch (Throwable t) {
                log.log(Level.FINE, "pushContext.backOff failed ", t);
            }
        }
    }

    private static String getBrowserID(FacesContext facesContext) {
        Cookie cookie;
        ExternalContext externalContext = facesContext.getExternalContext();
        Map cookies = externalContext.getRequestCookieMap();
        if (cookies != null && null != (cookie = (Cookie)cookies.get("ice.push.browser"))) {
            return cookie.getValue();
        }
        return null;
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

