/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.ICarousel;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.ClientDescriptor;

public class CarouselCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(CarouselCoreRenderer.class.toString());
    StringBuilder baseClass = new StringBuilder("mobi-carousel");
    StringBuilder scrollerClass = new StringBuilder("mobi-carousel-scroller");
    StringBuilder listClass = new StringBuilder("mobi-carousel-list");
    StringBuilder pagClass = new StringBuilder("");

    public void encodeBegin(ICarousel component, IResponseWriter writer) throws IOException {
        String userDefinedClass = component.getStyleClass();
        if (userDefinedClass != null) {
            this.baseClass.append(" ").append(userDefinedClass);
            this.scrollerClass.append(" ").append(userDefinedClass);
            this.listClass.append(" ").append(userDefinedClass);
            this.pagClass.append(" ").append(userDefinedClass);
        }
        String clientId = component.getClientId();
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId);
        writer.writeAttribute("style", "overflow-x: hidden");
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId + "_carousel");
        this.writeStandardLayoutAttributes(writer, component, this.baseClass.toString());
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId + "_scroller");
        writer.writeAttribute("class", this.scrollerClass.toString());
        writer.startElement("ul", component);
        writer.writeAttribute("id", clientId + "_lister");
        writer.writeAttribute("class", this.listClass.toString());
    }

    public void encodeEnd(ICarousel carousel, IResponseWriter writer) throws IOException {
        String nextLabel;
        String clientId = carousel.getClientId();
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", carousel);
        writer.writeAttribute("id", clientId + "_dots");
        String prevLabel = carousel.getPreviousLabel();
        if (prevLabel != null && !prevLabel.toString().equals("null") && prevLabel.toString().length() > 0) {
            this.renderPagination(carousel, writer, String.valueOf(prevLabel), clientId, "prev");
        }
        if ((nextLabel = carousel.getNextLabel()) != null && !nextLabel.toString().equals("null") && nextLabel.toString().length() > 0) {
            this.renderPagination(carousel, writer, String.valueOf(nextLabel), clientId, "next");
        }
        writer.startElement("div", carousel);
        writer.writeAttribute("class", "mobi-carousel-cursor  ui-bar-b");
        writer.writeAttribute("style", carousel.getStyle());
        writer.startElement("div", carousel);
        writer.writeAttribute("class", "mobi-carousel-cursor-center");
        writer.startElement("ul", null);
        writer.writeAttribute("id", clientId + "_ullist");
        writer.writeAttribute("class", "mobi-carousel-cursor-list ");
        int size = carousel.getRowCount();
        int selected = carousel.getSelectedItem();
        if (selected > size - 1 || selected < 0) {
            selected = 0;
        }
        for (int i = 0; i < size; ++i) {
            writer.startElement("li", null);
            writer.writeText(String.valueOf(i + 1));
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div");
        writer.writeAttribute("id", clientId + "_upd");
        writer.writeAttribute("name", clientId + "_upd");
        this.encodeHiddenSelected(writer, clientId, selected, carousel.getName());
        this.renderScript(carousel, writer);
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderPagination(ICarousel carousel, IResponseWriter writer, String value, String id, String ind) throws IOException {
        String call = "ice.mobi.carousel.scrollTo('";
        ClientDescriptor cd = carousel.getClient();
        String eventStr = this.isTouchEventEnabled(cd) ? "ontouchstart" : "onclick";
        writer.startElement("input", carousel);
        writer.writeAttribute("type", "button");
        writer.writeAttribute("class", "button");
        if (ind.equals("next")) {
            writer.writeAttribute("style", "float: right;");
        }
        writer.writeAttribute("id", id + "_" + ind);
        StringBuilder prevBuilder = new StringBuilder(call).append(id).append("', '").append(ind).append("'); return false");
        writer.writeAttribute(eventStr, prevBuilder.toString());
        writer.writeAttribute("value", value);
        writer.endElement("input");
    }

    public void encodeIScrollLib(ICarousel carousel, IResponseWriter writer) throws IOException {
        String src = carousel.getIScrollSrc();
        super.writeExternalScript(carousel, writer, src);
    }

    private void renderScript(ICarousel carousel, IResponseWriter writer) throws IOException {
        writer.startElement("span", carousel);
        String clientId = carousel.getClientId();
        writer.writeAttribute("id", clientId + "_script");
        writer.writeAttribute("class", "mobi-hidden");
        writer.startElement("script", null);
        writer.writeAttribute("type", "text/javascript");
        StringBuilder scriptSB = new StringBuilder("setTimeout(function () {ice.mobi.carousel.loaded('");
        scriptSB.append(clientId).append("'");
        StringBuilder cfg = carousel.getJSConfigOptions();
        if (null != cfg) {
            scriptSB.append((CharSequence)cfg);
        }
        scriptSB.append(");").append("}, 100);");
        writer.writeText(scriptSB.toString());
        writer.endElement("script");
        writer.endElement("span");
    }
}

