/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import org.icemobile.component.IContactList;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.ClientDescriptor;

public class ContactListCoreRenderer
extends BaseCoreRenderer {
    public void encode(IContactList component, IResponseWriter writer) throws IOException {
        String sessionId;
        String postURL;
        String clientId = component.getClientId();
        ClientDescriptor cd = component.getClient();
        writer.startElement("input");
        writer.writeAttribute("id", clientId);
        writer.writeAttribute("type", "button");
        boolean targetAudience = cd.isICEmobileContainer() | cd.isSXRegistered();
        if (!targetAudience) {
            component.setDisabled(true);
        }
        this.writeStandardAttributes(writer, component, "mobi-button ui-btn-up-c", " mobi-button-dis");
        StringBuilder args = new StringBuilder();
        String fields = component.getFields();
        if (fields != null && !"".equals(fields)) {
            if (args.length() > 0) {
                args.append("&");
            }
            args.append("fields=").append(fields);
        }
        writer.writeAttribute("data-command", "fetchContacts");
        writer.writeAttribute("data-id", clientId);
        if (args.length() > 0) {
            writer.writeAttribute("data-params", args.toString());
        }
        if (null != (postURL = component.getPostURL())) {
            writer.writeAttribute("data-postURL", postURL);
        }
        if (null != (sessionId = component.getSessionId())) {
            writer.writeAttribute("data-jsessionid", sessionId);
        }
        writer.writeAttribute("onclick", "ice.mobi.invoke(this)");
        writer.writeAttribute("value", component.getButtonLabel());
        writer.endElement("input");
    }
}

