/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IMenuButton;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;

public class MenuButtonCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(MenuButtonCoreRenderer.class.toString());

    public void encodeBegin(IMenuButton menu, IResponseWriter writer) throws IOException {
        String style;
        String clientId = menu.getClientId();
        writer.startElement("div", menu);
        writer.writeAttribute("id", clientId);
        StringBuilder baseClass = new StringBuilder("mobi-menu-btn");
        StringBuilder buttonClass = new StringBuilder("mobi-menu-btn-btn mobi-button ui-btn-up-c");
        StringBuilder selectClass = new StringBuilder("mobi-menu-btn-menu");
        String userDefinedClass = menu.getStyleClass();
        if (null != userDefinedClass) {
            baseClass.append(userDefinedClass);
            selectClass.append(userDefinedClass);
            buttonClass.append(userDefinedClass);
        }
        if (menu.isDisabled()) {
            baseClass.append("mobi-button-dis");
        }
        writer.writeAttribute("class", baseClass.toString());
        writer.startElement("span", menu);
        writer.writeAttribute("class", buttonClass.toString());
        writer.writeAttribute("id", clientId + "_btn");
        writer.startElement("span", menu);
        String selectLabel = menu.getButtonLabel();
        writer.write(selectLabel);
        writer.endElement("span");
        writer.endElement("span");
        if (menu.isDisabled()) {
            writer.writeAttribute("disabled", "disabled");
        }
        writer.startElement("select", menu);
        writer.writeAttribute("id", clientId + "_sel");
        if (null == menu.getName()) {
            writer.writeAttribute("name", clientId + "_sel");
        } else {
            writer.writeAttribute("name", menu.getName());
        }
        writer.writeAttribute("class", selectClass);
        if (!menu.isDisabled()) {
            writer.writeAttribute("onchange", "ice.mobi.menubutton.select('" + clientId + "');");
        }
        if (null != menu.getStyle() && (style = menu.getStyle()).trim().length() > 0) {
            writer.writeAttribute("style", style);
        }
    }

    public void encodeEnd(IMenuButton button, IResponseWriter writer) throws IOException {
        writer.endElement("select");
        writer.endElement("div");
    }

    private void encodeInitScript(IMenuButton button, IResponseWriter writer) throws IOException {
        String clientId = button.getClientId();
        writer.startElement("span", button);
        writer.writeAttribute("id", clientId + "_initScr");
        writer.writeAttribute("class", "mobi-hidden");
        writer.startElement("script", button);
        writer.writeAttribute("type", "text/javascript");
        StringBuilder sb = new StringBuilder("ice.mobi.menubutton.initmenu('");
        sb.append(clientId).append("'");
        if (null != button.getSelectTitle()) {
            sb.append(",").append("{ selectTitle: '").append(button.getSelectTitle()).append("'});");
        } else {
            sb.append(");");
        }
        writer.write(sb.toString());
        writer.endElement("script");
        writer.endElement("span");
    }

    public void encodeSelectTitle(IMenuButton item, IResponseWriter writer) throws IOException {
        writer.startElement("option", item);
        writer.writeAttribute("value", "");
        writer.write(item.getSelectTitle());
        writer.endElement("option");
    }
}

