/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IThumbnail;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.ClientDescriptor;

public class ThumbnailCoreRenderer {
    private static final Logger logger = Logger.getLogger(ThumbnailCoreRenderer.class.toString());

    public void encode(IThumbnail component, IResponseWriter writer) throws IOException {
        String clientId = component.getClientId();
        ClientDescriptor cd = component.getClient();
        if (cd.isDesktopBrowser()) {
            return;
        }
        boolean renderThumbnail = false;
        if (cd.isICEmobileContainer() || cd.isSXRegistered()) {
            renderThumbnail = true;
        }
        if (!renderThumbnail) {
            return;
        }
        String thumbId = component.getMFor() + "-thumb";
        writer.startElement("span", component);
        String styleClass = component.getBaseClass();
        if (component.getStyleClass() != null) {
            styleClass = styleClass + " " + component.getStyleClass();
        }
        writer.writeAttribute("class", styleClass);
        String style = component.getStyle();
        if (style != null) {
            writer.writeAttribute("style", style);
        }
        writer.startElement("img", component);
        writer.writeAttribute("width", "64");
        writer.writeAttribute("height", "64");
        writer.writeAttribute("id", thumbId);
        writer.endElement("img");
        writer.endElement("span");
    }
}

