/*
 * Copyright 2004-2012 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 *
 */
package org.icepush.util;

import java.util.Observable;

public class Slot extends Observable {
    private Object value;

    public Slot(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
        setChanged();
        super.notifyObservers(value);
        clearChanged();
    }

    public long getLongValue() {
        return (Long) value;
    }

    public void setLongValue(long value) {
        setValue(value);
    }

    public int getIntegerValue() {
        return (Integer) value;
    }

    public void setLongValue(int value) {
        setValue(value);
    }

    public String getStringValue() {
        return (String) value;
    }

    public void setStringValue(String value) {
        setValue(value);
    }

    public boolean getBooleanValue() {
        return (Boolean) value;
    }

    public void setBooleanValue(boolean value) {
        setValue(value);
    }
}
