/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.FontFactory;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.util.Defs;

public class FontManager {
    private static final Logger logger = Logger.getLogger(FontManager.class.toString());
    private static ArrayList<Object[]> fontList;
    private static int PLAIN;
    private static int BOLD;
    private static int ITALIC;
    private static int BOLD_ITALIC;
    private static final String[][] TYPE1_FONT_DIFFS;
    private static final String[] JAPANESE_FONT_NAMES;
    private static final String[] CHINESE_SIMPLIFIED_FONT_NAMES;
    private static final String[] CHINESE_TRADITIONAL_FONT_NAMES;
    private static final String[] KOREAN_FONT_NAMES;
    private static String[] SYSTEM_FONT_PATHS;
    private static FontManager fontManager;

    public static FontManager getInstance() {
        if (fontManager == null) {
            fontManager = new FontManager();
        }
        return fontManager;
    }

    public Properties getFontProperties() {
        if (fontList == null) {
            this.readSystemFonts(null);
        }
        Properties properties = new Properties();
        for (Object[] objectArray : fontList) {
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            Integer n = (Integer)objectArray[2];
            String string3 = (String)objectArray[3];
            properties.put(string, string2 + "|" + n + "|" + string3);
        }
        return properties;
    }

    public void setFontProperties(Properties properties) throws IllegalArgumentException {
        String string = "Error parsing font properties ";
        try {
            fontList = new ArrayList(150);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                StringTokenizer stringTokenizer = new StringTokenizer((String)properties.get(string2), "|");
                String string3 = stringTokenizer.nextToken();
                Integer n = new Integer(stringTokenizer.nextToken());
                String string4 = stringTokenizer.nextToken();
                if (string2 != null && string3 != null && string4 != null) {
                    fontList.add(new Object[]{string2, string3, n, string4});
                    continue;
                }
                throw new IllegalArgumentException(string);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "Error setting font properties ", throwable);
            throw new IllegalArgumentException(string);
        }
    }

    public void clearFontList() {
        if (fontList != null) {
            fontList.clear();
        }
    }

    public void readSystemFonts(String[] stringArray) {
        int n;
        String[] stringArray2;
        if (fontList == null) {
            fontList = new ArrayList(150);
        }
        if (stringArray == null) {
            stringArray2 = SYSTEM_FONT_PATHS;
        } else {
            n = SYSTEM_FONT_PATHS.length + stringArray.length;
            stringArray2 = new String[n];
            System.arraycopy(SYSTEM_FONT_PATHS, 0, stringArray2, 0, SYSTEM_FONT_PATHS.length);
            System.arraycopy(stringArray, 0, stringArray2, SYSTEM_FONT_PATHS.length, stringArray.length);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Reading system fonts:");
        }
        for (n = stringArray2.length - 1; n >= 0; --n) {
            File file;
            String string = stringArray2[n];
            if (string == null || !(file = new File(string)).canRead()) continue;
            String[] stringArray3 = file.list();
            for (int i = stringArray3.length - 1; i >= 0; --i) {
                FontFile fontFile;
                String string2 = stringArray3[i];
                StringBuffer stringBuffer = new StringBuffer(25);
                stringBuffer.append(file.getAbsolutePath()).append(File.separatorChar).append(string2);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Trying to load font file: " + stringBuffer);
                }
                if ((fontFile = this.buildFont(stringBuffer.toString())) == null) continue;
                string2 = fontFile.getName().toLowerCase();
                fontList.add(new Object[]{fontFile.getName().toLowerCase(), FontManager.normalizeString(fontFile.getFamily()), FontManager.guessFontStyle(string2), stringBuffer.toString()});
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("Adding system font: " + fontFile.getName() + " " + stringBuffer.toString());
            }
        }
    }

    public static String guessFamily(String string) {
        String string2 = string;
        int n = string2.indexOf(44);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.lastIndexOf(45)) > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public String[] getAvailableNames() {
        if (fontList != null) {
            String[] stringArray = new String[fontList.size()];
            Iterator<Object[]> iterator = fontList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object[] objectArray = iterator.next();
                stringArray[n] = objectArray[0].toString();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public String[] getAvailableFamilies() {
        if (fontList != null) {
            String[] stringArray = new String[fontList.size()];
            Iterator<Object[]> iterator = fontList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object[] objectArray = iterator.next();
                stringArray[n] = objectArray[1].toString();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public String[] getAvailableStyle() {
        if (fontList != null) {
            String[] stringArray = new String[fontList.size()];
            Iterator<Object[]> iterator = fontList.iterator();
            String string = "";
            int n = 0;
            while (iterator.hasNext()) {
                Object[] objectArray = iterator.next();
                int n2 = (Integer)objectArray[2];
                if ((n2 & BOLD_ITALIC) == BOLD_ITALIC) {
                    string = string + " BoldItalic";
                } else if ((n2 & BOLD) == BOLD) {
                    string = string + " Bold";
                } else if ((n2 & ITALIC) == ITALIC) {
                    string = string + " Italic";
                } else if ((n2 & PLAIN) == PLAIN) {
                    string = string + " Plain";
                }
                stringArray[n] = string;
                string = "";
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public FontFile getJapaneseInstance(String string, int n) {
        return this.getAsianInstance(string, JAPANESE_FONT_NAMES, n);
    }

    public FontFile getKoreanInstance(String string, int n) {
        return this.getAsianInstance(string, KOREAN_FONT_NAMES, n);
    }

    public FontFile getChineseTraditionalInstance(String string, int n) {
        return this.getAsianInstance(string, CHINESE_TRADITIONAL_FONT_NAMES, n);
    }

    public FontFile getChineseSimplifiedInstance(String string, int n) {
        return this.getAsianInstance(string, CHINESE_SIMPLIFIED_FONT_NAMES, n);
    }

    private FontFile getAsianInstance(String string, String[] stringArray, int n) {
        if (fontList == null) {
            this.readSystemFonts(null);
        }
        FontFile fontFile = null;
        if (stringArray != null) {
            int n2;
            for (n2 = stringArray.length - 1; n2 >= 0; --n2) {
                fontFile = this.findFont(string, n);
                if (fontFile == null) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Font Substitution: Found Asian font: " + fontFile.getName() + " for named font " + string);
                }
                return fontFile;
            }
            for (n2 = stringArray.length - 1; n2 >= 0; --n2) {
                fontFile = this.findFont(stringArray[n2], n);
                if (fontFile == null) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Font Substitution: Found Asian font: " + fontFile.getName() + " for named font " + string);
                }
                return fontFile;
            }
        }
        return fontFile;
    }

    public FontFile getInstance(String string, int n) {
        FontFile fontFile;
        if (fontList == null) {
            this.readSystemFonts(null);
        }
        if ((fontFile = this.getType1Fonts(string, n)) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Font Substitution: Found type1 font: " + fontFile.getName() + " for named font " + string);
            }
            return fontFile;
        }
        fontFile = this.findFont(string, n);
        if (fontFile != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Font Substitution: Found system font: " + fontFile.getName() + " for named font " + string);
            }
            return fontFile;
        }
        fontFile = this.getCoreJavaFont(string, n);
        if (fontFile != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Font Substitution: Found java font: " + fontFile.getName() + " for named font " + string);
            }
            return fontFile;
        }
        if (fontList.size() > 0) {
            Object[] objectArray = fontList.get(0);
            fontFile = this.buildFont((String)objectArray[3]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Font Substitution: Found failed " + string + " " + fontFile.getName());
            }
        }
        if (fontFile == null && logger.isLoggable(Level.FINE)) {
            logger.fine("No Fonts can be found on your system. ");
        }
        return fontFile;
    }

    private FontFile findFont(String string, int n) {
        FontFile fontFile = null;
        int n2 = FontManager.guessFontStyle(string);
        String string2 = FontManager.normalizeString(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Finding known fot list for " + string);
        }
        if (fontList != null) {
            for (int i = fontList.size() - 1; i >= 0; --i) {
                Object[] objectArray = fontList.get(i);
                String string3 = (String)objectArray[0];
                String string4 = (String)objectArray[1];
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(string3 + " : " + string4 + "  : " + string2);
                }
                if (string2.indexOf(string4) < 0 && string.toLowerCase().indexOf(string3) < 0) continue;
                int n3 = (Integer)objectArray[2];
                boolean bl = false;
                if (!(string3.equals("opensymbol") || string3.equals("starsymbol") || string3.equals("arial-black") || string3.equals("arial-blackitalic") || string3.indexOf("timesnewromanps") >= 0)) {
                    if ((n2 & BOLD_ITALIC) == BOLD_ITALIC && (n3 & BOLD_ITALIC) == BOLD_ITALIC) {
                        bl = true;
                    } else if ((n2 & BOLD) == BOLD && (n3 & BOLD) == BOLD) {
                        bl = true;
                    } else if ((n2 & ITALIC) == ITALIC && (n3 & ITALIC) == ITALIC) {
                        bl = true;
                    } else if ((n2 & PLAIN) == PLAIN && (n3 & PLAIN) == PLAIN) {
                        bl = true;
                    } else if (string3.indexOf("wingdings") >= 0 || string3.indexOf("zapfdingbats") >= 0 || string3.indexOf("symbol") >= 0) {
                        bl = true;
                    }
                }
                if (!bl) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("----> Found " + string3 + " : " + this.getFontSytle(n3, 0));
                }
                if ((fontFile = this.buildFont((String)objectArray[3])) != null) break;
            }
        }
        return fontFile;
    }

    private FontFile buildFont(String string) {
        FontFile fontFile = null;
        try {
            File file = new File(string);
            if (!file.canRead()) {
                return null;
            }
            FontFactory fontFactory = FontFactory.getInstance();
            if (string.endsWith(".ttf") || string.endsWith(".TTF") || string.endsWith(".dfont") || string.endsWith(".DFONT") || string.endsWith(".ttc") || string.endsWith(".TTC")) {
                fontFile = fontFactory.createFontFile(file, 0);
            } else if (string.endsWith(".pfa") || string.endsWith(".PFA") || string.endsWith(".pfb") || string.endsWith(".PFB")) {
                fontFile = fontFactory.createFontFile(file, 1);
            } else if (string.endsWith(".otf") || string.endsWith(".OTF") || string.endsWith(".otc") || string.endsWith(".OTC")) {
                fontFile = fontFactory.createFontFile(file, 5);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "Error reading font program.", throwable);
        }
        return fontFile;
    }

    private FontFile getCoreJavaFont(String string, int n) {
        int n2 = FontManager.guessFontStyle(string);
        FontFile fontFile = (string = FontManager.normalizeString(string)).indexOf("timesnewroman") >= 0 || string.indexOf("bodoni") >= 0 || string.indexOf("garamond") >= 0 || string.indexOf("minionweb") >= 0 || string.indexOf("stoneserif") >= 0 || string.indexOf("georgia") >= 0 || string.indexOf("bitstreamcyberbit") >= 0 ? this.findFont("lucidabright-" + this.getFontSytle(n2, n), 0) : (string.indexOf("helvetica") != -1 || string.indexOf("arial") != -1 || string.indexOf("trebuchet") != -1 || string.indexOf("avantgardegothic") != -1 || string.indexOf("verdana") != -1 || string.indexOf("univers") != -1 || string.indexOf("futura") != -1 || string.indexOf("stonesans") != -1 || string.indexOf("gillsans") != -1 || string.indexOf("akzidenz") != -1 || string.indexOf("frutiger") != -1 || string.indexOf("grotesk") != -1 ? this.findFont("lucidasans-" + this.getFontSytle(n2, n), 0) : (string.indexOf("courier") != -1 || string.indexOf("couriernew") != -1 || string.indexOf("prestige") != -1 || string.indexOf("eversonmono") != -1 ? this.findFont("lucidasanstypewriter-" + this.getFontSytle(n2, n), 0) : this.findFont("lucidabright-" + this.getFontSytle(n2, n), 0)));
        return fontFile;
    }

    private FontFile getType1Fonts(String string, int n) {
        FontFile fontFile = null;
        boolean bl = false;
        boolean bl2 = true;
        int n2 = TYPE1_FONT_DIFFS.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = TYPE1_FONT_DIFFS[i].length;
            for (int j = 0; j < n3; ++j) {
                if (TYPE1_FONT_DIFFS[i][0].indexOf(string) < 0) continue;
                if (bl2) {
                    fontFile = this.findFont(TYPE1_FONT_DIFFS[i][1], n);
                    if (fontFile != null) {
                        bl = true;
                        break;
                    }
                    bl2 = false;
                }
                if ((fontFile = this.findFont(TYPE1_FONT_DIFFS[i][j], n)) == null) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        return fontFile;
    }

    private static int guessFontStyle(String string) {
        string = string.toLowerCase();
        int n = 0;
        n = string.indexOf("boldital") > 0 || string.indexOf("demiital") > 0 ? (n |= BOLD_ITALIC) : (string.indexOf("bold") > 0 || string.indexOf("black") > 0 || string.indexOf("demi") > 0 ? (n |= BOLD) : (string.indexOf("ital") > 0 || string.indexOf("obli") > 0 ? (n |= ITALIC) : (n |= PLAIN)));
        return n;
    }

    private String getFontSytle(int n, int n2) {
        String string = "";
        if ((n & BOLD_ITALIC) == BOLD_ITALIC) {
            string = string + " BoldItalic";
        } else if ((n & BOLD) == BOLD) {
            string = string + " Bold";
        } else if ((n & ITALIC) == ITALIC) {
            string = string + " Italic";
        } else if ((n & PLAIN) == PLAIN) {
            string = string + " Plain";
        }
        return string;
    }

    private static String normalizeString(String string) {
        string = FontManager.guessFamily(string);
        StringBuffer stringBuffer = new StringBuffer(string.toLowerCase());
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != ' ') continue;
            stringBuffer.deleteCharAt(i);
            --i;
        }
        return stringBuffer.toString();
    }

    static {
        PLAIN = -268435455;
        BOLD = -268435440;
        ITALIC = -268435200;
        BOLD_ITALIC = -268431360;
        TYPE1_FONT_DIFFS = new String[][]{{"Bookman-Demi", "URWBookmanL-DemiBold", "Arial"}, {"Bookman-DemiItalic", "URWBookmanL-DemiBoldItal", "Arial"}, {"Bookman-Light", "URWBookmanL-Ligh", "Arial"}, {"Bookman-LightItalic", "URWBookmanL-LighItal", "Arial"}, {"Courier", "NimbusMonL-Regu", "Nimbus Mono L", "CourierNew", "CourierNewPSMT"}, {"Courier-Oblique", "NimbusMonL-ReguObli", "Nimbus Mono L", "Courier,Italic", "CourierNew-Italic", "CourierNew,Italic", "CourierNewPS-ItalicMT"}, {"Courier-Bold", "NimbusMonL-Bold", "Nimbus Mono L", "Courier,Bold", "CourierNew,Bold", "CourierNew-Bold", "CourierNewPS-BoldMT"}, {"Courier-BoldOblique", "NimbusMonL-BoldObli", "Nimbus Mono L", "Courier,BoldItalic", "CourierNew-BoldItalic", "CourierNew,BoldItalic", "CourierNewPS-BoldItalicMT"}, {"AvantGarde-Book", "URWGothicL-Book", "Arial"}, {"AvantGarde-BookOblique", "URWGothicL-BookObli", "Arial"}, {"AvantGarde-Demi", "URWGothicL-Demi", "Arial"}, {"AvantGarde-DemiOblique", "URWGothicL-DemiObli", "Arial"}, {"Helvetica", "Arial", "ArialMT", "NimbusSanL-Regu", "Nimbus Sans L"}, {"Helvetica-Oblique", "NimbusSanL-ReguItal", "Nimbus Sans L", "Helvetica,Italic", "Helvetica-Italic", "Arial,Italic", "Arial-Italic", "Arial-ItalicMT"}, {"Helvetica-Bold", "Helvetica,Bold", "Arial,Bold", "Arial-Bold", "Arial-BoldMT", "NimbusSanL-Bold", "Nimbus Sans L"}, {"Helvetica-BoldOblique", "NimbusSanL-BoldItal", "Helvetica-BlackOblique", "Nimbus Sans L", "Helvetica,BoldItalic", "Helvetica-BoldItalic", "Arial,BoldItalic", "Arial-BoldItalic", "Arial-BoldItalicMT"}, {"Helvetica-Black", "Helvetica,Bold", "Arial,Bold", "Arial-Bold", "Arial-BoldMT", "NimbusSanL-Bold", "Nimbus Sans L"}, {"Helvetica-BlackOblique", "NimbusSanL-BoldItal", "Helvetica-BlackOblique", "Nimbus Sans L", "Helvetica,BoldItalic", "Helvetica-BoldItalic", "Arial,BoldItalic", "Arial-BoldItalic", "Arial-BoldItalicMT"}, {"Helvetica-Narrow", "NimbusSanL-ReguCond", "Nimbus Sans L"}, {"Helvetica-Narrow-Oblique", "NimbusSanL-ReguCondItal", "Nimbus Sans L"}, {"Helvetica-Narrow-Bold", "NimbusSanL-BoldCond", "Nimbus Sans L"}, {"Helvetica-Narrow-BoldOblique", "NimbusSanL-BoldCondItal", "Nimbus Sans L"}, {"Helvetica-Condensed", "NimbusSanL-ReguCond", "Nimbus Sans L"}, {"Helvetica-Condensed-Oblique", "NimbusSanL-ReguCondItal", "Nimbus Sans L"}, {"Helvetica-Condensed-Bold", "NimbusSanL-BoldCond", "Nimbus Sans L"}, {"Helvetica-Condensed-BoldOblique", "NimbusSanL-BoldCondItal", "Nimbus Sans L"}, {"Palatino-Roman", "URWPalladioL-Roma", "Arial"}, {"Palatino-Italic", "URWPalladioL-Ital", "Arial"}, {"Palatino-Bold", "URWPalladioL-Bold", "Arial"}, {"Palatino-BoldItalic", "URWPalladioL-BoldItal", "Arial"}, {"NewCenturySchlbk-Roman", "CenturySchL-Roma", "Arial"}, {"NewCenturySchlbk-Italic", "CenturySchL-Ital", "Arial"}, {"NewCenturySchlbk-Bold", "CenturySchL-Bold", "Arial"}, {"NewCenturySchlbk-BoldItalic", "CenturySchL-BoldItal", "Arial"}, {"Times-Roman", "NimbusRomNo9L-Regu", "Nimbus Roman No9 L", "TimesNewRoman", "TimesNewRomanPS", "TimesNewRomanPSMT"}, {"Times-Italic", "NimbusRomNo9L-ReguItal", "Nimbus Roman No9 L", "TimesNewRoman,Italic", "TimesNewRoman-Italic", "TimesNewRomanPS-Italic", "TimesNewRomanPS-ItalicMT"}, {"Times-Bold", "NimbusRomNo9L-Medi", "Nimbus Roman No9 L", "TimesNewRoman,Bold", "TimesNewRoman-Bold", "TimesNewRomanPS-Bold", "TimesNewRomanPS-BoldMT"}, {"Times-BoldItalic", "NimbusRomNo9L-MediItal", "Nimbus Roman No9 L", "TimesNewRoman,BoldItalic", "TimesNewRoman-BoldItalic", "TimesNewRomanPS-BoldItalic", "TimesNewRomanPS-BoldItalicMT"}, {"Symbol", "StandardSymL", "Standard Symbols L"}, {"ZapfChancery-MediumItalic", "URWChanceryL-MediItal", "Arial"}, {"ZapfDingbats", "Dingbats", "Zapf-Dingbats"}};
        JAPANESE_FONT_NAMES = new String[]{"Arial Unicode MS", "PMingLiU", "MingLiU", "MS PMincho", "MS Mincho", "Kochi Mincho", "Hiragino Mincho Pro", "KozMinPro Regular Acro", "HeiseiMin W3 Acro", "Adobe Ming Std Acro"};
        CHINESE_SIMPLIFIED_FONT_NAMES = new String[]{"Arial Unicode MS", "PMingLiU", "MingLiU", "SimSun", "NSimSun", "Kochi Mincho", "STFangsong", "STSong Light Acro", "Adobe Song Std Acro"};
        CHINESE_TRADITIONAL_FONT_NAMES = new String[]{"Arial Unicode MS", "PMingLiU", "MingLiU", "SimSun", "NSimSun", "Kochi Mincho", "BiauKai", "MSungStd Light Acro", "Adobe Song Std Acro"};
        KOREAN_FONT_NAMES = new String[]{"Arial Unicode MS", "Gulim", "Batang", "BatangChe", "HYSMyeongJoStd Medium Acro", "Adobe Myungjo Std Acro"};
        SYSTEM_FONT_PATHS = new String[]{"c:\\windows\\fonts\\", "d:\\windows\\fonts\\", "e:\\windows\\fonts\\", "f:\\windows\\fonts\\", "c:\\winnt\\Fonts\\", "d:\\winnt\\Fonts\\", "c:\\cygwin\\usr\\share\\ghostscript\\fonts\\", "d:\\cygwin\\usr\\share\\ghostscript\\fonts\\", "/Network/Library/Fonts/", "/System/Library/Fonts/", "/System Folder/Fonts", "/usr/local/share/ghostscript/", "/Applications/GarageBand.app/Contents/Resources/", "/Applications/NeoOffice.app/Contents/share/fonts/truetype/", "/Library/Dictionaries/Shogakukan Daijisen.dictionary/Contents/", "/Library/Dictionaries/Shogakukan Progressive English-Japanese Japanese-English Dictionary.dictionary/Contents/", "/Library/Dictionaries/Shogakukan Ruigo Reikai Jiten.dictionary/Contents/", "/Library/Fonts/", "/Volumes/Untitled/WINDOWS/Fonts/", "/usr/share/enscript/", "/usr/share/groff/1.19.2/font/devps/generate/", "/usr/X11/lib/X11/fonts/Type1/", "/usr/X11/lib/X11/fonts/TrueType/", "/usr/X11/lib/X11/fonts/", "/etc/fonts/", "/system/etc/fonts/", "/usr/lib/X11/fonts", "/usr/share/a2ps/afm/", "/usr/share/enscript/afm/", "/usr/share/fonts/local/", "/usr/share/fonts/truetype/", "/usr/share/fonts/truetype/freefont/", "/usr/share/fonts/truetype/msttcorefonts/", "/usr/share/fonts/Type1/", "/usr/share/fonts/type1/gsfonts/", "/usr/share/fonts/X11/Type1/", "/usr/share/ghostscript/fonts/", "/usr/share/groff/1.18.1/font/devps/", "/usr/share/groff/1.18.1/font/devps/generate/", "/usr/share/libwmf/fonts/", "/usr/share/ogonkify/afm/", "/usr/X11R6/lib/X11/fonts/", "/var/lib/defoma/gs.d/dirs/fonts/", "/usr/openwin/lib/locale/ar/X11/fonts/TrueType/", "/usr/openwin/lib/locale/euro_fonts/X11/fonts/TrueType/", "/usr/openwin/lib/locale/hi_IN.UTF-8/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_13/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_15/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_2/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_2/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_4/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_5/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_5/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_7/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_7/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_8/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_8/X11/fonts/Type1/", "/usr/openwin/lib/locale/iso_8859_8/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_9/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_9/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/ja//X11/fonts/TrueType/", "/usr/openwin/lib/locale/K0I8-R/X11/fonts/TrueType/", "/usr/openwin/lib/locale/ru.ansi-1251/X11/fonts/TrueType/", "/usr/openwin/lib/locale/th_TH/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh.GBK/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh_CN.GB18030/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh_TW.BIG5/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh_TW/X11/fonts/TrueType/", "/usr/openwin/lib/X11/fonts/", "/usr/openwin/lib/X11/fonts/F3/afm/", "/usr/openwin/lib/X11/fonts/misc/", "/usr/openwin/lib/X11/fonts/TrueType/", "/usr/openwin/lib/X11/fonts/Type1/", "/usr/openwin/lib/X11/fonts/Type1/afm/", "/usr/openwin/lib/X11/fonts/Type1/outline/", "/usr/openwin/lib/X11/fonts/Type1/sun/", "/usr/openwin/lib/X11/fonts/Type1/sun/afm/", "/usr/sfw/share/a2ps/afm/", "/usr/sfw/share/ghostscript/fonts/", "/usr/sfw/share/ghostscript/fonts/", Defs.sysProperty("java.home") + "/lib/fonts"};
    }
}

