/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.color.ColorSpace;
import org.icepdf.core.util.ColorSpaceWrapper;

public class ColorSpaceCMYK
extends ColorSpace {
    private static final String[] NAMES = new String[]{"Cyan", "Magenta", "Yellow", "Black"};
    private static final ColorSpace COLOR_SPACE_sRGB = ColorSpaceWrapper.getColorSpaceInstance(1000);
    private float[] _rgbValues = new float[4];

    public ColorSpaceCMYK() {
        super(9, 4);
    }

    public int getNumComponents() {
        return 4;
    }

    public String getName(int n) {
        return NAMES[n];
    }

    public int getType() {
        return 9;
    }

    public boolean isCS_sRGB() {
        return false;
    }

    public float[] fromRGB(float[] fArray) {
        float f = 1.0f - fArray[0];
        float f2 = 1.0f - fArray[1];
        float f3 = 1.0f - fArray[2];
        float f4 = Math.min(f, Math.min(f2, f3));
        float f5 = Math.max(f, Math.max(f2, f3));
        if (f5 > f4) {
            f4 = f4 * f4 * f4 / (f5 * f5);
        }
        float[] fArray2 = new float[]{f -= f4, f2 -= f4, f3 -= f4, f4};
        return fArray2;
    }

    public float[] toRGB(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        f += f4;
        f2 += f4;
        f3 += f4;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        f = 1.0f - f;
        f2 = 1.0f - f2;
        f3 = 1.0f - f3;
        float[] fArray2 = new float[4];
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
        return fArray;
    }

    public float[] fromCIEXYZ(float[] fArray) {
        return this.fromRGB(COLOR_SPACE_sRGB.fromCIEXYZ(fArray));
    }

    public float[] toCIEXYZ(float[] fArray) {
        return COLOR_SPACE_sRGB.toCIEXYZ(this.toRGB(fArray));
    }
}

