/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.toString());
    private static long lastMemUsed = 0L;

    public static void setIntIntoByteArrayBE(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >>> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n >>> 0 & 0xFF);
    }

    public static void setShortIntoByteArrayBE(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s >>> 8 & 0xFF);
        byArray[n + 1] = (byte)(s >>> 0 & 0xFF);
    }

    public static long readLongWithVaryingBytesBE(InputStream inputStream, int n) throws IOException {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            int n2 = inputStream.read();
            if (n2 < 0) {
                throw new EOFException();
            }
            l <<= 8;
            l |= (long)n2 & 0xFFL;
        }
        return l;
    }

    public static int readIntWithVaryingBytesBE(InputStream inputStream, int n) throws IOException {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = inputStream.read();
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 <<= 8;
            n2 |= n3 & 0xFF;
        }
        return n2;
    }

    public static String convertByteArrayToHexString(byte[] byArray, boolean bl) {
        return Utils.convertByteArrayToHexString(byArray, 0, byArray.length, bl, -1, '\u0000');
    }

    public static String convertByteArrayToHexString(byte[] byArray, boolean bl, int n, char c) {
        return Utils.convertByteArrayToHexString(byArray, 0, byArray.length, bl, n, c);
    }

    public static String convertByteArrayToHexString(byte[] byArray, int n, int n2, boolean bl, int n3, char c) {
        int n4 = n2 * (bl ? 3 : 2);
        if (n3 > 0) {
            n4 += n2 / n3;
        }
        StringBuffer stringBuffer = new StringBuffer(n4);
        int n5 = 0;
        int n6 = n + n2;
        for (int i = n; i < n6; ++i) {
            int n7 = 0;
            String string = Integer.toHexString(n7 |= 0xFF & byArray[i]);
            for (int j = string.length(); j < 2; ++j) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append(' ');
            }
            if (n3 <= 0 || ++n5 != n3) continue;
            n5 = 0;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static boolean reflectGraphicsEnvironmentISHeadlessInstance(Object object, boolean bl) {
        try {
            Object object2;
            Class<?> clazz = object.getClass();
            Method method = clazz.getMethod("isHeadlessInstance", new Class[0]);
            if (method != null && (object2 = method.invoke(object, new Object[0])) instanceof Boolean) {
                return (Boolean)object2;
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "ImageCache: Java 1.4 Headless support not found.");
        }
        return bl;
    }

    public static String getContentAndReplaceInputStream(InputStream[] inputStreamArray, boolean bl) {
        String string = null;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            InputStream inputStream = inputStreamArray[0];
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            if (!(inputStream instanceof SeekableInput)) {
                inputStream.close();
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = null;
            inputStreamArray[0] = new ByteArrayInputStream(byArray2);
            string = bl ? Utils.convertByteArrayToHexString(byArray2, true) : new String(byArray2);
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Problem getting debug string");
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "Problem getting content stream, skipping");
        }
        return string;
    }

    public static String getContentFromSeekableInput(SeekableInput seekableInput, boolean bl) {
        String string = null;
        try {
            int n;
            long l = seekableInput.getAbsolutePosition();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = seekableInput.getInputStream().read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            seekableInput.seekAbsolute(l);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            string = bl ? Utils.convertByteArrayToHexString(byArray, true) : new String(byArray);
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Problem getting debug string");
        }
        return string;
    }

    public static SeekableInput replaceInputStreamWithSeekableInput(InputStream inputStream) {
        if (inputStream instanceof SeekableInput) {
            return (SeekableInput)((Object)inputStream);
        }
        SeekableByteArrayInputStream seekableByteArrayInputStream = null;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            seekableByteArrayInputStream = new SeekableByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Problem getting debug string");
        }
        return seekableByteArrayInputStream;
    }

    public static void printMemory(String string) {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        System.out.println("MEM  " + string + "    used: " + l3 / 1024L + " KB    delta: " + (l3 - lastMemUsed) / 1024L + " KB");
        lastMemUsed = l3;
    }

    public static int numBytesToHoldBits(int n) {
        int n2 = n / 8;
        if (n % 8 > 0) {
            ++n2;
        }
        return n2;
    }
}

