/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.events.PaintPageEvent;
import org.icepdf.core.events.PaintPageListener;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SequenceInputStream;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.Thumbnail;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.AnnotationState;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.ContentParser;
import org.icepdf.core.util.GraphicsRenderingHints;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.MemoryManageable;
import org.icepdf.core.util.MemoryManager;
import org.icepdf.core.util.Utils;
import org.icepdf.core.views.common.TextSelectionPageHandler;
import org.icepdf.core.views.swing.PageViewComponentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
extends Dictionary
implements MemoryManageable {
    private static final Logger logger = Logger.getLogger(Page.class.toString());
    public static final Name ANNOTS_KEY = new Name("Annots");
    public static final Name CONTENTS_KEY = new Name("Contents");
    public static final int BOUNDARY_MEDIABOX = 1;
    public static final int BOUNDARY_CROPBOX = 2;
    public static final int BOUNDARY_BLEEDBOX = 3;
    public static final int BOUNDARY_TRIMBOX = 4;
    public static final int BOUNDARY_ARTBOX = 5;
    private boolean isInited = false;
    private Resources resources;
    private ArrayList<Annotation> annotations;
    private Vector<Stream> contents;
    private Shapes shapes = null;
    private Vector<PaintPageListener> paintPageListeners = new Vector(8);
    private PRectangle mediaBox;
    private PRectangle cropBox;
    private PRectangle bleedBox;
    private PRectangle trimBox;
    private PRectangle artBox;
    private float pageRotation = 0.0f;

    public Page(Library l, Hashtable h) {
        super(l, h);
    }

    protected synchronized void dispose(boolean cache) {
        if (this.isInited) {
            this.isInited = false;
            if (this.annotations != null) {
                this.annotations.clear();
                this.annotations.trimToSize();
            }
            if (this.contents != null) {
                for (Stream stream : this.contents) {
                    stream.dispose(cache);
                }
                this.contents.clear();
                this.contents.trimToSize();
            }
            if (this.shapes != null) {
                this.shapes.dispose();
                this.shapes = null;
            }
            if (this.resources != null) {
                this.resources.dispose(cache, this);
                this.resources = null;
            }
            if (cache) {
                this.library.removeObject(this.getPObjectReference());
                Object tmp = this.entries.get(ANNOTS_KEY.getName());
                if (tmp != null && tmp instanceof Vector) {
                    Vector annots = (Vector)tmp;
                    for (Object ref : annots) {
                        if (!(ref instanceof Reference)) continue;
                        this.library.removeObject((Reference)ref);
                    }
                }
            }
        }
        if (this.paintPageListeners != null) {
            this.paintPageListeners.clear();
            this.paintPageListeners.trimToSize();
        }
    }

    public boolean isInitiated() {
        return this.isInited;
    }

    private void initPageContents() throws InterruptedException {
        Object pageContent = this.library.getObject(this.entries, CONTENTS_KEY.getName());
        if (pageContent instanceof Stream) {
            this.contents = new Vector(1);
            Stream tmpStream = (Stream)pageContent;
            tmpStream.setPObjectReference(this.library.getObjectReference(this.entries, CONTENTS_KEY.getName()));
            this.contents.addElement(tmpStream);
        } else if (pageContent instanceof Vector) {
            Vector conts = (Vector)pageContent;
            int sz = conts.size();
            this.contents = new Vector(Math.max(sz, 1));
            for (int i = 0; i < sz; ++i) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Page Content initialization thread interrupted");
                }
                Stream tmpStream = (Stream)this.library.getObject((Reference)conts.elementAt(i));
                if (tmpStream == null) continue;
                tmpStream.setPObjectReference((Reference)conts.elementAt(i));
                this.contents.addElement(tmpStream);
            }
        }
    }

    private void initPageResources() throws InterruptedException {
        Resources res = this.library.getResources(this.entries, "Resources");
        if (res == null) {
            for (PageTree pt = this.getParent(); pt != null; pt = pt.getParent()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Page Resource initialization thread interrupted");
                }
                Resources parentResources = pt.getResources();
                if (parentResources == null) continue;
                res = parentResources;
                break;
            }
        }
        this.resources = res;
        if (this.resources != null) {
            this.resources.addReference(this);
        }
    }

    private void initPageAnnotations() throws InterruptedException {
        Object annots = this.library.getObject(this.entries, ANNOTS_KEY.getName());
        if (annots != null && annots instanceof Vector) {
            Vector v = (Vector)annots;
            this.annotations = new ArrayList(v.size() + 1);
            Annotation a = null;
            for (int i = 0; i < v.size(); ++i) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Page Annotation initialization thread interrupted");
                }
                Object annotObj = v.elementAt(i);
                Reference ref = null;
                if (annotObj instanceof Reference) {
                    ref = (Reference)v.elementAt(i);
                    annotObj = this.library.getObject(ref);
                }
                if (annotObj instanceof Annotation) {
                    a = (Annotation)annotObj;
                } else if (annotObj instanceof Hashtable) {
                    a = Annotation.buildAnnotation(this.library, (Hashtable)annotObj);
                }
                if (ref != null) {
                    a.setPObjectReference(ref);
                }
                this.annotations.add(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        try {
            if (this.isInited) {
                return;
            }
            boolean lowMemory = MemoryManager.getInstance().isLowMemory();
            if (lowMemory && logger.isLoggable(Level.FINER)) {
                logger.finer("Low memory conditions encountered, clearing page cache");
            }
            this.initPageResources();
            this.initPageAnnotations();
            this.initPageContents();
            if (this.contents != null) {
                Vector<InputStream> inputStreamsVec = new Vector<InputStream>(this.contents.size());
                for (Stream stream : this.contents) {
                    InputStream input = stream.getInputStreamForDecodedStreamBytes();
                    inputStreamsVec.add(input);
                }
                SequenceInputStream sis = new SequenceInputStream(inputStreamsVec.iterator());
                try {
                    ContentParser cp = new ContentParser(this.library, this.resources);
                    this.shapes = cp.parse(sis);
                }
                catch (Exception e) {
                    this.shapes = new Shapes();
                    logger.log(Level.FINE, "Error initializing Page.", e);
                }
                finally {
                    try {
                        sis.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.FINE, "Error closing page stream.", e);
                    }
                }
            } else {
                this.shapes = new Shapes();
            }
            this.isInited = true;
        }
        catch (InterruptedException e) {
            this.isInited = false;
            logger.log(Level.SEVERE, "Page initializing thread interrupted.", e);
        }
    }

    public Thumbnail getThumbnail() {
        Object thumb = this.library.getObject(this.entries, "Thumb");
        if (thumb != null && thumb instanceof Stream) {
            return new Thumbnail(this.library, this.entries);
        }
        return null;
    }

    public void paint(Graphics g, int renderHintType, int boundary, float userRotation, float userZoom) {
        this.paint(g, renderHintType, boundary, userRotation, userZoom, null);
    }

    public void paint(Graphics g, int renderHintType, int boundary, float userRotation, float userZoom, PageViewComponentImpl.PagePainter pagePainter) {
        this.paint(g, renderHintType, boundary, userRotation, userZoom, pagePainter, true, true);
    }

    public void paint(Graphics g, int renderHintType, int boundary, float userRotation, float userZoom, PageViewComponentImpl.PagePainter pagePainter, boolean paintAnnotations, boolean paintSearchHighlight) {
        PageText pageText;
        if (!this.isInited && pagePainter == null) {
            this.init();
        } else if (!this.isInited) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        GraphicsRenderingHints grh = GraphicsRenderingHints.getDefault();
        g2.setRenderingHints(grh.getRenderingHints(renderHintType));
        AffineTransform at = this.getPageTransform(boundary, userRotation, userZoom);
        g2.transform(at);
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        float x = 0.0f - pageBoundary.x;
        float y = 0.0f - (pageBoundary.y - pageBoundary.height);
        Color backgroundColor = grh.getPageBackgroundColor(renderHintType);
        if (backgroundColor != null) {
            g2.setColor(backgroundColor);
            g2.fillRect((int)(0.0f - x), (int)(0.0f - y), (int)pageBoundary.width, (int)pageBoundary.height);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(-x, -y, pageBoundary.width, pageBoundary.height);
        Shape oldClip = g2.getClip();
        if (oldClip == null) {
            g2.setClip(rect);
        } else {
            Area area = new Area(oldClip);
            area.intersect(new Area(rect));
            g2.setClip(area);
        }
        if (this.shapes != null) {
            AffineTransform pageTransform = g2.getTransform();
            Shape pageClip = g2.getClip();
            this.shapes.setPageParent(this);
            this.shapes.paint(g2, pagePainter);
            this.shapes.setPageParent(null);
            g2.setTransform(pageTransform);
            g2.setClip(pageClip);
        }
        if (this.annotations != null && paintAnnotations) {
            float totalRotation = this.getTotalRotation(userRotation);
            int num = this.annotations.size();
            for (int i = 0; i < num; ++i) {
                Annotation annot = this.annotations.get(i);
                annot.render(g2, renderHintType, totalRotation, userZoom, false);
            }
        }
        if (paintSearchHighlight && (pageText = this.getViewText()) != null) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
            for (LineText lineText : pageText.getPageLines()) {
                for (WordText wordText : lineText.getWords()) {
                    GeneralPath textPath;
                    if (wordText.isHighlighted()) {
                        textPath = new GeneralPath(wordText.getBounds());
                        g2.setColor(TextSelectionPageHandler.highlightColor);
                        g2.fill(textPath);
                        continue;
                    }
                    for (GlyphText glyph : wordText.getGlyphs()) {
                        if (!glyph.isHighlighted()) continue;
                        textPath = new GeneralPath(glyph.getBounds());
                        g2.setColor(TextSelectionPageHandler.highlightColor);
                        g2.fill(textPath);
                    }
                }
            }
        }
        this.notifyPaintPageListeners();
    }

    public AffineTransform getPageTransform(int boundary, float userRotation, float userZoom) {
        AffineTransform at = new AffineTransform();
        Rectangle2D.Double boundingBox = this.getBoundingBox(boundary, userRotation, userZoom);
        at.translate(0.0, boundingBox.getHeight());
        at.scale(1.0, -1.0);
        at.scale(userZoom, userZoom);
        float totalRotation = this.getTotalRotation(userRotation);
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        if (totalRotation != 0.0f) {
            double rad;
            if (totalRotation == 90.0f) {
                at.translate(pageBoundary.height, 0.0);
            } else if (totalRotation == 180.0f) {
                at.translate(pageBoundary.width, pageBoundary.height);
            } else if (totalRotation == 270.0f) {
                at.translate(0.0, pageBoundary.width);
            } else if (totalRotation > 0.0f && totalRotation < 90.0f) {
                double xShift = (double)pageBoundary.height * Math.cos(Math.toRadians(90.0f - totalRotation));
                at.translate(xShift, 0.0);
            } else if (totalRotation > 90.0f && totalRotation < 180.0f) {
                rad = Math.toRadians(180.0f - totalRotation);
                double cosRad = Math.cos(rad);
                double sinRad = Math.sin(rad);
                double xShift = (double)pageBoundary.height * sinRad + (double)pageBoundary.width * cosRad;
                double yShift = (double)pageBoundary.height * cosRad;
                at.translate(xShift, yShift);
            } else if (totalRotation > 180.0f && totalRotation < 270.0f) {
                rad = Math.toRadians(totalRotation - 180.0f);
                double cosRad = Math.cos(rad);
                double sinRad = Math.sin(rad);
                double xShift = (double)pageBoundary.width * cosRad;
                double yShift = (double)pageBoundary.width * sinRad + (double)pageBoundary.height * cosRad;
                at.translate(xShift, yShift);
            } else if (totalRotation > 270.0f && totalRotation < 360.0f) {
                double yShift = (double)pageBoundary.width * Math.cos(Math.toRadians(totalRotation - 270.0f));
                at.translate(0.0, yShift);
            }
        }
        at.rotate((double)totalRotation * Math.PI / 180.0);
        float x = 0.0f - pageBoundary.x;
        float y = 0.0f - (pageBoundary.y - pageBoundary.height);
        at.translate(x, y);
        return at;
    }

    public Shape getPageShape(int boundary, float userRotation, float userZoom) {
        AffineTransform at = this.getPageTransform(boundary, userRotation, userZoom);
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        float x = 0.0f - pageBoundary.x;
        float y = 0.0f - (pageBoundary.y - pageBoundary.height);
        Rectangle2D.Double rect = new Rectangle2D.Double(-x, -y, pageBoundary.width, pageBoundary.height);
        GeneralPath path = new GeneralPath(rect);
        return path.createTransformedShape(at);
    }

    public Annotation createAnnotation(Rectangle rect, AnnotationState annotationState) {
        Annotation newAnnotation = AnnotationFactory.buildAnnotation(this.library, 1, rect, annotationState);
        return this.addAnnotation(newAnnotation);
    }

    public Annotation addAnnotation(Annotation newAnnotation) {
        if (!this.isInited) {
            try {
                this.initPageAnnotations();
            }
            catch (InterruptedException e) {
                logger.warning("Annotation Initialization interupted");
            }
        }
        StateManager stateManager = this.library.getStateManager();
        Object annots = this.library.getObject(this.entries, ANNOTS_KEY.getName());
        boolean isAnnotAReference = this.library.isReference(this.entries, ANNOTS_KEY.getName());
        if (!isAnnotAReference && annots != null) {
            if (annots instanceof Vector) {
                Vector v = (Vector)annots;
                v.add(newAnnotation.getPObjectReference());
                stateManager.addChange(new PObject(this, this.getPObjectReference()));
            }
        } else if (isAnnotAReference && annots != null) {
            if (annots instanceof Vector) {
                Vector v = (Vector)annots;
                v.add(newAnnotation.getPObjectReference());
                stateManager.addChange(new PObject(annots, this.library.getObjectReference(this.entries, ANNOTS_KEY.getName())));
            }
        } else {
            Vector<Reference> annotsVector = new Vector<Reference>(4);
            annotsVector.add(newAnnotation.getPObjectReference());
            PObject annotsPObject = new PObject(annotsVector, stateManager.getNewReferencNumber());
            this.entries.put(ANNOTS_KEY, annotsPObject.getReference());
            this.library.addObject(annotsVector, annotsPObject.getReference());
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
            stateManager.addChange(annotsPObject);
            this.annotations = new ArrayList();
        }
        newAnnotation.getEntries().put(Annotation.PARENT_PAGE_KEY, this.getPObjectReference());
        this.annotations.add(newAnnotation);
        this.library.addObject(newAnnotation, newAnnotation.getPObjectReference());
        stateManager.addChange(new PObject(newAnnotation, newAnnotation.getPObjectReference()));
        return newAnnotation;
    }

    public void deleteAnnotation(Annotation annot) {
        if (!this.isInited) {
            try {
                this.initPageAnnotations();
            }
            catch (InterruptedException e) {
                logger.warning("Annotation Initialization interupted");
            }
        }
        StateManager stateManager = this.library.getStateManager();
        Object annots = this.getObject(ANNOTS_KEY);
        boolean isAnnotAReference = this.library.isReference(this.entries, ANNOTS_KEY.getName());
        annot.setDeleted(true);
        if (!annot.isNew() && !isAnnotAReference) {
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
        } else if (!annot.isNew() && isAnnotAReference) {
            stateManager.addChange(new PObject(annots, this.library.getObjectReference(this.entries, ANNOTS_KEY.getName())));
        }
        if (annots instanceof Vector) {
            Vector v = (Vector)annots;
            v.remove(annot.getPObjectReference());
        }
        if (this.annotations != null) {
            this.annotations.remove(annot);
        }
    }

    public boolean updateAnnotation(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        if (!this.isInited) {
            try {
                this.initPageAnnotations();
            }
            catch (InterruptedException e) {
                logger.warning("Annotation Initialization interupted");
            }
        }
        StateManager stateManager = this.library.getStateManager();
        Vector annots = (Vector)this.library.getObject(this.entries, ANNOTS_KEY.getName());
        boolean found = false;
        for (Reference ref : annots) {
            if (!ref.equals(annotation.getPObjectReference())) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        if (stateManager.contains(annotation.getPObjectReference())) {
            stateManager.addChange(new PObject(annotation, annotation.getPObjectReference()));
            return true;
        }
        annotation.getEntries().put(Annotation.PARENT_PAGE_KEY, this.getPObjectReference());
        this.annotations.add(annotation);
        this.library.addObject(annotation, annotation.getPObjectReference());
        stateManager.addChange(new PObject(annotation, annotation.getPObjectReference()));
        return true;
    }

    protected Reference getParentReference() {
        return (Reference)this.entries.get("Parent");
    }

    public PageTree getParent() {
        return (PageTree)this.library.getObject(this.entries, "Parent");
    }

    public PDimension getSize(float userRotation) {
        return this.getSize(2, userRotation, 1.0f);
    }

    public PDimension getSize(float userRotation, float userZoom) {
        return this.getSize(2, userRotation, userZoom);
    }

    public PDimension getSize(int boundary, float userRotation, float userZoom) {
        float totalRotation = this.getTotalRotation(userRotation);
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        float width = pageBoundary.width * userZoom;
        float height = pageBoundary.height * userZoom;
        if (totalRotation != 0.0f && totalRotation != 180.0f) {
            if (totalRotation == 90.0f || totalRotation == 270.0f) {
                float temp = width;
                width = height;
                height = temp;
            } else {
                AffineTransform at = new AffineTransform();
                double radians = Math.toRadians(totalRotation);
                at.rotate(radians);
                Rectangle2D.Double boundingBox = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                Point2D.Double src = new Point2D.Double();
                Point2D.Double dst = new Point2D.Double();
                src.setLocation(0.0, height);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(width, height);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(0.0, 0.0);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(width, 0.0);
                at.transform(src, dst);
                boundingBox.add(dst);
                width = (float)boundingBox.getWidth();
                height = (float)boundingBox.getHeight();
            }
        }
        return new PDimension(width, height);
    }

    public Rectangle2D.Double getBoundingBox(float userRotation) {
        return this.getBoundingBox(2, userRotation, 1.0f);
    }

    public Rectangle2D.Double getBoundingBox(float userRotation, float userZoom) {
        return this.getBoundingBox(2, userRotation, userZoom);
    }

    public Rectangle2D.Double getBoundingBox(int boundary, float userRotation, float userZoom) {
        float totalRotation = this.getTotalRotation(userRotation);
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        float width = pageBoundary.width * userZoom;
        float height = pageBoundary.height * userZoom;
        AffineTransform at = new AffineTransform();
        double radians = Math.toRadians(totalRotation);
        at.rotate(radians);
        Rectangle2D.Double boundingBox = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        Point2D.Double src = new Point2D.Double();
        Point2D.Double dst = new Point2D.Double();
        src.setLocation(0.0, height);
        at.transform(src, dst);
        boundingBox.add(dst);
        src.setLocation(width, height);
        at.transform(src, dst);
        boundingBox.add(dst);
        src.setLocation(0.0, 0.0);
        at.transform(src, dst);
        boundingBox.add(dst);
        src.setLocation(width, 0.0);
        at.transform(src, dst);
        boundingBox.add(dst);
        return boundingBox;
    }

    public PRectangle getPageBoundary(int specifiedBox) {
        PRectangle userSpecifiedBox = null;
        if (specifiedBox == 1) {
            userSpecifiedBox = (PRectangle)this.getMediaBox();
        } else if (specifiedBox == 2) {
            userSpecifiedBox = (PRectangle)this.getCropBox();
        } else if (specifiedBox == 3) {
            if (this.bleedBox != null) {
                userSpecifiedBox = (PRectangle)this.getBleedBox();
            }
        } else if (specifiedBox == 4) {
            if (this.trimBox != null) {
                userSpecifiedBox = (PRectangle)this.getTrimBox();
            }
        } else if (specifiedBox == 5) {
            if (this.artBox != null) {
                userSpecifiedBox = (PRectangle)this.getArtBox();
            }
        } else {
            userSpecifiedBox = (PRectangle)this.getBleedBox();
        }
        if (userSpecifiedBox == null) {
            userSpecifiedBox = (PRectangle)this.getCropBox();
        }
        return userSpecifiedBox;
    }

    @Override
    public String toString() {
        return "PAGE= " + this.entries.toString();
    }

    public float getTotalRotation(float userRotation) {
        float totalRotation = this.getPageRotation() + userRotation;
        if ((totalRotation %= 360.0f) < 0.0f) {
            totalRotation += 360.0f;
        }
        if (totalRotation >= -0.001f && totalRotation <= 0.001f) {
            return 0.0f;
        }
        if (totalRotation >= 89.99f && totalRotation <= 90.001f) {
            return 90.0f;
        }
        if (totalRotation >= 179.99f && totalRotation <= 180.001f) {
            return 180.0f;
        }
        if (totalRotation >= 269.99f && totalRotation <= 270.001f) {
            return 270.0f;
        }
        return totalRotation;
    }

    private float getPageRotation() {
        Object tmpRotation = this.library.getObject(this.entries, "Rotate");
        if (tmpRotation != null) {
            this.pageRotation = ((Number)tmpRotation).floatValue();
        } else {
            for (PageTree pageTree = this.getParent(); pageTree != null; pageTree = pageTree.getParent()) {
                if (!pageTree.isRotationFactor) continue;
                this.pageRotation = pageTree.rotationFactor;
                break;
            }
        }
        this.pageRotation = 360.0f - this.pageRotation;
        this.pageRotation %= 360.0f;
        return this.pageRotation;
    }

    public ArrayList<Annotation> getAnnotations() {
        if (!this.isInited) {
            this.init();
        }
        return this.annotations;
    }

    public String[] getDecodedContentSteam() {
        try {
            this.initPageContents();
            if (this.contents == null) {
                return null;
            }
            String[] decodedContentStream = new String[this.contents.size()];
            int i = 0;
            for (Stream stream : this.contents) {
                String content;
                InputStream input = stream.getInputStreamForDecodedStreamBytes();
                if (input instanceof SeekableInput) {
                    content = Utils.getContentFromSeekableInput((SeekableInput)((Object)input), false);
                } else {
                    InputStream[] inArray = new InputStream[]{input};
                    content = Utils.getContentAndReplaceInputStream(inArray, false);
                }
                decodedContentStream[i] = content;
                input.close();
                ++i;
            }
            return decodedContentStream;
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Error initializing page Contents.", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error closing content stream");
        }
        return null;
    }

    public Rectangle2D.Float getMediaBox() {
        Vector boxDimensions = (Vector)this.library.getObject(this.entries, "MediaBox");
        if (boxDimensions != null) {
            this.mediaBox = new PRectangle(boxDimensions);
        }
        if (this.mediaBox == null) {
            for (PageTree pageTree = this.getParent(); pageTree != null && this.mediaBox == null; pageTree = pageTree.getParent()) {
                this.mediaBox = pageTree.getMediaBox();
            }
        }
        return this.mediaBox;
    }

    public Rectangle2D.Float getCropBox() {
        Vector boxDimensions = (Vector)this.library.getObject(this.entries, "CropBox");
        if (boxDimensions != null) {
            this.cropBox = new PRectangle(boxDimensions);
        }
        if (this.cropBox == null) {
            for (PageTree pageTree = this.getParent(); pageTree != null && this.cropBox == null && pageTree.getCropBox() != null; pageTree = pageTree.getParent()) {
                this.cropBox = pageTree.getCropBox();
            }
        }
        PRectangle mediaBox = (PRectangle)this.getMediaBox();
        if (this.cropBox == null && mediaBox != null) {
            this.cropBox = (PRectangle)mediaBox.clone();
        } else if (mediaBox != null) {
            this.cropBox = mediaBox.createCartesianIntersection(this.cropBox);
        }
        return this.cropBox;
    }

    public Rectangle2D.Float getArtBox() {
        Vector boxDimensions = (Vector)this.library.getObject(this.entries, "ArtBox");
        if (boxDimensions != null) {
            this.artBox = new PRectangle(boxDimensions);
        }
        if (this.artBox == null) {
            this.artBox = (PRectangle)this.getCropBox();
        }
        return this.artBox;
    }

    public Rectangle2D.Float getBleedBox() {
        Vector boxDimensions = (Vector)this.library.getObject(this.entries, "BleedBox");
        if (boxDimensions != null) {
            this.bleedBox = new PRectangle(boxDimensions);
        }
        if (this.bleedBox == null) {
            this.bleedBox = (PRectangle)this.getCropBox();
        }
        return this.bleedBox;
    }

    public Rectangle2D.Float getTrimBox() {
        Vector boxDimensions = (Vector)this.library.getObject(this.entries, "TrimBox");
        if (boxDimensions != null) {
            this.trimBox = new PRectangle(boxDimensions);
        }
        if (this.trimBox == null) {
            this.trimBox = (PRectangle)this.getCropBox();
        }
        return this.trimBox;
    }

    public synchronized PageText getViewText() {
        if (!this.isInited) {
            this.init();
        }
        return this.shapes.getPageText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PageText getText() {
        Shapes textBlockShapes;
        block18: {
            if (this.isInited && this.shapes != null && this.shapes.getPageText() != null) {
                return this.shapes.getPageText();
            }
            textBlockShapes = null;
            try {
                if (this.contents == null) {
                    this.initPageContents();
                }
                if (this.resources == null) {
                    this.initPageResources();
                }
                if (this.contents == null) break block18;
                Vector<InputStream> inputStreamsVec = new Vector<InputStream>(this.contents.size());
                int max = this.contents.size();
                for (int st = 0; st < max; ++st) {
                    Stream stream = this.contents.elementAt(st);
                    InputStream input = stream.getInputStreamForDecodedStreamBytes();
                    inputStreamsVec.add(input);
                }
                SequenceInputStream sis = new SequenceInputStream(inputStreamsVec.iterator());
                try {
                    ContentParser cp = new ContentParser(this.library, this.resources);
                    textBlockShapes = cp.parseTextBlocks(sis);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Error getting page text.", e);
                }
                finally {
                    try {
                        sis.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.FINE, "Error closing page stream.", e);
                    }
                }
            }
            catch (InterruptedException e) {
                this.isInited = false;
                logger.log(Level.SEVERE, "Page text extraction thread interrupted.", e);
            }
        }
        if (textBlockShapes != null && textBlockShapes.getPageText() != null) {
            return textBlockShapes.getPageText();
        }
        return null;
    }

    public synchronized Vector getImages() {
        if (!this.isInited) {
            this.init();
        }
        return this.shapes.getImages();
    }

    public Resources getResources() {
        return this.resources;
    }

    @Override
    public void reduceMemory() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaintPageListener(PaintPageListener listener) {
        Vector<PaintPageListener> vector = this.paintPageListeners;
        synchronized (vector) {
            if (!this.paintPageListeners.contains(listener)) {
                this.paintPageListeners.addElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaintPageListener(PaintPageListener listener) {
        Vector<PaintPageListener> vector = this.paintPageListeners;
        synchronized (vector) {
            if (this.paintPageListeners.contains(listener)) {
                this.paintPageListeners.removeElement(listener);
            }
        }
    }

    public void notifyPaintPageListeners() {
        PaintPageEvent evt = new PaintPageEvent(this);
        for (int i = this.paintPageListeners.size() - 1; i >= 0; --i) {
            PaintPageListener client = this.paintPageListeners.elementAt(i);
            client.paintPage(evt);
        }
    }
}

