/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.views.swing;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationState;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.views.AnnotationComponent;
import org.icepdf.core.views.DocumentViewController;
import org.icepdf.core.views.DocumentViewModel;
import org.icepdf.core.views.PageViewComponent;
import org.icepdf.core.views.swing.AbstractPageViewComponent;
import org.icepdf.core.views.swing.ResizableBorder;

public class AnnotationComponentImpl
extends JComponent
implements FocusListener,
MouseInputListener,
AnnotationComponent {
    private static final Logger logger;
    private static boolean isInteractiveAnnotationsEnabled;
    private static Color annotationHighlightColor;
    private static float annotationHighlightAlpha;
    public static final int resizeBoxSize = 4;
    private static ResizableBorder resizableBorder;
    private AbstractPageViewComponent pageViewComponent;
    private DocumentViewController documentViewController;
    private DocumentViewModel documentViewModel;
    private float currentZoom;
    private float currentRotation;
    protected Annotation annotation;
    private boolean isMousePressed;
    private boolean resized;
    private boolean wasResized;
    private boolean isEditable;
    private boolean isRollover;
    private boolean isLinkAnnot;
    private boolean isBorderStyle;
    private boolean isSelected;
    private int cursor;
    private Point startPos;
    private AnnotationState previousAnnotationState;

    public AnnotationComponentImpl(Annotation annotation, DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        this.pageViewComponent = pageViewComponent;
        this.documentViewModel = documentViewModel;
        this.documentViewController = documentViewController;
        this.annotation = annotation;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(resizableBorder);
        Page currentPage = pageViewComponent.getPageLock(this);
        AffineTransform at = currentPage.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
        pageViewComponent.releasePageLock(currentPage, this);
        Rectangle location = at.createTransformedShape(annotation.getUserSpaceRectangle()).getBounds();
        this.setBounds(location);
        this.currentRotation = documentViewModel.getViewRotation();
        this.currentZoom = documentViewModel.getViewZoom();
        this.isLinkAnnot = annotation instanceof LinkAnnotation;
        this.isBorderStyle = annotation.isBorder();
    }

    public Document getDocument() {
        return this.documentViewModel.getDocument();
    }

    public int getPageIndex() {
        return this.pageViewComponent.getPageIndex();
    }

    public PageViewComponent getParentPageView() {
        return this.pageViewComponent;
    }

    public AbstractPageViewComponent getPageViewComponent() {
        return this.pageViewComponent;
    }

    public void removeMouseListeners() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    private void resize() {
        if (this.getParent() != null) {
            ((JComponent)this.getParent()).revalidate();
        }
        this.resized = true;
    }

    public void refreshDirtyBounds() {
        Page currentPage = this.pageViewComponent.getPageLock(this);
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        this.pageViewComponent.releasePageLock(currentPage, this);
        this.setBounds(this.commonBoundsNormalization(new GeneralPath(this.annotation.getUserSpaceRectangle()), at));
    }

    public void refreshAnnotationRect() {
        Page currentPage = this.pageViewComponent.getPageLock(this);
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        this.pageViewComponent.releasePageLock(currentPage, this);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
        Rectangle2D.Float rect = this.annotation.getUserSpaceRectangle();
        Rectangle bounds = this.getBounds();
        ((Rectangle2D)rect).setRect(this.commonBoundsNormalization(new GeneralPath(bounds), at));
    }

    private Rectangle commonBoundsNormalization(GeneralPath shapePath, AffineTransform at) {
        shapePath.transform(at);
        Rectangle2D pageSpaceBound = shapePath.getBounds2D();
        return new Rectangle((int)Math.round(pageSpaceBound.getX()), (int)Math.round(pageSpaceBound.getY()), (int)Math.round(pageSpaceBound.getWidth()), (int)Math.round(pageSpaceBound.getHeight()));
    }

    public void validate() {
        if (this.currentZoom != this.documentViewModel.getViewZoom() || this.currentRotation != this.documentViewModel.getViewRotation()) {
            this.refreshDirtyBounds();
            this.currentRotation = this.documentViewModel.getViewRotation();
            this.currentZoom = this.documentViewModel.getViewZoom();
        }
        if (this.resized) {
            this.refreshAnnotationRect();
            if (this.getParent() != null) {
                ((JComponent)this.getParent()).revalidate();
                this.getParent().repaint();
            }
            this.resized = false;
            this.wasResized = true;
        }
    }

    public void paintComponent(Graphics g) {
        Page currentPage = this.pageViewComponent.getPageLock(this);
        if (currentPage != null && currentPage.isInitiated() && (this.currentZoom != this.documentViewModel.getViewZoom() || this.currentRotation != this.documentViewModel.getViewRotation())) {
            this.validate();
        }
        this.pageViewComponent.releasePageLock(currentPage, this);
        boolean bl = this.isEditable = (this.documentViewModel.getViewToolMode() == 5 || this.documentViewModel.getViewToolMode() == 6) && !this.annotation.getFlagReadOnly() && !this.annotation.getFlagLocked() && !this.annotation.getFlagInvisible() && !this.annotation.getFlagHidden();
        if (this.isMousePressed && this.documentViewModel.getViewToolMode() != 5 && this.documentViewModel.getViewToolMode() != 6) {
            Graphics2D gg2 = (Graphics2D)g;
            if (this.annotation instanceof LinkAnnotation) {
                LinkAnnotation linkAnnotation = (LinkAnnotation)this.annotation;
                String highlightMode = linkAnnotation.getHighlightMode();
                Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                if ("I".equals(highlightMode)) {
                    gg2.setColor(annotationHighlightColor);
                    gg2.setComposite(AlphaComposite.getInstance(3, annotationHighlightAlpha));
                    gg2.fillRect((int)((RectangularShape)rect).getX(), (int)((RectangularShape)rect).getY(), (int)((RectangularShape)rect).getWidth(), (int)((RectangularShape)rect).getHeight());
                } else if ("O".equals(highlightMode)) {
                    gg2.setColor(annotationHighlightColor);
                    gg2.setComposite(AlphaComposite.getInstance(3, annotationHighlightAlpha));
                    gg2.drawRect((int)((RectangularShape)rect).getX(), (int)((RectangularShape)rect).getY(), (int)((RectangularShape)rect).getWidth(), (int)((RectangularShape)rect).getHeight());
                } else if ("P".equals(highlightMode)) {
                    gg2.setColor(annotationHighlightColor);
                    gg2.setComposite(AlphaComposite.getInstance(3, annotationHighlightAlpha));
                    gg2.drawRect((int)((RectangularShape)rect).getX(), (int)((RectangularShape)rect).getY(), (int)((RectangularShape)rect).getWidth(), (int)((RectangularShape)rect).getHeight());
                }
            }
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public void mouseMoved(MouseEvent me) {
        int toolMode = this.documentViewModel.getViewToolMode();
        if (toolMode == 5 && !this.annotation.getFlagLocked() && !this.annotation.getFlagReadOnly()) {
            ResizableBorder border = (ResizableBorder)this.getBorder();
            this.setCursor(Cursor.getPredefinedCursor(border.getCursor(me)));
        } else if (toolMode != 6) {
            this.setCursor(this.documentViewController.getViewCursor(9));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
        this.isRollover = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (this.documentViewModel.getViewToolMode() != 5 && this.documentViewModel.getViewToolMode() != 6 && isInteractiveAnnotationsEnabled && this.documentViewController.getAnnotationCallback() != null) {
            this.documentViewController.getAnnotationCallback().proccessAnnotationAction(this.annotation);
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.isRollover = this.documentViewModel.getViewToolMode() == 5;
        this.repaint();
    }

    public void mousePressed(MouseEvent me) {
        this.isMousePressed = true;
        if (this.documentViewModel.getViewToolMode() == 5 && isInteractiveAnnotationsEnabled && !this.annotation.getFlagReadOnly()) {
            ResizableBorder border = (ResizableBorder)this.getBorder();
            this.cursor = border.getCursor(me);
            this.startPos = me.getPoint();
            this.previousAnnotationState = new AnnotationState(this);
            this.documentViewController.assignSelectedAnnotation(this);
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent me) {
        if (this.startPos != null && !this.annotation.getFlagLocked() && !this.annotation.getFlagReadOnly()) {
            int x = this.getX();
            int y = this.getY();
            int w = this.getWidth();
            int h = this.getHeight();
            int dx = me.getX() - this.startPos.x;
            int dy = me.getY() - this.startPos.y;
            switch (this.cursor) {
                case 8: {
                    if (h - dy < 12) break;
                    this.setBounds(x, y + dy, w, h - dy);
                    this.resize();
                    break;
                }
                case 9: {
                    if (h + dy < 12) break;
                    this.setBounds(x, y, w, h + dy);
                    this.startPos = me.getPoint();
                    this.resize();
                    break;
                }
                case 10: {
                    if (w - dx < 18) break;
                    this.setBounds(x + dx, y, w - dx, h);
                    this.resize();
                    break;
                }
                case 11: {
                    if (w + dx < 18) break;
                    this.setBounds(x, y, w + dx, h);
                    this.startPos = me.getPoint();
                    this.resize();
                    break;
                }
                case 6: {
                    if (w - dx < 18 || h - dy < 18) break;
                    this.setBounds(x + dx, y + dy, w - dx, h - dy);
                    this.resize();
                    break;
                }
                case 7: {
                    if (w + dx < 18 || h - dy < 18) break;
                    this.setBounds(x, y + dy, w + dx, h - dy);
                    this.startPos = new Point(me.getX(), this.startPos.y);
                    this.resize();
                    break;
                }
                case 4: {
                    if (w - dx < 18 || h + dy < 18) break;
                    this.setBounds(x + dx, y, w - dx, h + dy);
                    this.startPos = new Point(this.startPos.x, me.getY());
                    this.resize();
                    break;
                }
                case 5: {
                    if (w + dx < 18 || h + dy < 18) break;
                    this.setBounds(x, y, w + dx, h + dy);
                    this.startPos = me.getPoint();
                    this.resize();
                    break;
                }
                case 13: {
                    Rectangle bounds = this.getBounds();
                    bounds.translate(dx, dy);
                    this.setBounds(bounds);
                    this.resize();
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(this.cursor));
            this.validate();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.startPos = null;
        this.isMousePressed = false;
        if (this.wasResized) {
            this.wasResized = false;
            this.documentViewController.firePropertyChange("annotationBounds", this.previousAnnotationState, new AnnotationState(this));
        }
        this.repaint();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isRollover() {
        return this.isRollover;
    }

    public boolean isLinkAnnot() {
        return this.isLinkAnnot;
    }

    public boolean isBorderStyle() {
        return this.isBorderStyle;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    static {
        block5: {
            logger = Logger.getLogger(AnnotationComponentImpl.class.toString());
            isInteractiveAnnotationsEnabled = Defs.sysPropertyBoolean("org.icepdf.core.annotations.interactive.enabled", true);
            try {
                String color = Defs.sysProperty("org.icepdf.core.views.page.annotation.highlight.color", "#000000");
                int colorValue = ColorUtil.convertColor(color);
                annotationHighlightColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("000000", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading page annotation highlight colour");
            }
        }
        try {
            String alpha = Defs.sysProperty("org.icepdf.core.views.page.annotation.highlight.alpha", "0.4");
            annotationHighlightAlpha = Float.parseFloat(alpha);
        }
        catch (NumberFormatException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Error reading page annotation highlight alpha");
            }
            annotationHighlightAlpha = 0.4f;
        }
        resizableBorder = new ResizableBorder(4);
    }
}

