/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.views.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.icepdf.core.events.PaintPageEvent;
import org.icepdf.core.events.PaintPageListener;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.views.AnnotationComponent;
import org.icepdf.core.views.DocumentView;
import org.icepdf.core.views.DocumentViewController;
import org.icepdf.core.views.DocumentViewModel;
import org.icepdf.core.views.common.AnnotationHandler;
import org.icepdf.core.views.common.TextSelectionPageHandler;
import org.icepdf.core.views.swing.AbstractPageViewComponent;

public class PageViewComponentImpl
extends AbstractPageViewComponent
implements PaintPageListener,
FocusListener,
ComponentListener {
    private static final Logger logger = Logger.getLogger(PageViewComponentImpl.class.toString());
    private static Color pageColor;
    private static boolean enablePageLoadingProxy;
    private PageTree pageTree;
    private JScrollPane parentScrollPane;
    private int pageIndex;
    private Rectangle pageSize = new Rectangle();
    private Rectangle defaultPageSize = new Rectangle();
    private boolean isPageSizeCalculated = false;
    private float currentZoom;
    private float currentRotation;
    protected DocumentView parentDocumentView;
    protected DocumentViewModel documentViewModel;
    protected DocumentViewController documentViewController;
    protected AnnotationHandler annotationHandler;
    protected TextSelectionPageHandler textSelectionHandler;
    private SoftReference<Image> bufferedPageImageReference;
    private Rectangle bufferedPageImageBounds = new Rectangle();
    private Timer isDirtyTimer;
    private PageInitilizer pageInitilizer;
    private PagePainter pagePainter;
    private final Object paintCopyAreaLock = new Object();
    private boolean disposing = false;
    private Rectangle clipBounds;
    private Rectangle oldClipBounds;
    private boolean inited;
    private static double verticalScaleFactor;
    private static double horizontalScaleFactor;
    private static int dirtyTimerInterval;
    private GraphicsConfiguration gc;

    public PageViewComponentImpl(DocumentViewModel documentViewModel, PageTree pageTree, int pageNumber, JScrollPane parentScrollPane) {
        this(documentViewModel, pageTree, pageNumber, parentScrollPane, 0, 0);
    }

    public PageViewComponentImpl(DocumentViewModel documentViewModel, PageTree pageTree, int pageNumber, JScrollPane parentScrollPane, int width, int height) {
        this.documentViewModel = documentViewModel;
        this.parentScrollPane = parentScrollPane;
        this.annotationHandler = new AnnotationHandler(this, documentViewModel);
        this.textSelectionHandler = new TextSelectionPageHandler(this, documentViewModel);
        this.currentRotation = documentViewModel.getViewRotation();
        this.currentZoom = documentViewModel.getViewRotation();
        this.pageTree = pageTree;
        this.pageIndex = pageNumber;
        this.clipBounds = new Rectangle();
        this.oldClipBounds = new Rectangle();
        this.bufferedPageImageReference = new SoftReference<Object>(null);
        if (width == 0 && height == 0) {
            this.calculatePageSize(this.pageSize);
            this.isPageSizeCalculated = true;
        } else {
            this.pageSize.setSize(width, height);
            this.defaultPageSize.setSize(width, height);
        }
    }

    public void addPageViewComponentListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.addMouseListener(this.annotationHandler);
        this.addMouseMotionListener(this.annotationHandler);
        this.addMouseMotionListener(this.textSelectionHandler);
        this.addMouseListener(this.textSelectionHandler);
    }

    public AnnotationComponent addAnnotation(Annotation annotation) {
        return this.annotationHandler.addAnnotationComponent(annotation);
    }

    public void removeAnnotation(AnnotationComponent annotationComp) {
        this.annotationHandler.removeAnnotationComponent(annotationComp);
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.addPageRepaintListener();
        DirtyTimerAction dirtyTimerAction = new DirtyTimerAction();
        this.isDirtyTimer = new Timer(dirtyTimerInterval, dirtyTimerAction);
        this.isDirtyTimer.setInitialDelay(0);
        this.pageInitilizer = new PageInitilizer();
        this.pagePainter = new PagePainter();
    }

    public void invalidatePage() {
        if (this.inited) {
            Page page = this.pageTree.getPage(this.pageIndex, this);
            page.getLibrary().disposeFontResources();
            page.reduceMemory();
            this.pageTree.releasePage(page, (Object)this);
            this.currentZoom = -1.0f;
        }
    }

    public void dispose() {
        Image pageBufferImage;
        this.disposing = true;
        if (this.isDirtyTimer != null) {
            this.isDirtyTimer.stop();
        }
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeComponentListener(this);
        this.removeMouseMotionListener(this.annotationHandler);
        this.removeMouseListener(this.annotationHandler);
        this.removeMouseMotionListener(this.textSelectionHandler);
        this.removeMouseListener(this.textSelectionHandler);
        this.removeFocusListener(this);
        this.removePageRepaintListener();
        if (this.bufferedPageImageReference != null && (pageBufferImage = this.bufferedPageImageReference.get()) != null) {
            pageBufferImage.flush();
        }
        this.inited = false;
    }

    public Page getPageLock(Object lock) {
        return this.pageTree.getPage(this.pageIndex, lock);
    }

    public void releasePageLock(Page currentPage, Object lock) {
        this.pageTree.releasePage(currentPage, lock);
    }

    public void setDocumentViewCallback(DocumentView parentDocumentView) {
        this.parentDocumentView = parentDocumentView;
        this.documentViewController = this.parentDocumentView.getParentViewController();
        this.annotationHandler.setDocumentViewController(this.documentViewController);
        this.textSelectionHandler.setDocumentViewController(this.documentViewController);
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public Dimension getPreferredSize() {
        return this.pageSize.getSize();
    }

    public void invalidate() {
        this.calculateRoughPageSize(this.pageSize);
        if (this.pagePainter != null) {
            this.pagePainter.setIsBufferDirty(true);
        }
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics gg) {
        if (!this.inited) {
            this.init();
        }
        if (!this.isPageSizeCalculated) {
            this.calculatePageSize(this.pageSize);
            this.invalidate();
        } else if (this.isPageStateDirty()) {
            this.calculatePageSize(this.pageSize);
        }
        Graphics2D g = (Graphics2D)gg.create(0, 0, this.pageSize.width, this.pageSize.height);
        g.setColor(pageColor);
        g.fillRect(0, 0, this.pageSize.width, this.pageSize.height);
        if (enablePageLoadingProxy && this.isPageIntersectViewport() && !this.isDirtyTimer.isRunning()) {
            this.isDirtyTimer.start();
        } else if (!enablePageLoadingProxy && this.isPageIntersectViewport() && (this.isPageStateDirty() || this.isBufferDirty())) {
            this.pageInitilizer.run();
            this.pagePainter.run();
        }
        if (this.parentScrollPane == null) {
            this.oldClipBounds.setBounds(this.clipBounds);
            this.clipBounds.setBounds(g.getClipBounds());
            if (this.oldClipBounds.width == 0 && this.oldClipBounds.height == 0) {
                this.oldClipBounds.setBounds(this.clipBounds);
            }
        }
        if (this.bufferedPageImageReference != null) {
            Image pageBufferImage = this.bufferedPageImageReference.get();
            if (pageBufferImage != null && !this.isPageStateDirty()) {
                Object object = this.paintCopyAreaLock;
                synchronized (object) {
                    g.drawImage(pageBufferImage, this.bufferedPageImageBounds.x, this.bufferedPageImageBounds.y, this);
                }
            } else {
                this.currentZoom = -1.0f;
            }
            this.annotationHandler.paintAnnotations(g);
            Page currentPage = this.getPageLock(this);
            if (currentPage != null && currentPage.isInitiated()) {
                PageText pageText = currentPage.getViewText();
                DocumentSearchController searchController = this.documentViewController.getParentController().getDocumentSearchController();
                if (searchController.isSearchHighlightRefreshNeeded(this.pageIndex, pageText)) {
                    searchController.searchHighlightPage(this.pageIndex);
                }
                if (this.documentViewModel.isSelectAll()) {
                    this.documentViewModel.addSelectedPageText(this);
                    pageText.selectAll();
                }
                this.textSelectionHandler.paintSelectedText(g);
            }
            this.releasePageLock(currentPage, this);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.documentViewModel.getViewToolMode() == 4) {
            this.textSelectionHandler.mouseClicked(e);
        } else if (this.documentViewModel.getViewToolMode() == 2) {
            Point p = e.getPoint();
            Point offset = this.documentViewModel.getPageBounds(this.pageIndex).getLocation();
            p.setLocation(p.x + offset.x, p.y + offset.y);
            this.documentViewController.setZoomIn(p);
        } else if (this.documentViewModel.getViewToolMode() == 3) {
            Point p = e.getPoint();
            this.documentViewController.setZoomOut(p);
        } else if (this.documentViewModel.getViewToolMode() == 5) {
            this.annotationHandler.mouseClicked(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.documentViewModel.getViewToolMode() == 4) {
            this.textSelectionHandler.mousePressed(e);
        } else if (this.documentViewModel.getViewToolMode() == 5 || this.documentViewModel.getViewToolMode() == 6) {
            this.annotationHandler.mousePressed(e);
        }
    }

    public void clearSelectedText() {
        if (this.textSelectionHandler != null) {
            this.textSelectionHandler.clearSelection();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.documentViewModel.getViewToolMode() == 4) {
            this.textSelectionHandler.mouseReleased(e);
        } else if (this.documentViewModel.getViewToolMode() == 5 || this.documentViewModel.getViewToolMode() == 6) {
            this.annotationHandler.mouseReleased(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.documentViewModel.getViewToolMode() == 4) {
            this.textSelectionHandler.mouseDragged(e);
        } else if (this.documentViewModel.getViewToolMode() == 5 || this.documentViewModel.getViewToolMode() == 6) {
            this.annotationHandler.mouseDragged(e);
        }
    }

    public void setTextSelectionRectangle(Point cursorLocation, Rectangle selection) {
        this.textSelectionHandler.setSelectionRectangle(cursorLocation, selection);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.documentViewModel.getViewToolMode() == 4) {
            this.textSelectionHandler.mouseMoved(e);
        } else if (this.documentViewModel.getViewToolMode() == 5) {
            this.annotationHandler.mouseMoved(e);
        }
    }

    public void focusGained(FocusEvent e) {
        int oldCurrentPage = this.documentViewModel.getViewCurrentPageIndex();
        this.documentViewModel.setViewCurrentPageIndex(this.pageIndex);
        this.documentViewController.firePropertyChange("documentCurrentPage", oldCurrentPage, this.pageIndex);
    }

    public void focusLost(FocusEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    private void calculateRoughPageSize(Rectangle pageSize) {
        float width = this.defaultPageSize.width;
        float height = this.defaultPageSize.height;
        float totalRotation = this.documentViewModel.getViewRotation();
        if (totalRotation != 0.0f && totalRotation != 180.0f) {
            if (totalRotation == 90.0f || totalRotation == 270.0f) {
                float temp = width;
                width = height;
                height = temp;
            } else {
                AffineTransform at = new AffineTransform();
                double radians = Math.toRadians(totalRotation);
                at.rotate(radians);
                Rectangle2D.Double boundingBox = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                Point2D.Double src = new Point2D.Double();
                Point2D.Double dst = new Point2D.Double();
                src.setLocation(0.0, height);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(width, height);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(0.0, 0.0);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(width, 0.0);
                at.transform(src, dst);
                boundingBox.add(dst);
                width = (float)boundingBox.getWidth();
                height = (float)boundingBox.getHeight();
            }
        }
        pageSize.setSize((int)(width * this.documentViewModel.getViewZoom()), (int)(height * this.documentViewModel.getViewZoom()));
    }

    private void calculatePageSize(Rectangle pageSize) {
        if (this.pageTree != null) {
            Page currentPage = this.pageTree.getPage(this.pageIndex, this);
            if (currentPage != null) {
                pageSize.setSize(currentPage.getSize(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom()).toDimension());
                this.defaultPageSize.setSize(currentPage.getSize(this.documentViewModel.getPageBoundary(), 0.0f, 1.0f).toDimension());
            }
            this.pageTree.releasePage(currentPage, (Object)this);
        }
    }

    private boolean isBufferDirty() {
        if (this.disposing) {
            return false;
        }
        if (this.pageSize.height <= this.clipBounds.height && this.pageSize.width <= this.clipBounds.width) {
            return false;
        }
        Rectangle tempClipBounds = new Rectangle(this.clipBounds);
        if (this.parentScrollPane != null) {
            tempClipBounds.setBounds(this.parentScrollPane.getViewport().getViewRect());
        }
        Rectangle pageBounds = this.documentViewModel.getPageBounds(this.pageIndex);
        Rectangle normalizedBounds = new Rectangle(this.bufferedPageImageBounds);
        normalizedBounds.x += pageBounds.x;
        normalizedBounds.y += pageBounds.y;
        return !normalizedBounds.contains(pageBounds.intersection(tempClipBounds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBufferedPageImage(PagePainter pagePainter) {
        if (this.disposing) {
            return;
        }
        boolean isPageStateDirty = this.isPageStateDirty();
        this.currentRotation = this.documentViewModel.getViewRotation();
        this.currentZoom = this.documentViewModel.getViewZoom();
        Image pageBufferImage = this.bufferedPageImageReference.get();
        if (isPageStateDirty && pageBufferImage != null) {
            pageBufferImage.flush();
        }
        Rectangle oldBufferedPageImageBounds = new Rectangle(this.bufferedPageImageBounds);
        Rectangle pageBounds = this.documentViewModel.getPageBounds(this.pageIndex);
        if (this.parentScrollPane != null) {
            this.oldClipBounds.setBounds(this.clipBounds);
            this.clipBounds.setBounds(this.parentScrollPane.getViewport().getViewRect());
            if (this.oldClipBounds.width == 0 && this.oldClipBounds.height == 0) {
                this.oldClipBounds.setBounds(this.clipBounds);
            }
        }
        this.bufferedPageImageBounds.setBounds(pageBounds.intersection(this.clipBounds));
        if (this.pageSize.width <= this.clipBounds.width) {
            this.bufferedPageImageBounds.x = 0;
            this.bufferedPageImageBounds.width = this.pageSize.width;
        } else {
            if (horizontalScaleFactor > 1.0) {
                double width = (double)this.clipBounds.width * horizontalScaleFactor / 2.0;
                this.bufferedPageImageBounds.x = (int)((double)this.clipBounds.x - width);
                this.bufferedPageImageBounds.width = (int)((double)this.clipBounds.width + width * 2.0);
            } else {
                this.bufferedPageImageBounds.width = this.clipBounds.width;
            }
            this.bufferedPageImageBounds.x -= pageBounds.x;
        }
        if (this.pageSize.height <= this.clipBounds.height) {
            this.bufferedPageImageBounds.y = 0;
            this.bufferedPageImageBounds.height = this.clipBounds.height;
        } else {
            if (verticalScaleFactor > 1.0) {
                double height = (double)this.clipBounds.height * verticalScaleFactor / 2.0;
                this.bufferedPageImageBounds.y = (int)((double)this.clipBounds.y - height);
                this.bufferedPageImageBounds.height = (int)((double)this.clipBounds.height + height * 2.0);
            } else {
                this.bufferedPageImageBounds.height = this.clipBounds.height;
            }
            this.bufferedPageImageBounds.y -= pageBounds.y;
        }
        pageBufferImage = this.bufferedPageImageReference.get();
        if (isPageStateDirty || pageBufferImage == null) {
            if (pageBufferImage != null) {
                pageBufferImage.flush();
            }
            if (this.gc == null) {
                this.gc = this.getGraphicsConfiguration();
            }
            if (this.gc != null && this.isShowing()) {
                pageBufferImage = this.gc.createCompatibleImage(this.bufferedPageImageBounds.width, this.bufferedPageImageBounds.height);
                Graphics g = pageBufferImage.getGraphics();
                g.setColor(pageColor);
                g.fillRect(0, 0, this.pageSize.width, this.pageSize.height);
            }
            this.bufferedPageImageReference = new SoftReference<Image>(pageBufferImage);
            pagePainter.setIsBufferDirty(false);
        }
        if (this.bufferedPageImageBounds.x < 0) {
            this.bufferedPageImageBounds.x = 0;
        }
        if (this.bufferedPageImageBounds.x + this.bufferedPageImageBounds.width > this.pageSize.width) {
            this.bufferedPageImageBounds.width = this.pageSize.width - this.bufferedPageImageBounds.x;
        }
        if (this.bufferedPageImageBounds.y < 0) {
            this.bufferedPageImageBounds.y = 0;
        }
        if (this.bufferedPageImageBounds.y + this.bufferedPageImageBounds.height > this.pageSize.height) {
            this.bufferedPageImageBounds.height = this.pageSize.height - this.bufferedPageImageBounds.y;
        }
        if (pageBufferImage != null) {
            Graphics2D imageGraphics = (Graphics2D)pageBufferImage.getGraphics();
            imageGraphics.setClip(new Rectangle(0, 0, this.bufferedPageImageBounds.width, this.bufferedPageImageBounds.height));
            int xTrans = 0 - this.bufferedPageImageBounds.x;
            int yTrans = 0 - this.bufferedPageImageBounds.y;
            Object object = this.paintCopyAreaLock;
            synchronized (object) {
                Rectangle normalizedClipBounds = new Rectangle(this.clipBounds);
                normalizedClipBounds.x -= pageBounds.x;
                normalizedClipBounds.y -= pageBounds.y;
                if (!pagePainter.isLastPaintDirty() && pagePainter.isBufferDirty() && this.bufferedPageImageBounds.intersects(oldBufferedPageImageBounds)) {
                    Rectangle copyRect = this.bufferedPageImageBounds.intersection(oldBufferedPageImageBounds);
                    copyRect = copyRect.intersection(normalizedClipBounds);
                    int xTransOld = 0 - oldBufferedPageImageBounds.x;
                    int yTransOld = 0 - oldBufferedPageImageBounds.y;
                    int dx = oldBufferedPageImageBounds.x - this.bufferedPageImageBounds.x;
                    int dy = oldBufferedPageImageBounds.y - this.bufferedPageImageBounds.y;
                    imageGraphics.copyArea(copyRect.x + xTransOld, copyRect.y + yTransOld, copyRect.width, copyRect.height, dx, dy);
                    Area copyArea = new Area(copyRect);
                    Area bufferArea = new Area(this.bufferedPageImageBounds);
                    bufferArea.subtract(copyArea);
                    imageGraphics.translate(xTrans, yTrans);
                    imageGraphics.setClip(bufferArea);
                    imageGraphics.translate(-xTrans, -yTrans);
                } else {
                    imageGraphics.translate(xTrans, yTrans);
                    imageGraphics.setClip(this.bufferedPageImageBounds);
                    imageGraphics.translate(-xTrans, -yTrans);
                }
                imageGraphics.translate(xTrans, yTrans);
                imageGraphics.setColor(pageColor);
                imageGraphics.fillRect(this.bufferedPageImageBounds.x, this.bufferedPageImageBounds.y, this.bufferedPageImageBounds.width, this.bufferedPageImageBounds.height);
            }
            if (this.pageTree != null) {
                Page page = this.pageTree.getPage(this.pageIndex, this);
                page.paint(imageGraphics, 1, this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom(), pagePainter, false, false);
                this.pageTree.releasePage(page, (Object)this);
                if (pagePainter.isStopPaintingRequested()) {
                    pagePainter.setIsLastPaintDirty(true);
                } else {
                    pagePainter.setIsLastPaintDirty(false);
                    pagePainter.setIsBufferDirty(false);
                }
                Runnable doSwingWork = new Runnable(){

                    public void run() {
                        if (!PageViewComponentImpl.this.disposing) {
                            PageViewComponentImpl.this.repaint();
                        }
                    }
                };
                SwingUtilities.invokeLater(doSwingWork);
            }
            imageGraphics.dispose();
        }
    }

    private void addPageRepaintListener() {
        Page currentPage = this.pageTree.getPage(this.pageIndex, this);
        if (currentPage != null) {
            currentPage.addPaintPageListener(this);
        }
        this.pageTree.releasePage(currentPage, (Object)this);
    }

    private void removePageRepaintListener() {
        if (this.inited) {
            Page currentPage = this.pageTree.getPage(this.pageIndex, this);
            if (currentPage != null) {
                currentPage.removePaintPageListener(this);
            }
            this.pageTree.releasePage(currentPage, (Object)this);
        }
    }

    private boolean isPageStateDirty() {
        return this.currentZoom != this.documentViewModel.getViewZoom() || this.currentRotation != this.documentViewModel.getViewRotation() || this.oldClipBounds.width != this.clipBounds.width || this.oldClipBounds.height != this.clipBounds.height;
    }

    private boolean isPageIntersectViewport() {
        Rectangle pageBounds = this.documentViewModel.getPageBounds(this.pageIndex);
        return pageBounds != null && this.isShowing() && pageBounds.intersects(this.parentScrollPane.getViewport().getViewRect());
    }

    public void paintPage(PaintPageEvent event) {
        Object source = event.getSource();
        Page page = this.pageTree.getPage(this.pageIndex, this);
        if (page.equals(source)) {
            Runnable doSwingWork = new Runnable(){

                public void run() {
                    if (!PageViewComponentImpl.this.disposing) {
                        PageViewComponentImpl.this.repaint();
                    }
                }
            };
            SwingUtilities.invokeLater(doSwingWork);
        }
        this.pageTree.releasePage(page, (Object)this);
    }

    static {
        try {
            String color = Defs.sysProperty("org.icepdf.core.views.page.paper.color", "#FFFFFF");
            int colorValue = ColorUtil.convertColor(color);
            pageColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("FFFFFF", 16));
        }
        catch (NumberFormatException e) {
            logger.warning("Error reading page paper color.");
        }
        enablePageLoadingProxy = Defs.booleanProperty("org.icepdf.core.views.page.proxy", true);
        dirtyTimerInterval = 5;
        try {
            verticalScaleFactor = Double.parseDouble(Defs.sysProperty("org.icepdf.core.views.buffersize.vertical", "1.015"));
            horizontalScaleFactor = Double.parseDouble(Defs.sysProperty("org.icepdf.core.views.buffersize.horizontal", "1.015"));
        }
        catch (NumberFormatException e) {
            logger.warning("Error reading buffered scale factor");
        }
        try {
            dirtyTimerInterval = Defs.intProperty("org.icepdf.core.views.dirtytimer.interval", 5);
        }
        catch (NumberFormatException e) {
            logger.log(Level.FINE, "Error reading dirty timer interval");
        }
    }

    private class DirtyTimerAction
    implements ActionListener {
        private DirtyTimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PageViewComponentImpl.this.disposing || !PageViewComponentImpl.this.isPageIntersectViewport()) {
                PageViewComponentImpl.this.isDirtyTimer.stop();
                if (PageViewComponentImpl.this.pagePainter.isRunning()) {
                    PageViewComponentImpl.this.pagePainter.stopPaintingPage();
                    PageViewComponentImpl.this.currentZoom = -1.0f;
                }
                return;
            }
            if (!PageViewComponentImpl.this.disposing) {
                Page page;
                block12: {
                    block11: {
                        if (PageViewComponentImpl.this.parentScrollPane != null && PageViewComponentImpl.this.parentScrollPane.getVerticalScrollBar().getValueIsAdjusting()) {
                            return;
                        }
                        page = PageViewComponentImpl.this.pageTree.getPage(PageViewComponentImpl.this.pageIndex, this);
                        if (!(page == null || page.isInitiated() || PageViewComponentImpl.this.pageInitilizer.isRunning() || PageViewComponentImpl.this.pageInitilizer.hasBeenQueued())) {
                            try {
                                PageViewComponentImpl.this.pageInitilizer.setHasBeenQueued(true);
                                PageViewComponentImpl.this.documentViewModel.executePageInitialization(PageViewComponentImpl.this.pageInitilizer);
                            }
                            catch (InterruptedException ex) {
                                PageViewComponentImpl.this.pageInitilizer.setHasBeenQueued(false);
                                if (!logger.isLoggable(Level.WARNING)) break block11;
                                logger.fine("Page Initialization Interrupted: " + PageViewComponentImpl.this.pageIndex);
                            }
                        }
                    }
                    boolean isBufferDirty = PageViewComponentImpl.this.isBufferDirty();
                    if (page != null && !PageViewComponentImpl.this.pageInitilizer.isRunning() && page.isInitiated() && !PageViewComponentImpl.this.pagePainter.isRunning() && !PageViewComponentImpl.this.pagePainter.hasBeenQueued() && (PageViewComponentImpl.this.isPageStateDirty() || isBufferDirty)) {
                        try {
                            PageViewComponentImpl.this.pagePainter.setHasBeenQueued(true);
                            PageViewComponentImpl.this.pagePainter.setIsBufferDirty(isBufferDirty);
                            PageViewComponentImpl.this.documentViewModel.executePagePainter(PageViewComponentImpl.this.pagePainter);
                        }
                        catch (InterruptedException ex) {
                            PageViewComponentImpl.this.pagePainter.setHasBeenQueued(false);
                            if (!logger.isLoggable(Level.WARNING)) break block12;
                            logger.fine("Page Painter Interrupted: " + PageViewComponentImpl.this.pageIndex);
                        }
                    }
                }
                if (page != null && !PageViewComponentImpl.this.pageInitilizer.isRunning() && page.isInitiated() && !PageViewComponentImpl.this.pagePainter.hasBeenQueued() && PageViewComponentImpl.this.pagePainter.isRunning() && PageViewComponentImpl.this.isPageStateDirty()) {
                    PageViewComponentImpl.this.pagePainter.stopPaintingPage();
                }
                PageViewComponentImpl.this.pageTree.releasePage(page, (Object)this);
            }
        }
    }

    private class PageInitilizer
    implements Runnable {
        private boolean isRunning;
        private final Object isRunningLock = new Object();
        private boolean hasBeenQueued;

        private PageInitilizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.isRunning = true;
            }
            try {
                Page page = PageViewComponentImpl.this.pageTree.getPage(PageViewComponentImpl.this.pageIndex, this);
                page.init();
                PageViewComponentImpl.this.annotationHandler.initializeAnnotationComponents(page.getAnnotations());
                if (PageViewComponentImpl.this.documentViewController.getAnnotationCallback() != null) {
                    PageViewComponentImpl.this.documentViewController.getAnnotationCallback().pageAnnotationsInitialized(page);
                }
                PageViewComponentImpl.this.pageTree.releasePage(page, (Object)this);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Error initiating page: " + PageViewComponentImpl.this.pageIndex, e);
                PageViewComponentImpl.this.pageInitilizer.setHasBeenQueued(true);
                return;
            }
            object = this.isRunningLock;
            synchronized (object) {
                PageViewComponentImpl.this.pageInitilizer.setHasBeenQueued(false);
                this.isRunning = false;
            }
        }

        public boolean hasBeenQueued() {
            return this.hasBeenQueued;
        }

        public void setHasBeenQueued(boolean hasBeenQueued) {
            this.hasBeenQueued = hasBeenQueued;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.isRunning;
            }
        }
    }

    public class PagePainter
    implements Runnable {
        private boolean isRunning;
        private boolean isLastPaintDirty;
        private boolean isBufferyDirty;
        private boolean isStopRequested;
        private final Object isRunningLock = new Object();
        private boolean hasBeenQueued;

        public synchronized boolean isLastPaintDirty() {
            return this.isLastPaintDirty;
        }

        public void setIsLastPaintDirty(boolean isDirty) {
            this.isLastPaintDirty = isDirty;
        }

        public void setIsBufferDirty(boolean isDirty) {
            this.isBufferyDirty = isDirty;
        }

        public boolean isBufferDirty() {
            return this.isBufferyDirty;
        }

        public boolean isStopPaintingRequested() {
            return this.isStopRequested;
        }

        public synchronized void stopPaintingPage() {
            this.isStopRequested = true;
            this.isLastPaintDirty = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.isRunning = true;
                this.hasBeenQueued = false;
            }
            try {
                PageViewComponentImpl.this.createBufferedPageImage(this);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Error creating buffer, page: " + PageViewComponentImpl.this.pageIndex, e);
                PageViewComponentImpl.this.currentZoom = -1.0f;
            }
            object = this.isRunningLock;
            synchronized (object) {
                this.isStopRequested = false;
                this.isRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasBeenQueued() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.hasBeenQueued;
            }
        }

        public void setHasBeenQueued(boolean hasBeenQueued) {
            this.hasBeenQueued = hasBeenQueued;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.isRunning;
            }
        }
    }
}

