/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.HashMap;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class DeviceCMYK
extends PColorSpace {
    public static final Name DEVICECMYK_KEY = new Name("DeviceCMYK");
    public static final Name CMYK_KEY = new Name("CMYK");
    private static float blackRatio = (float)Defs.doubleProperty("org.icepdf.core.cmyk.colorant.black", 1.0);

    DeviceCMYK(Library l, HashMap h) {
        super(l, h);
    }

    public int getNumComponents() {
        return 4;
    }

    public Color getColor(float[] f) {
        return DeviceCMYK.alternative2(f);
    }

    private static Color alternative1(float[] f) {
        float c = f[3];
        float m = f[2];
        float y = f[1];
        float k = f[0];
        float r = 1.0f - Math.min(1.0f, c + k);
        float g = 1.0f - Math.min(1.0f, m + k);
        float b = 1.0f - Math.min(1.0f, y + k);
        return new Color(r, g, b);
    }

    private static Color alternative3(float[] f) {
        float c = f[3];
        float m = f[2];
        float y = f[1];
        float k = f[0];
        float r = 1.0f - Math.min(1.0f, c * (1.0f - k) + k);
        float g = 1.0f - Math.min(1.0f, m * (1.0f - k) + k);
        float b = 1.0f - Math.min(1.0f, y * (1.0f - k) + k);
        return new Color(r, g, b);
    }

    private static Color getAutoCadColor(float[] f) {
        float c = f[3];
        float m = f[2];
        float y = f[1];
        float k = f[0];
        int red = Math.round((1.0f - c) * (1.0f - k) * 255.0f);
        int blue = Math.round((1.0f - y) * (1.0f - k) * 255.0f);
        int green = Math.round((1.0f - m) * (1.0f - k) * 255.0f);
        return new Color(red, green, blue);
    }

    private static Color getGhostColor(float[] f) {
        int cyan = (int)(f[3] * 255.0f);
        int magenta = (int)(f[2] * 255.0f);
        int yellow = (int)(f[1] * 255.0f);
        int black = (int)(f[0] * 255.0f);
        float colors = 255 - black;
        float[] rgb = new float[]{colors * (float)(255 - cyan) / 255.0f, colors * (float)(255 - magenta) / 255.0f, colors * (float)(255 - yellow) / 255.0f};
        return new Color((int)rgb[0], (int)rgb[1], (int)rgb[2]);
    }

    private static Color alternative2(float[] f) {
        float inCyan = f[3];
        float inMagenta = f[2];
        float inYellow = f[1];
        float inBlack = f[0];
        if (inCyan != 0.0f && inMagenta != 0.0f && inYellow != 0.0f) {
            inBlack = f[0] * blackRatio;
        }
        double c = DeviceCMYK.clip(0.0, 1.0, inCyan + inBlack);
        double m = DeviceCMYK.clip(0.0, 1.0, inMagenta + inBlack);
        double y = DeviceCMYK.clip(0.0, 1.0, inYellow + inBlack);
        double aw = (1.0 - c) * (1.0 - m) * (1.0 - y);
        double ac = c * (1.0 - m) * (1.0 - y);
        double am = (1.0 - c) * m * (1.0 - y);
        double ay = (1.0 - c) * (1.0 - m) * y;
        double ar = (1.0 - c) * m * y;
        double ag = c * (1.0 - m) * y;
        double ab = c * m * (1.0 - y);
        float outRed = (float)DeviceCMYK.clip(0.0, 1.0, aw + 0.9137 * am + 0.9961 * ay + 0.9882 * ar);
        float outGreen = (float)DeviceCMYK.clip(0.0, 1.0, aw + 0.6196 * ac + ay + 0.5176 * ag);
        float outBlue = (float)DeviceCMYK.clip(0.0, 1.0, aw + 0.7804 * ac + 0.5412 * am + 0.0667 * ar + 0.2118 * ag + 0.4863 * ab);
        return new Color(outRed, outGreen, outBlue);
    }

    private static double clip(double floor, double ceiling, double value) {
        if (value < floor) {
            value = floor;
        }
        if (value > ceiling) {
            value = ceiling;
        }
        return value;
    }
}

