/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.text;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import org.icepdf.core.pobjects.OptionalContents;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.TextSelect;
import org.icepdf.core.pobjects.graphics.text.WordText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageText
implements TextSelect {
    private LineText currentLine;
    private ArrayList<LineText> pageLines = new ArrayList(50);
    private HashMap<OptionalContents, PageText> optionalPageLines;

    public void newLine(LinkedList<OptionalContents> oCGs) {
        if (oCGs != null && oCGs.size() > 0) {
            OptionalContents optionalContent;
            PageText pageText;
            if (this.optionalPageLines == null) {
                this.optionalPageLines = new HashMap(10);
            }
            if ((pageText = this.optionalPageLines.get(optionalContent = oCGs.peek())) == null) {
                pageText = new PageText();
                pageText.newLine();
                this.optionalPageLines.put(optionalContent, pageText);
            } else {
                pageText.newLine();
            }
        } else {
            this.newLine();
        }
    }

    protected void newLine() {
        if (this.currentLine != null && this.currentLine.getWords().size() == 0) {
            return;
        }
        this.currentLine = new LineText();
        this.pageLines.add(this.currentLine);
    }

    protected void addGlyph(GlyphText sprite) {
        if (this.currentLine == null) {
            this.newLine();
        }
        this.currentLine.addText(sprite);
    }

    public ArrayList<LineText> getPageLines() {
        ArrayList<LineText> visiblePageLines = new ArrayList<LineText>(this.pageLines);
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                if (key == null || !key.isVisible()) continue;
                visiblePageLines.addAll(this.optionalPageLines.get(key).getPageLines());
            }
        }
        return visiblePageLines;
    }

    public void addGlyph(GlyphText glyphText, LinkedList<OptionalContents> oCGs) {
        if (oCGs != null && oCGs.size() > 0) {
            if (oCGs.peek() != null) {
                this.addOptionalPageLines(oCGs.peek(), glyphText);
            }
        } else {
            this.addGlyph(glyphText);
        }
    }

    protected void addOptionalPageLines(OptionalContents optionalContent, GlyphText sprite) {
        PageText pageText;
        if (this.optionalPageLines == null) {
            this.optionalPageLines = new HashMap(10);
        }
        if ((pageText = this.optionalPageLines.get(optionalContent)) == null) {
            pageText = new PageText();
            pageText.addGlyph(sprite);
            this.optionalPageLines.put(optionalContent, pageText);
        } else {
            pageText.addGlyph(sprite);
        }
    }

    public void applyXObjectTransform(AffineTransform transform) {
        for (LineText lineText : this.pageLines) {
            lineText.clearBounds();
            for (WordText wordText : lineText.getWords()) {
                wordText.clearBounds();
                for (GlyphText glyph : wordText.getGlyphs()) {
                    glyph.normalizeToUserSpace(transform);
                }
            }
        }
    }

    @Override
    public void clearSelected() {
        for (LineText lineText : this.pageLines) {
            lineText.clearSelected();
        }
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                if (key == null || !key.isVisible()) continue;
                ArrayList<LineText> optionalLines = this.optionalPageLines.get(key).getPageLines();
                for (LineText lineText : optionalLines) {
                    lineText.clearSelected();
                }
            }
        }
    }

    @Override
    public void clearHighlighted() {
        for (LineText lineText : this.pageLines) {
            lineText.clearHighlighted();
        }
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                if (key == null || !key.isVisible()) continue;
                ArrayList<LineText> optionalLines = this.optionalPageLines.get(key).getPageLines();
                for (LineText lineText : optionalLines) {
                    lineText.clearHighlighted();
                }
            }
        }
    }

    @Override
    public StringBuilder getSelected() {
        StringBuilder selectedText = new StringBuilder();
        for (LineText lineText : this.pageLines) {
            selectedText.append((CharSequence)lineText.getSelected());
        }
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                if (key == null || !key.isVisible()) continue;
                ArrayList<LineText> optionalLines = this.optionalPageLines.get(key).getPageLines();
                for (LineText lineText : optionalLines) {
                    selectedText.append((CharSequence)lineText.getSelected());
                }
            }
        }
        return selectedText;
    }

    @Override
    public void selectAll() {
        for (LineText lineText : this.pageLines) {
            lineText.selectAll();
        }
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                if (key == null || !key.isVisible()) continue;
                ArrayList<LineText> optionalLines = this.optionalPageLines.get(key).getPageLines();
                for (LineText lineText : optionalLines) {
                    lineText.selectAll();
                }
            }
        }
    }

    public void deselectAll() {
        for (LineText lineText : this.pageLines) {
            lineText.clearSelected();
        }
    }

    public String toString() {
        StringBuilder extractedText = new StringBuilder();
        for (LineText lineText : this.pageLines) {
            for (WordText wordText : lineText.getWords()) {
                extractedText.append(wordText.getText());
            }
            extractedText.append('\n');
        }
        return extractedText.toString();
    }
}

