/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class OutlineItem
extends Dictionary {
    public static final Name A_KEY = new Name("A");
    public static final Name COUNT_KEY = new Name("Count");
    public static final Name TITLE_KEY = new Name("Title");
    public static final Name DEST_KEY = new Name("Dest");
    public static final Name FIRST_KEY = new Name("First");
    public static final Name LAST_KEY = new Name("Last");
    public static final Name NEXT_KEY = new Name("Next");
    public static final Name PREV_KEY = new Name("Prev");
    public static final Name PARENT_KEY = new Name("Parent");
    private String title;
    private Destination dest;
    private Action action;
    private Reference parent;
    private Reference prev;
    private Reference next;
    private Reference first;
    private Reference last;
    private int count = -1;
    private boolean loadedSubItems = false;
    private List<OutlineItem> subItems = new ArrayList<OutlineItem>(Math.max(Math.abs(this.getCount()), 16));

    public OutlineItem(Library l, HashMap h) {
        super(l, h);
    }

    public boolean isEmpty() {
        return this.getTitle() == null && this.getDest() == null && this.getAction() == null;
    }

    public int getSubItemCount() {
        this.ensureSubItemsLoaded();
        if (this.subItems != null) {
            return this.subItems.size();
        }
        return 0;
    }

    public OutlineItem getSubItem(int index) {
        this.ensureSubItemsLoaded();
        return this.subItems.get(index);
    }

    public Action getAction() {
        Object obj;
        if (this.action == null && (obj = this.library.getObject(this.entries, A_KEY)) instanceof HashMap) {
            this.action = new Action(this.library, (HashMap)obj);
        }
        return this.action;
    }

    public Reference getFirst() {
        Object attribute;
        if (this.first == null && (attribute = this.entries.get(FIRST_KEY)) instanceof Reference) {
            this.first = (Reference)attribute;
        }
        return this.first;
    }

    public Reference getLast() {
        Object attribute;
        if (this.last == null && (attribute = this.entries.get(LAST_KEY)) instanceof Reference) {
            this.last = (Reference)attribute;
        }
        return this.last;
    }

    public Reference getNext() {
        Object attribute;
        if (this.next == null && (attribute = this.entries.get(NEXT_KEY)) instanceof Reference) {
            this.next = (Reference)attribute;
        }
        return this.next;
    }

    public Reference getPrev() {
        Object attribute;
        if (this.prev == null && (attribute = this.entries.get(PREV_KEY)) instanceof Reference) {
            this.prev = (Reference)attribute;
        }
        return this.prev;
    }

    public Reference getParent() {
        Object attribute;
        if (this.parent == null && (attribute = this.entries.get(PARENT_KEY)) instanceof Reference) {
            this.parent = (Reference)attribute;
        }
        return this.parent;
    }

    private int getCount() {
        if (this.count < 0) {
            this.count = this.library.getInt(this.entries, COUNT_KEY);
        }
        return this.count;
    }

    public String getTitle() {
        Object obj;
        if (this.title == null && (obj = this.library.getObject(this.entries, TITLE_KEY)) instanceof StringObject) {
            this.title = Utils.convertStringObject(this.library, (StringObject)obj);
        }
        return this.title;
    }

    public Destination getDest() {
        Object obj;
        if (this.dest == null && (obj = this.library.getObject(this.entries, DEST_KEY)) != null) {
            this.dest = new Destination(this.library, obj);
        }
        return this.dest;
    }

    private void ensureSubItemsLoaded() {
        if (this.loadedSubItems) {
            return;
        }
        this.loadedSubItems = true;
        if (this.getFirst() != null) {
            HashMap dictionary;
            Reference nextReference = this.getFirst();
            while (nextReference != null && (dictionary = (HashMap)this.library.getObject(nextReference)) != null) {
                OutlineItem outLineItem = new OutlineItem(this.library, dictionary);
                this.subItems.add(outLineItem);
                Reference oldNextReference = nextReference;
                if (!oldNextReference.equals(nextReference = outLineItem.getNext())) continue;
                break;
            }
        }
    }
}

