/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.filters.ChunkingInputStream;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class PredictorDecode
extends ChunkingInputStream {
    protected static final int PREDICTOR_NONE = 1;
    protected static final int PREDICTOR_TIFF_2 = 2;
    protected static final int PREDICTOR_PNG_NONE = 10;
    protected static final int PREDICTOR_PNG_SUB = 11;
    protected static final int PREDICTOR_PNG_UP = 12;
    protected static final int PREDICTOR_PNG_AVG = 13;
    protected static final int PREDICTOR_PNG_PAETH = 14;
    protected static final int PREDICTOR_PNG_OPTIMUM = 15;
    protected static final Name DECODE_PARMS_VALUE = new Name("DecodeParms");
    protected static final Name PREDICTOR_VALUE = new Name("Predictor");
    protected static final Name WIDTH_VALUE = new Name("Width");
    protected static final Name COLUMNS_VALUE = new Name("Columns");
    protected static final Name COLORS_VALUE = new Name("Colors");
    protected static final Name BITS_PER_COMPONENT_VALUE = new Name("BitsPerComponent");
    protected static final Name EARLY_CHANGE_VALUE = new Name("EarlyChange");
    protected int predictor;
    protected int numComponents;
    protected int bitsPerComponent;
    protected int width;
    protected int bytesPerPixel = 1;
    protected byte[] aboveBuffer;

    public PredictorDecode(InputStream input, Library library, HashMap entries) {
        Object bitsPerComponentDecodeParmsObj;
        HashMap decodeParmsDictionary = library.getDictionary(entries, DECODE_PARMS_VALUE);
        this.predictor = library.getInt(decodeParmsDictionary, PREDICTOR_VALUE);
        Number widthNumber = library.getNumber(entries, WIDTH_VALUE);
        this.width = widthNumber != null ? widthNumber.intValue() : library.getInt(decodeParmsDictionary, COLUMNS_VALUE);
        this.numComponents = 1;
        this.bitsPerComponent = 8;
        Object numComponentsDecodeParmsObj = library.getObject(decodeParmsDictionary, COLORS_VALUE);
        if (numComponentsDecodeParmsObj instanceof Number) {
            this.numComponents = ((Number)numComponentsDecodeParmsObj).intValue();
        }
        if ((bitsPerComponentDecodeParmsObj = library.getObject(decodeParmsDictionary, BITS_PER_COMPONENT_VALUE)) instanceof Number) {
            this.bitsPerComponent = ((Number)bitsPerComponentDecodeParmsObj).intValue();
        }
        this.bytesPerPixel = Math.max(1, Utils.numBytesToHoldBits(this.numComponents * this.bitsPerComponent));
        int intermediateBufferSize = Utils.numBytesToHoldBits(this.width * this.numComponents * this.bitsPerComponent);
        this.aboveBuffer = new byte[intermediateBufferSize];
        this.setBufferSize(intermediateBufferSize);
        this.setInputStream(input);
    }

    protected int fillInternalBuffer() throws IOException {
        byte[] temp = this.aboveBuffer;
        this.aboveBuffer = this.buffer;
        this.buffer = temp;
        int cp = this.in.read();
        if (cp < 0) {
            return -1;
        }
        int currPredictor = cp + 10;
        int numRead = this.fillBufferFromInputStream();
        if (numRead <= 0) {
            return -1;
        }
        this.applyPredictor(numRead, currPredictor);
        return numRead;
    }

    protected void applyPredictor(int numRead, int currPredictor) {
        for (int i = 0; i < numRead && currPredictor != 10; ++i) {
            int above;
            int left;
            if (currPredictor == 11) {
                if (i - this.bytesPerPixel < 0) continue;
                int n = i;
                this.buffer[n] = (byte)(this.buffer[n] + PredictorDecode.applyLeftPredictor(this.buffer, this.bytesPerPixel, i));
                continue;
            }
            if (currPredictor == 12) {
                if (this.aboveBuffer == null) continue;
                int n = i;
                this.buffer[n] = (byte)(this.buffer[n] + PredictorDecode.applyAbovePredictor(this.aboveBuffer, i));
                continue;
            }
            if (currPredictor == 13) {
                left = 0;
                if (i - this.bytesPerPixel >= 0) {
                    left = PredictorDecode.applyLeftPredictor(this.buffer, this.bytesPerPixel, i);
                }
                above = 0;
                if (this.aboveBuffer != null) {
                    above = PredictorDecode.applyAbovePredictor(this.aboveBuffer, i);
                }
                int sum = left + above;
                byte avg = (byte)(sum >>> 1 & 0xFF);
                int n = i;
                this.buffer[n] = (byte)(this.buffer[n] + avg);
                continue;
            }
            if (currPredictor != 14) continue;
            left = 0;
            if (i - this.bytesPerPixel >= 0) {
                left = PredictorDecode.applyLeftPredictor(this.buffer, this.bytesPerPixel, i);
            }
            above = 0;
            if (this.aboveBuffer != null) {
                above = PredictorDecode.applyAbovePredictor(this.aboveBuffer, i);
            }
            int aboveLeft = 0;
            if (i - this.bytesPerPixel >= 0 && this.aboveBuffer != null) {
                aboveLeft = PredictorDecode.applyAboveLeftPredictor(this.aboveBuffer, this.bytesPerPixel, i);
            }
            int p = left + above - aboveLeft;
            int pLeft = Math.abs(p - left);
            int pAbove = Math.abs(p - above);
            int pAboveLeft = Math.abs(p - aboveLeft);
            int paeth = pLeft <= pAbove && pLeft <= pAboveLeft ? left : (pAbove <= pAboveLeft ? above : aboveLeft);
            int n = i;
            this.buffer[n] = (byte)(this.buffer[n] + (byte)(paeth & 0xFF));
        }
    }

    private static int applyLeftPredictor(byte[] buffer, int bytesPerPixel, int i) {
        return buffer[i - bytesPerPixel] & 0xFF;
    }

    private static int applyAbovePredictor(byte[] aboveBuffer, int i) {
        return aboveBuffer[i] & 0xFF;
    }

    private static int applyAboveLeftPredictor(byte[] aboveBuffer, int bytesPerPixel, int i) {
        return aboveBuffer[i - bytesPerPixel] & 0xFF;
    }

    public static boolean isPredictor(Library library, HashMap entries) {
        HashMap decodeParmsDictionary = library.getDictionary(entries, DECODE_PARMS_VALUE);
        if (decodeParmsDictionary == null) {
            return false;
        }
        int predictor = library.getInt(decodeParmsDictionary, PREDICTOR_VALUE);
        return predictor == 10 || predictor == 11 || predictor == 12 || predictor == 13 || predictor == 14 || predictor == 15;
    }
}

