/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertSeedValueDictionary
extends Dictionary {
    public static final Name SV_CERT_TYPE_VALUE = new Name("SVCert");
    public static final Name Ff_KEY = new Name("Ff");
    private static final int Ff_SUBJECT_BIT = 1;
    private static final int Ff_ISSUER_BIT = 2;
    private static final int Ff_OID_BIT = 4;
    private static final int Ff_SUBJECT_DN_BIT = 8;
    private static final int Ff_RESERVED_BIT = 16;
    private static final int Ff_KEY_USAGE_BIT = 32;
    private static final int Ff_URL_BIT = 64;
    public static final Name SUBJECT_KEY = new Name("Subject");
    public static final Name SUBJECT_DN_KEY = new Name("SubjectDN");
    public static final Name KEY_USAGE_KEY = new Name("KeyUsage");
    public static final Name ISSUER_KEY = new Name("Issuer");
    public static final Name OID_KEY = new Name("OID");
    public static final Name URL_KEY = new Name("URL");
    public static final Name URL_TYPE_KEY = new Name("URLType");
    private int flags;

    public CertSeedValueDictionary(Library library, HashMap entries) {
        super(library, entries);
        this.flags = library.getInt(entries, Ff_KEY);
    }

    public List getSubject() {
        List tmp = this.library.getArray(this.entries, SUBJECT_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public List<HashMap> getSubjectDn() {
        List tmp = this.library.getArray(this.entries, SUBJECT_DN_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public List<String> getKeyUsage() {
        List tmp = this.library.getArray(this.entries, KEY_USAGE_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public List getIssuer() {
        List tmp = this.library.getArray(this.entries, ISSUER_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public List getIOD() {
        List tmp = this.library.getArray(this.entries, OID_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public String getUrl() {
        return this.library.getString(this.entries, URL_KEY);
    }

    public Name getUrlType() {
        return this.library.getName(this.entries, URL_TYPE_KEY);
    }

    public boolean isSubject() {
        return (this.flags & 1) == 1;
    }

    public boolean isIssuer() {
        return (this.flags & 2) == 2;
    }

    public boolean isOid() {
        return (this.flags & 4) == 4;
    }

    public boolean isSubjectDn() {
        return (this.flags & 8) == 8;
    }

    public boolean isReserved() {
        return (this.flags & 0x10) == 16;
    }

    public boolean isKeyUsage() {
        return (this.flags & 0x20) == 32;
    }

    public boolean isUrl() {
        return (this.flags & 0x40) == 64;
    }
}

