/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.acroform.TextFieldDictionary;
import org.icepdf.core.pobjects.acroform.VariableTextFieldDictionary;
import org.icepdf.core.pobjects.annotations.AbstractWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.FontManager;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextWidgetAnnotation
extends AbstractWidgetAnnotation<TextFieldDictionary> {
    protected FontFile fontFile;
    private TextFieldDictionary fieldDictionary;

    public TextWidgetAnnotation(Library l, HashMap h) {
        super(l, h);
        this.fieldDictionary = new TextFieldDictionary(this.library, this.entries);
        FontFile fontFile = this.fontFile = this.fieldDictionary.getFont() != null ? this.fieldDictionary.getFont().getFont() : null;
        if (this.fontFile == null) {
            this.fontFile = FontManager.getInstance().initialize().getInstance(this.fieldDictionary.getFontName().toString(), 0);
        }
    }

    @Override
    public void resetAppearanceStream(double dx, double dy, AffineTransform pageTransform) {
        TextFieldDictionary.TextFieldType textFieldType = this.fieldDictionary.getTextFieldType();
        if (textFieldType != TextFieldDictionary.TextFieldType.TEXT_PASSWORD) {
            Form appearanceStream;
            Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
            AppearanceState appearanceState = appearance.getSelectedAppearanceState();
            Rectangle2D bbox = appearanceState.getBbox();
            AffineTransform matrix = new AffineTransform();
            String currentContentStream = appearanceState.getOriginalContentStream();
            if ((currentContentStream = this.buildTextWidgetContents(currentContentStream)) != null) {
                appearanceState.setContentStream(currentContentStream.getBytes());
            }
            if ((appearanceStream = this.getOrGenerateAppearanceForm()) != null) {
                appearanceStream.setRawBytes(currentContentStream.getBytes());
                StateManager stateManager = this.library.getStateManager();
                stateManager.addChange(new PObject(appearanceStream, appearanceStream.getPObjectReference()));
                HashMap<Name, Reference> appearanceRefs = new HashMap<Name, Reference>();
                appearanceRefs.put(APPEARANCE_STREAM_NORMAL_KEY, appearanceStream.getPObjectReference());
                this.entries.put(APPEARANCE_STREAM_KEY, appearanceRefs);
                Rectangle2D.Float formBbox = new Rectangle2D.Float((float)bbox.getX(), (float)bbox.getY(), (float)bbox.getWidth(), (float)bbox.getHeight());
                appearanceStream.setAppearance(null, matrix, formBbox);
                if (this.library.getResources(appearanceStream.getEntries(), Form.RESOURCES_KEY) == null && this.library.getCatalog().getInteractiveForm().getResources() != null) {
                    appearanceStream.getEntries().put(Form.RESOURCES_KEY, this.library.getCatalog().getInteractiveForm().getResources().getEntries());
                } else {
                    Page page = this.getPage();
                    if (page != null && page.getResources() != null) {
                        appearanceStream.getEntries().put(Form.RESOURCES_KEY, page.getResources().getEntries());
                    }
                }
                stateManager.addChange(new PObject(this, this.getPObjectReference()));
                if (compressAppearanceStream) {
                    appearanceStream.getEntries().put(Stream.FILTER_KEY, new Name("FlateDecode"));
                } else {
                    appearanceStream.getEntries().remove(Stream.FILTER_KEY);
                }
                appearanceStream.init();
            }
        }
    }

    public String buildTextWidgetContents(String currentContentStream) {
        if (currentContentStream == null || currentContentStream.equals("")) {
            currentContentStream = " /Tx BMC q BT ET Q EMC";
        }
        String contents = (String)this.fieldDictionary.getFieldValue();
        int btStart = currentContentStream.indexOf("BMC") + 3;
        int etEnd = currentContentStream.lastIndexOf("EMC");
        String preBt = "";
        String postEt = "";
        String markedContent = "";
        if (btStart >= 0 && etEnd >= 0) {
            preBt = currentContentStream.substring(0, btStart) + " BT ";
            postEt = "ET " + currentContentStream.substring(etEnd);
            markedContent = currentContentStream.substring(btStart, etEnd);
        } else {
            preBt = "/Tx BMC q BT ";
            postEt = " ET Q EMC ";
        }
        Rectangle2D.Float bounds = this.findRectangle(preBt);
        boolean isfourthQuadrant = false;
        if (bounds != null && bounds.getHeight() < 0.0) {
            isfourthQuadrant = true;
        }
        StringBuilder content = new StringBuilder();
        double lineHeight = this.getLineHeight(this.fieldDictionary.getDefaultAppearance());
        Page parentPage = this.getPage();
        content.append(this.generateDefaultAppearance(markedContent, parentPage != null ? parentPage.getResources() : null, this.fieldDictionary));
        if (this.fieldDictionary.getDefaultAppearance() == null) {
            lineHeight = this.getFontSize(markedContent);
        }
        if (!isfourthQuadrant) {
            double height = this.getBbox().getHeight();
            double size = this.fieldDictionary.getSize();
            content.append(lineHeight).append(" TL ");
            double hOffset = Math.ceil(size + (height - size));
            content.append(2).append(' ').append(hOffset).append(" Td ");
        } else {
            content.append(2).append(' ').append(2).append(" Td ");
        }
        content = this.encodeHexString(content, contents);
        currentContentStream = preBt + content + postEt;
        return currentContentStream;
    }

    @Override
    public void reset() {
        Object oldValue = this.fieldDictionary.getFieldValue();
        Object tmp = this.fieldDictionary.getDefaultFieldValue();
        if (tmp != null) {
            this.fieldDictionary.setFieldValue(this.fieldDictionary.getDefaultFieldValue(), this.getPObjectReference());
            this.changeSupport.firePropertyChange("valueFieldReset", oldValue, this.fieldDictionary.getFieldValue());
        } else {
            this.fieldDictionary.getEntries().remove(FieldDictionary.V_KEY);
            this.fieldDictionary.setFieldValue("", this.getPObjectReference());
            if (this.changeSupport != null) {
                this.changeSupport.firePropertyChange("valueFieldReset", oldValue, "");
            }
        }
    }

    @Override
    public TextFieldDictionary getFieldDictionary() {
        return this.fieldDictionary;
    }

    public String generateDefaultAppearance(String content, Resources resources, VariableTextFieldDictionary variableTextFieldDictionary) {
        if (variableTextFieldDictionary != null) {
            return variableTextFieldDictionary.generateDefaultAppearance(content, resources);
        }
        return null;
    }
}

