/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.image.BufferedImage;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.CachedImageReference;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ImagePool;
import org.icepdf.core.util.Library;

public class ImageStreamReference
extends CachedImageReference {
    private static final Logger logger = Logger.getLogger(ImageStreamReference.class.toString());

    protected ImageStreamReference(ImageStream imageStream, GraphicsState graphicsState, Resources resources, int imageIndex, Page page) {
        super(imageStream, graphicsState, resources, imageIndex, page);
        ImagePool imagePool = imageStream.getLibrary().getImagePool();
        if (useProxy && imagePool.get(this.reference) == null) {
            this.futureTask = new FutureTask<BufferedImage>(this);
            Library.executeImage(this.futureTask);
        } else if (!useProxy && imagePool.get(this.reference) == null) {
            this.image = this.call();
        }
    }

    public int getWidth() {
        return this.imageStream.getWidth();
    }

    public int getHeight() {
        return this.imageStream.getHeight();
    }

    public BufferedImage call() {
        BufferedImage image = null;
        long start = System.nanoTime();
        try {
            image = this.imageStream.getImage(this.graphicsState, this.resources);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Error loading image: " + this.imageStream.getPObjectReference() + " " + this.imageStream.toString(), e);
        }
        long end = System.nanoTime();
        this.notifyImagePageEvents(end - start);
        return image;
    }
}

