/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.immutables.value.internal.;
import org.immutables.value.internal.$generator$.$PostprocessingMachine;
import org.immutables.value.internal.$generator$.$StaticEnvironment;
import org.immutables.value.internal.$guava$.base.$CharMatcher;
import org.immutables.value.internal.$guava$.base.$Joiner;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Predicates;
import org.immutables.value.internal.$guava$.base.$Splitter;
import org.immutables.value.internal.$guava$.base.$Strings;
import org.immutables.value.internal.$guava$.base.$Supplier;
import org.immutables.value.internal.$guava$.base.$Throwables;
import org.immutables.value.internal.$guava$.collect.$FluentIterable;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Sets;
import org.immutables.value.internal.$guava$.io.$CharSink;
import org.immutables.value.internal.$guava$.io.$CharSource;
import org.immutables.value.internal.$guava$.io.$CharStreams;

public final class $Output {
    public final .generator..Templates.Invokable error = new .generator..Templates.Invokable(){

        @Override
        @Nullable
        public .generator..Templates.Invokable invoke(.generator..Templates.Invokation invokation, Object ... parameters) {
            String message = $CharMatcher.WHITESPACE.trimFrom(parameters[0].toString());
            $StaticEnvironment.processing().getMessager().printMessage(Diagnostic.Kind.ERROR, message);
            return null;
        }

        @Override
        public int arity() {
            return 1;
        }
    };
    public final .generator..Templates.Invokable system = new .generator..Templates.Invokable(){

        @Override
        @Nullable
        public .generator..Templates.Invokable invoke(.generator..Templates.Invokation invokation, Object ... parameters) {
            String message = $CharMatcher.WHITESPACE.trimFrom(parameters[0].toString());
            System.out.println(message);
            return null;
        }

        @Override
        public int arity() {
            return 1;
        }
    };
    public final .generator..Templates.Invokable trim = new OutputFilter(){

        @Override
        void apply(.generator..Templates.Invokation invokation, CharSequence content, @Nullable .generator..Templates.Invokable original) {
            invokation.out($CharMatcher.WHITESPACE.trimFrom(content));
        }
    };
    public final .generator..Templates.Invokable linesShortable = new OutputFilter(){
        private static final int LIMIT = 100;

        @Override
        void apply(.generator..Templates.Invokation invokation, CharSequence content, @Nullable .generator..Templates.Invokable original) {
            String collapsed = $CharMatcher.WHITESPACE.trimAndCollapseFrom(content, ' ');
            int estimatedLimitOnThisLine = 100 - invokation.consumer.getCurrentIndentation().length();
            if (collapsed.length() < estimatedLimitOnThisLine) {
                invokation.out(collapsed);
            } else if (original != null) {
                original.invoke(invokation, new Object[0]);
            } else {
                invokation.out(content);
            }
        }
    };
    public final .generator..Templates.Invokable collapsible = new OutputFilter(){

        @Override
        void apply(.generator..Templates.Invokation invokation, CharSequence content, @Nullable .generator..Templates.Invokable original) {
            boolean hasNonWhitespace;
            boolean bl = hasNonWhitespace = !$CharMatcher.WHITESPACE.matchesAllOf(content);
            if (hasNonWhitespace) {
                if (original != null) {
                    original.invoke(invokation, new Object[0]);
                } else {
                    invokation.out(content);
                }
            }
        }
    };
    public final .generator..Templates.Invokable java = new .generator..Templates.Invokable(){

        @Override
        public .generator..Templates.Invokable invoke(.generator..Templates.Invokation invokation, Object ... parameters) {
            String packageName = parameters[0].toString();
            String simpleName = parameters[1].toString();
            .generator..Templates.Invokable body = (.generator..Templates.Invokable)parameters[2];
            ResourceKey key = new ResourceKey(packageName, simpleName);
            SourceFile javaFile = $Output.getFiles().sourceFiles.get(key);
            body.invoke(new .generator..Templates.Invokation(javaFile.consumer, new Object[0]), new Object[0]);
            javaFile.complete();
            return null;
        }

        @Override
        public int arity() {
            return 3;
        }
    };
    public final .generator..Templates.Invokable service = new .generator..Templates.Invokable(){
        private static final String META_INF_SERVICES = "META-INF/services/";

        @Override
        public .generator..Templates.Invokable invoke(.generator..Templates.Invokation invokation, Object ... parameters) {
            String interfaceName = parameters[0].toString();
            .generator..Templates.Invokable body = (.generator..Templates.Invokable)parameters[1];
            ResourceKey key = new ResourceKey("", META_INF_SERVICES + interfaceName);
            AppendServiceFile servicesFile = $Output.getFiles().appendResourceFiles.get(key);
            body.invoke(new .generator..Templates.Invokation(servicesFile.consumer, new Object[0]), new Object[0]);
            return null;
        }

        @Override
        public int arity() {
            return 3;
        }
    };

    private static Filer getFiler() {
        return $StaticEnvironment.processing().getFiler();
    }

    private static Messager getMessager() {
        return $StaticEnvironment.processing().getMessager();
    }

    private static Files getFiles() {
        return $StaticEnvironment.getInstance(Files.class, FilesSupplier.INSTANCE);
    }

    private static class Files
    implements $StaticEnvironment.Completable {
        final Cache<ResourceKey, SourceFile> sourceFiles = new Cache<ResourceKey, SourceFile>(){

            @Override
            public SourceFile load(ResourceKey key) throws Exception {
                return new SourceFile(key);
            }
        };
        final Cache<ResourceKey, AppendServiceFile> appendResourceFiles = new Cache<ResourceKey, AppendServiceFile>(){

            @Override
            public AppendServiceFile load(ResourceKey key) throws Exception {
                return new AppendServiceFile(key);
            }
        };

        private Files() {
        }

        @Override
        public void complete() {
            for (AppendServiceFile file : this.appendResourceFiles.asMap().values()) {
                file.complete();
            }
        }
    }

    @NotThreadSafe
    private static abstract class Cache<K, V> {
        private final Map<K, V> map = new HashMap();

        private Cache() {
        }

        protected abstract V load(K var1) throws Exception;

        final V get(K key) {
            V value = this.map.get(key);
            if (value == null) {
                try {
                    value = this.load(key);
                }
                catch (Exception ex) {
                    throw $Throwables.propagate(ex);
                }
                this.map.put(key, value);
            }
            return value;
        }

        public Map<K, V> asMap() {
            return this.map;
        }
    }

    private static enum FilesSupplier implements $Supplier<Files>
    {
        INSTANCE;


        @Override
        public Files get() {
            return new Files();
        }
    }

    private static class SourceFile {
        final ResourceKey key;
        final .generator..Templates.CharConsumer consumer = new .generator..Templates.CharConsumer();

        SourceFile(ResourceKey key) {
            this.key = key;
        }

        void complete() {
            CharSequence sourceCode = this.extractSourceCode();
            try (Writer writer = $Output.getFiler().createSourceFile(this.key.toString(), new Element[0]).openWriter();){
                writer.append(sourceCode);
            }
            catch (FilerException ex) {
                if (this.identicalFileIsAlreadyGenerated(sourceCode)) {
                    $Output.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Regenerated file with the same content: " + this.key);
                } else {
                    $Output.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Generated source file name collission. Attempt to overwrite already generated file: %s, %s", this.key, ex));
                }
            }
            catch (IOException ex) {
                throw $Throwables.propagate(ex);
            }
        }

        private boolean identicalFileIsAlreadyGenerated(CharSequence sourceCode) {
            try {
                String existingContent = new $CharSource(){
                    final String packagePath;
                    final String filename;
                    {
                        this.packagePath = !SourceFile.this.key.packageName.isEmpty() ? SourceFile.this.key.packageName.replace('.', '/') + '/' : "";
                        this.filename = SourceFile.this.key.relativeName + ".java";
                    }

                    @Override
                    public Reader openStream() throws IOException {
                        return $Output.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", this.packagePath + this.filename).openReader(true);
                    }
                }.read();
                if (existingContent.contentEquals(sourceCode)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        private CharSequence extractSourceCode() {
            return $PostprocessingMachine.rewrite(this.consumer.asCharSequence());
        }
    }

    private static class AppendServiceFile {
        private static final Pattern SERVICE_FILE_COMMENT_LINE = Pattern.compile("^\\#.*");
        final ResourceKey key;
        final .generator..Templates.CharConsumer consumer = new .generator..Templates.CharConsumer();

        AppendServiceFile(ResourceKey key) {
            this.key = key;
        }

        void complete() {
            try {
                this.writeFile();
            }
            catch (FilerException ex) {
                throw $Throwables.propagate(ex);
            }
            catch (IOException ex) {
                throw $Throwables.propagate(ex);
            }
        }

        private void writeFile() throws IOException {
            LinkedHashSet<String> services = $Sets.newLinkedHashSet();
            this.readExistingEntriesInto(services);
            this.copyNewMetaservicesInto(services);
            this.removeBlankLinesIn(services);
            this.writeLinesFrom(services);
        }

        private void readExistingEntriesInto(Collection<String> services) {
            try {
                FileObject existing = $Output.getFiler().getResource(StandardLocation.CLASS_OUTPUT, this.key.packageName, this.key.relativeName);
                $FluentIterable.from($CharStreams.readLines(existing.openReader(true))).filter($Predicates.not($Predicates.contains(SERVICE_FILE_COMMENT_LINE))).copyInto(services);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void writeLinesFrom(Iterable<String> services) throws IOException {
            new $CharSink(){

                @Override
                public Writer openStream() throws IOException {
                    return $Output.getFiler().createResource(StandardLocation.CLASS_OUTPUT, AppendServiceFile.this.key.packageName, AppendServiceFile.this.key.relativeName, new Element[0]).openWriter();
                }
            }.writeLines(services, "\n");
        }

        private void removeBlankLinesIn(Iterable<String> services) {
            $Iterables.removeIf(services, $Predicates.equalTo(""));
        }

        private void copyNewMetaservicesInto(Collection<String> services) {
            $FluentIterable.from($Splitter.on("\n").split(this.consumer.asCharSequence())).copyInto(services);
        }
    }

    private static final class ResourceKey {
        private static $Joiner PACKAGE_RESOURCE_JOINER = $Joiner.on('.').skipNulls();
        final String packageName;
        final String relativeName;

        ResourceKey(String packageName, String simpleName) {
            this.packageName = $Preconditions.checkNotNull(packageName);
            this.relativeName = $Preconditions.checkNotNull(simpleName);
        }

        public String toString() {
            return PACKAGE_RESOURCE_JOINER.join($Strings.emptyToNull(this.packageName), this.relativeName, new Object[0]);
        }

        public int hashCode() {
            return Objects.hash(this.packageName, this.relativeName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceKey) {
                ResourceKey other = (ResourceKey)obj;
                return this.packageName.equals(other.packageName) || this.relativeName.equals(other.relativeName);
            }
            return false;
        }
    }

    private static abstract class OutputFilter
    extends .generator..Templates.Fragment {
        public OutputFilter() {
            super(1);
        }

        abstract void apply(.generator..Templates.Invokation var1, CharSequence var2, @Nullable .generator..Templates.Invokable var3);

        @Override
        public final void run(.generator..Templates.Invokation invokation) {
            Object param = invokation.param(0);
            .generator..Templates.Invokable original = param instanceof .generator..Templates.Invokable ? (.generator..Templates.Invokable)param : null;
            this.apply(invokation, this.toCharSequence(param), original);
        }

        private CharSequence toCharSequence(Object param) {
            $Preconditions.checkNotNull(param);
            if (param instanceof .generator..Templates.Fragment) {
                return ((.generator..Templates.Fragment)param).toCharSequence();
            }
            return param.toString();
        }
    }
}

