/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$processor$.meta.$BuilderMirrors;

public class $SwitchMirror
implements $BuilderMirrors.Switch {
    public static final String QUALIFIED_NAME = "org.immutables.builder.Builder.Switch";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.meta.BuilderMirrors.$Switch";
    private final AnnotationMirror annotationMirror;
    private final String defaultName;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Switch";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$SwitchMirror> find(Element element) {
        return $SwitchMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$SwitchMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $SwitchMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$SwitchMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $SwitchMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $SwitchMirror from(TypeElement element) {
        return new $SwitchMirror(element);
    }

    public static $Optional<$SwitchMirror> from(AnnotationMirror mirror) {
        return $SwitchMirror.find(Collections.singleton(mirror));
    }

    private $SwitchMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        String defaultName = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"defaultName".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Switch");
            }
            DefaultNameExtractor defaultNameExtractor$ = new DefaultNameExtractor();
            annotationValue$.accept(defaultNameExtractor$, null);
            defaultName = defaultNameExtractor$.get();
        }
        this.defaultName = $Preconditions.checkNotNull(defaultName);
    }

    private $SwitchMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String defaultName = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"defaultName".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'defaultName' attribute of @Switch");
            }
            DefaultNameExtractor defaultNameExtractor$ = new DefaultNameExtractor();
            annotationValue$.accept(defaultNameExtractor$, null);
            defaultName = defaultNameExtractor$.get();
        }
        this.defaultName = $Preconditions.checkNotNull(defaultName);
    }

    @Override
    public String defaultName() {
        return this.defaultName;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return $BuilderMirrors.Switch.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h += 127 * "defaultName".hashCode() ^ this.defaultName.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $SwitchMirror) {
            $SwitchMirror otherMirror = ($SwitchMirror)other;
            return this.defaultName.equals(otherMirror.defaultName);
        }
        return false;
    }

    @Override
    public String toString() {
        return "SwitchMirror:" + this.annotationMirror;
    }

    private static class DefaultNameExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private DefaultNameExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'defaultName' in @org.immutables.builder.Builder.Switch");
        }
    }
}

