/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.immutables.value.internal.$generator$.$AnnotationMirrors;
import org.immutables.value.internal.$generator$.$SourceExtraction;
import org.immutables.value.internal.$generator$.$SourceTypes;
import org.immutables.value.internal.$guava$.base.$Ascii;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.collect.$Maps;
import org.immutables.value.internal.$processor$.meta.$Proto;
import org.immutables.value.internal.$processor$.meta.$Reporter;

class $TypeStringProvider {
    private final TypeMirror startType;
    private final Element element;
    private final List<String> typeParameterStrings = $Lists.newArrayListWithCapacity(2);
    private StringBuilder buffer;
    boolean unresolvedTypeHasOccured;
    boolean hasMaybeUnresolvedYetAfter;
    private $ImmutableMap<String, String> sourceClassesImports;
    private String rawTypeName;
    private String returnTypeName;
    private boolean ended;
    @Nullable
    private List<String> workaroundTypeParameters;
    @Nullable
    private String workaroundTypeString;
    private final $Reporter reporter;
    private final $Proto.DeclaringType declaringType;

    $TypeStringProvider($Reporter reporter, Element element, TypeMirror returnType, $Proto.DeclaringType declaringType) {
        this.reporter = reporter;
        this.declaringType = declaringType;
        this.startType = returnType;
        this.element = element;
    }

    String rawTypeName() {
        return this.rawTypeName;
    }

    String returnTypeName() {
        return this.returnTypeName;
    }

    boolean hasSomeUnresovedTypes() {
        return this.hasMaybeUnresolvedYetAfter;
    }

    $ImmutableList<String> typeParameters() {
        return $ImmutableList.copyOf(this.workaroundTypeParameters != null ? this.workaroundTypeParameters : this.typeParameterStrings);
    }

    void process() {
        if (this.startType.getKind().isPrimitive()) {
            String typeName;
            this.rawTypeName = typeName = $Ascii.toLowerCase(this.startType.getKind().name());
            this.returnTypeName = typeName;
            List<? extends AnnotationMirror> annotations = $AnnotationMirrors.from(this.startType);
            if (!annotations.isEmpty()) {
                this.returnTypeName = this.typeAnnotationsToBuffer(annotations).append(typeName).toString();
            }
        } else {
            TypeKind k;
            this.buffer = new StringBuilder(100);
            this.caseType(this.startType);
            if (this.workaroundTypeString != null) {
                this.buffer = new StringBuilder(this.workaroundTypeString);
            }
            if ((k = this.startType.getKind()) == TypeKind.DECLARED || k == TypeKind.ERROR) {
                this.insertTypeAnnotationsIfPresent(this.startType, 0, this.rawTypeName.length());
            }
            this.returnTypeName = this.buffer.toString();
        }
    }

    private void appendResolved(DeclaredType type) {
        boolean assumedNotQualified;
        TypeElement typeElement = (TypeElement)type.asElement();
        String typeName = typeElement.getQualifiedName().toString();
        if (this.unresolvedTypeHasOccured && (assumedNotQualified = $Ascii.isUpperCase(typeName.charAt(0)))) {
            typeName = this.resolveIfPossible(typeName);
        }
        this.buffer.append(typeName);
        if (this.startType == type) {
            this.rawTypeName = typeName;
        }
    }

    private String resolveIfPossible(String typeName) {
        String resolved;
        String resolvable = typeName;
        int indexOfDot = resolvable.indexOf(46);
        if (indexOfDot > 0) {
            resolvable = resolvable.substring(0, indexOfDot);
        }
        if ((resolved = this.getFromSourceImports(resolvable)) != null) {
            typeName = indexOfDot > 0 ? resolved + '.' + resolvable.substring(indexOfDot + 1) : resolved;
        } else {
            this.hasMaybeUnresolvedYetAfter = true;
        }
        return typeName;
    }

    @Nullable
    private String getFromSourceImports(String resolvable) {
        if (this.sourceClassesImports == null) {
            this.sourceClassesImports = this.declaringType.associatedTopLevel().sourceImports().classes;
        }
        return this.sourceClassesImports.get(resolvable);
    }

    private void insertTypeAnnotationsIfPresent(TypeMirror type, int typeStart, int typeEnd) {
        List<? extends AnnotationMirror> annotations = $AnnotationMirrors.from(type);
        if (!annotations.isEmpty()) {
            StringBuilder annotationBuffer = this.typeAnnotationsToBuffer(annotations);
            int insertionIndex = typeStart + this.buffer.substring(typeStart, typeEnd).lastIndexOf(".") + 1;
            this.buffer.insert(insertionIndex, annotationBuffer);
        }
    }

    private StringBuilder typeAnnotationsToBuffer(List<? extends AnnotationMirror> annotations) {
        StringBuilder annotationBuffer = new StringBuilder(100);
        for (AnnotationMirror annotationMirror : annotations) {
            annotationBuffer.append($AnnotationMirrors.toCharSequence(annotationMirror)).append(' ');
        }
        return annotationBuffer;
    }

    private boolean tryToUseSourceAsAWorkaround() {
        if (this.element.getKind() != ElementKind.METHOD) {
            return false;
        }
        CharSequence returnTypeString = $SourceExtraction.getReturnTypeString((ExecutableElement)this.element);
        if (returnTypeString.length() == 0) {
            return false;
        }
        Map.Entry<String, List<String>> extractedTypes = $SourceTypes.extract(returnTypeString);
        Map.Entry<String, List<String>> resolvedTypes = this.resolveTypes(extractedTypes);
        this.rawTypeName = resolvedTypes.getKey();
        this.workaroundTypeParameters = resolvedTypes.getValue();
        this.workaroundTypeString = $SourceTypes.stringify(resolvedTypes);
        return true;
    }

    private Map.Entry<String, List<String>> resolveTypes(Map.Entry<String, List<String>> sourceTypes) {
        String typeName = sourceTypes.getKey();
        boolean assumedNotQualified = $Ascii.isUpperCase(typeName.charAt(0));
        if (assumedNotQualified) {
            typeName = this.resolveIfPossible(typeName);
        }
        ArrayList<String> typeArguments = $Lists.newArrayListWithCapacity(sourceTypes.getValue().size());
        for (String typeArgument : sourceTypes.getValue()) {
            String resolvedTypeArgument = $SourceTypes.stringify(this.resolveTypes($SourceTypes.extract(typeArgument)));
            typeArguments.add(resolvedTypeArgument);
        }
        return $Maps.immutableEntry(typeName, typeArguments);
    }

    void caseType(TypeMirror type) {
        if (this.ended) {
            return;
        }
        switch (type.getKind()) {
            case ERROR: {
                this.unresolvedTypeHasOccured = true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                this.appendResolved(declaredType);
                this.appendTypeArguments(type, declaredType);
                break;
            }
            case ARRAY: {
                TypeMirror componentType = ((ArrayType)type).getComponentType();
                int mark = this.buffer.length();
                this.caseType(componentType);
                this.cutTypeArgument(type, mark);
                this.buffer.append('[').append(']');
                break;
            }
            case WILDCARD: {
                WildcardType wildcard = (WildcardType)type;
                TypeMirror extendsBound = wildcard.getExtendsBound();
                TypeMirror superBound = wildcard.getSuperBound();
                if (extendsBound != null) {
                    this.buffer.append("? extends ");
                    this.caseType(extendsBound);
                    break;
                }
                if (superBound != null) {
                    this.buffer.append("? super ");
                    this.caseType(superBound);
                    break;
                }
                this.buffer.append('?');
                break;
            }
            case TYPEVAR: {
                if (this.tryToUseSourceAsAWorkaround()) {
                    this.ended = true;
                    break;
                }
                this.reporter.error("It is a compiler/annotation processing bug to receive type variables '%s' here. To avoid it \u2014 do not use not yet generated types in %s attribute", type, this.element.getSimpleName());
                this.buffer.append(type);
                break;
            }
            default: {
                this.buffer.append(type);
            }
        }
    }

    private void appendTypeArguments(TypeMirror type, DeclaredType declaredType) {
        List<? extends TypeMirror> arguments = declaredType.getTypeArguments();
        if (!arguments.isEmpty()) {
            this.buffer.append('<');
            boolean notFirst = false;
            for (TypeMirror typeMirror : arguments) {
                if (notFirst) {
                    this.buffer.append(',').append(' ');
                }
                notFirst = true;
                int mark = this.buffer.length();
                this.caseType(typeMirror);
                this.cutTypeArgument(type, mark);
            }
            this.buffer.append('>');
        }
    }

    private void cutTypeArgument(TypeMirror type, int mark) {
        if (this.startType == type) {
            this.typeParameterStrings.add(this.buffer.substring(mark));
        }
    }
}

