/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.impl;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.entries.RemoteMetadata;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.transport.Address;

public class AnchoredReadCommittedEntry<K, V>
extends ReadCommittedEntry<K, V> {
    private Address location;

    public AnchoredReadCommittedEntry(K key, V value, Metadata metadata) {
        super(key, value, metadata);
    }

    public Address getLocation() {
        return this.location;
    }

    public void setLocation(Address location) {
        this.location = location;
    }

    public static void setMissingLocation(CacheEntry<?, ?> cacheEntry, Address location) {
        AnchoredReadCommittedEntry anchoredEntry;
        if (cacheEntry instanceof AnchoredReadCommittedEntry && (anchoredEntry = (AnchoredReadCommittedEntry)cacheEntry).getLocation() == null) {
            anchoredEntry.setLocation(location);
        }
    }

    public void commit(DataContainer<K, V> container) {
        if (this.isChanged() && !this.isRemoved()) {
            Object newValue = this.location != null ? null : this.value;
            RemoteMetadata newMetadata = this.location != null ? new RemoteMetadata(this.location, null) : this.metadata;
            container.put(this.key, newValue, (Metadata)newMetadata);
        } else {
            super.commit(container);
        }
    }

    public CompletionStage<Void> commit(int segment, InternalDataContainer<K, V> container) {
        if (this.isChanged() && !this.isRemoved()) {
            Object newValue = this.location != null ? null : this.value;
            RemoteMetadata newMetadata = this.location != null ? new RemoteMetadata(this.location, null) : this.metadata;
            container.put(segment, this.key, newValue, (Metadata)newMetadata, this.internalMetadata, this.created, this.lastUsed);
            return CompletableFutures.completedNull();
        }
        return super.commit(segment, container);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + Util.hexIdHashCode((Object)((Object)this)) + "){key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", isCreated=" + this.isCreated() + ", isChanged=" + this.isChanged() + ", isRemoved=" + this.isRemoved() + ", isExpired=" + this.isExpired() + ", skipLookup=" + this.skipLookup() + ", metadata=" + String.valueOf(this.metadata) + ", internalMetadata=" + String.valueOf(this.internalMetadata) + ", location=" + String.valueOf(this.location) + "}";
    }
}

