/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa.impl;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Version;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.jpa.impl.MetadataEntityKey;
import org.infinispan.persistence.spi.MarshallableEntry;

@Entity
@Table(name="`__ispn_metadata__`")
public class MetadataEntity {
    public static final String EXPIRATION = "expiration";
    private static final String CREATED = "created";
    private static final String LAST_USED = "lastused";
    @EmbeddedId
    private MetadataEntityKey key;
    @Lob
    @Column(length=65535)
    private byte[] keyBytes;
    @Lob
    @Column(length=65535)
    private byte[] metadata;
    @Column(name="expiration")
    private long expiration;
    @Column(name="created")
    private long created;
    @Column(name="lastused")
    private long lastUsed;
    @Version
    private int version;
    @Lob
    @Column(length=65535)
    private byte[] internalMetadata;

    public MetadataEntity() {
    }

    public MetadataEntity(MarshallableEntry me) {
        this.keyBytes = MarshallUtil.toByteArray((ByteBuffer)me.getKeyBytes());
        this.key = new MetadataEntityKey(this.keyBytes);
        Metadata meta = me.getMetadata();
        if (meta != null) {
            this.metadata = MarshallUtil.toByteArray((ByteBuffer)me.getMetadataBytes());
        }
        this.expiration = meta == null || me.expiryTime() < 0L ? Long.MAX_VALUE : me.expiryTime();
        this.created = me.created();
        this.lastUsed = me.lastUsed();
        if (me.getInternalMetadata() != null) {
            this.internalMetadata = MarshallUtil.toByteArray((ByteBuffer)me.getInternalMetadataBytes());
        }
    }

    public MetadataEntityKey getKey() {
        return this.key;
    }

    public void setKey(MetadataEntityKey key) {
        this.key = key;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public void setKeyBytes(byte[] keyBytes) {
        this.keyBytes = keyBytes;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public void setMetadata(byte[] metadata) {
        this.metadata = metadata;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte[] getInternalMetadata() {
        return this.internalMetadata;
    }

    public boolean hasBytes() {
        return this.metadata != null || this.internalMetadata != null;
    }
}

