/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql;

import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.util.IntSet;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.SqlManager;
import org.infinispan.persistence.jdbc.common.TableOperations;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.sql.AbstractSchemaJdbcStore;
import org.infinispan.persistence.sql.configuration.TableJdbcStoreConfiguration;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=TableJdbcStoreConfiguration.class)
public class TableJdbcStore<K, V>
extends AbstractSchemaJdbcStore<K, V, TableJdbcStoreConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);

    @Override
    protected TableOperations<K, V> actualCreateTableOperations(AbstractSchemaJdbcStore.ProtoSchemaOptions<K, V, TableJdbcStoreConfiguration> schemaOptions) {
        return new TableTableOperations(schemaOptions, schemaOptions.valueParameters);
    }

    @Override
    AbstractSchemaJdbcStore.Parameter[] generateParameterInformation(TableJdbcStoreConfiguration config, ConnectionFactory connectionFactory) throws SQLException {
        String tableName;
        String schemaName;
        String schemaAndTableName = config.tableName();
        String[] tableAndSchemaSplit = schemaAndTableName.split("\\.");
        if (tableAndSchemaSplit.length == 1) {
            schemaName = null;
            tableName = schemaAndTableName;
        } else if (tableAndSchemaSplit.length == 2) {
            schemaName = tableAndSchemaSplit[0];
            tableName = tableAndSchemaSplit[1];
        } else {
            throw log.tableNotInCorrectFormat(schemaAndTableName);
        }
        Connection connection = connectionFactory.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        try (ResultSet rs = databaseMetaData.getPrimaryKeys(null, schemaName, tableName);){
            while (rs.next()) {
                primaryKeyList.add(rs.getString("COLUMN_NAME").toUpperCase());
            }
        }
        if (primaryKeyList.isEmpty()) {
            throw log.noPrimaryKeysFoundForTable(schemaAndTableName);
        }
        boolean containsNonPrimary = false;
        ArrayList<AbstractSchemaJdbcStore.Parameter> parameters = new ArrayList<AbstractSchemaJdbcStore.Parameter>();
        try (ResultSet rs = databaseMetaData.getColumns(null, schemaName, tableName, null);){
            while (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                int sqlColumnType = rs.getInt("DATA_TYPE");
                int actualType = this.typeWeUse(sqlColumnType, rs.getString("TYPE_NAME"));
                AbstractSchemaJdbcStore.ProtostreamFieldType schemaType = AbstractSchemaJdbcStore.ProtostreamFieldType.from(actualType);
                boolean isPrimary = primaryKeyList.contains(name.toUpperCase());
                parameters.add(new AbstractSchemaJdbcStore.Parameter(name, schemaType, isPrimary, sqlColumnType));
                containsNonPrimary |= !isPrimary;
            }
        }
        if (!containsNonPrimary) {
            throw log.noValueColumnForTable(schemaAndTableName);
        }
        return parameters.toArray(new AbstractSchemaJdbcStore.Parameter[0]);
    }

    @Override
    AbstractSchemaJdbcStore.Parameter[] handleUnusedValueParams(AbstractSchemaJdbcStore.Parameter[] parameters, List<AbstractSchemaJdbcStore.Parameter> unusedValueParams) {
        if (!((TableJdbcStoreConfiguration)this.config).ignoreModifications()) {
            throw this.unusedValueParamsException(unusedValueParams);
        }
        Log.CONFIG.debugf("TableJdbcStore has extra columns that are not part of the schema %s, ignoring since read only", unusedValueParams);
        AbstractSchemaJdbcStore.Parameter[] newParams = new AbstractSchemaJdbcStore.Parameter[parameters.length - unusedValueParams.size()];
        int i = 0;
        for (AbstractSchemaJdbcStore.Parameter parameter : parameters) {
            if (unusedValueParams.contains(parameter)) continue;
            newParams[i++] = parameter;
        }
        return newParams;
    }

    public class TableTableOperations
    extends AbstractSchemaJdbcStore.SchemaTableOperations<K, V, TableJdbcStoreConfiguration> {
        private final String selectSql;
        private final String selectAllSql;
        private final String deleteSql;
        private final String deleteAllSql;
        private final String upsertSql;
        private final String sizeSql;

        public TableTableOperations(AbstractSchemaJdbcStore.ProtoSchemaOptions<K, V, TableJdbcStoreConfiguration> options, AbstractSchemaJdbcStore.Parameter[] upsertParameters) {
            super(options, upsertParameters);
            DatabaseType type = ((TableJdbcStoreConfiguration)((Object)options.config)).dialect();
            if (type == null) {
                Connection connection = null;
                try {
                    connection = TableJdbcStore.this.connectionFactory.getConnection();
                    String dbProduct = connection.getMetaData().getDatabaseProductName();
                    type = DatabaseType.guessDialect((String)dbProduct);
                    log.debugf("Guessing database dialect as '%s'.  If this is incorrect, please specify the correct dialect using the 'dialect' attribute in your configuration.  Supported database dialect strings are %s", (Object)type, (Object)Arrays.toString(DatabaseType.values()));
                }
                catch (Exception e) {
                    throw log.unableToDetectDialect(Arrays.toString(DatabaseType.values()));
                }
                finally {
                    TableJdbcStore.this.connectionFactory.releaseConnection(connection);
                }
            }
            SqlManager statements = SqlManager.fromDatabaseType((DatabaseType)type, (String)((TableJdbcStoreConfiguration)TableJdbcStore.this.config).tableName());
            List keyNames = Arrays.stream(options.keyParameters).map(AbstractSchemaJdbcStore.Parameter::getName).collect(Collectors.toList());
            List allNames = Arrays.stream(options.valueParameters).map(AbstractSchemaJdbcStore.Parameter::getName).collect(Collectors.toList());
            this.selectSql = statements.getSelectStatement(keyNames, allNames);
            this.selectAllSql = statements.getSelectAllStatement(allNames);
            this.deleteSql = statements.getDeleteStatement(keyNames);
            this.deleteAllSql = statements.getDeleteAllStatement();
            this.upsertSql = statements.getUpsertStatement(keyNames, allNames);
            this.sizeSql = statements.getSizeCommand();
        }

        public String getSelectRowSql() {
            return this.selectSql;
        }

        public String getDeleteRowSql() {
            return this.deleteSql;
        }

        public String getUpsertRowSql() {
            return this.upsertSql;
        }

        public String getSelectAllSql(IntSet segments) {
            return this.selectAllSql;
        }

        public String getDeleteAllSql() {
            return this.deleteAllSql;
        }

        public String getSizeSql() {
            return this.sizeSql;
        }
    }
}

