/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.printers;

import java.io.IOException;
import java.util.Map;
import org.aesh.command.shell.Shell;
import org.infinispan.cli.printers.AbstractPrettyPrinter;
import org.infinispan.cli.printers.PrettyRowPrinter;

public class CsvPrettyPrinter
extends AbstractPrettyPrinter {
    private final PrettyRowPrinter rowPrinter;
    private boolean header = true;

    protected CsvPrettyPrinter(Shell shell, PrettyRowPrinter rowPrinter) {
        super(shell);
        this.rowPrinter = rowPrinter;
    }

    @Override
    public void printItem(Map<String, String> item) {
        boolean comma;
        if (this.header) {
            this.shell.write("# ");
            comma = false;
            for (int i = 0; i < item.size(); ++i) {
                if (comma) {
                    this.shell.write(",");
                } else {
                    comma = true;
                }
                this.shell.write(this.rowPrinter.columnHeader(i));
            }
            this.shell.writeln("");
            this.header = false;
        }
        comma = false;
        for (Map.Entry<String, String> column : item.entrySet()) {
            if (comma) {
                this.shell.write(",");
            } else {
                comma = true;
            }
            this.shell.write('\"');
            this.shell.write(column.getValue().replace("\"", "\\\""));
            this.shell.write('\"');
        }
        this.shell.writeln("");
    }

    @Override
    public void close() throws IOException {
    }
}

