/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.logging;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import org.aesh.command.CommandException;
import org.aesh.command.parser.RequiredOptionException;
import org.infinispan.cli.patching.PatchInfo;
import org.infinispan.cli.patching.PatchOperation;
import org.infinispan.cli.user.UserTool;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="ISPN")
public interface Messages {
    public static final Messages MSG = (Messages)org.jboss.logging.Messages.getBundle(Messages.class);
    public static final Logger CLI = Logger.getLogger((String)"CLI");

    @Message(value="Username: ")
    public String username();

    @Message(value="Password: ")
    public String password();

    @Message(value="Not Found: %s")
    public IOException notFound(String var1);

    @Message(value="The supplied credentials are invalid %s")
    public AccessDeniedException unauthorized(String var1);

    @Message(value="Error: %s")
    public IOException error(String var1);

    @Message(value="The user is not allowed to access the server resource: %s")
    public AccessDeniedException forbidden(String var1);

    @Message(value="Error while loading trust store '%s'")
    public String keyStoreError(String var1, @Cause Exception var2);

    @Message(value="No such resource '%s'")
    public IllegalArgumentException noSuchResource(String var1);

    @Message(value="Command invoked from the wrong context")
    public IllegalStateException illegalContext();

    @Message(value="Illegal arguments for command")
    public IllegalArgumentException illegalCommandArguments();

    @Message(value="The options '%s' and '%s' are mutually exclusive")
    public IllegalArgumentException mutuallyExclusiveOptions(String var1, String var2);

    @Message(value="One of the '%s' and '%s' options are required")
    public RequiredOptionException requiresOneOf(String var1, String var2);

    @Message(value="Could not connect to server: %s")
    public ConnectException connectionFailed(String var1);

    @Message(value="Invalid resource '%s'")
    public IllegalArgumentException invalidResource(String var1);

    @Message(value="No patches installed")
    public String patchNoPatchesInstalled();

    @Message(value="%s")
    public String patchInfo(PatchInfo var1);

    @Message(value="The supplied patch cannot be applied to %s %s")
    public IllegalStateException patchCannotApply(String var1, String var2);

    @Message(value="File %s SHA mismatch. Expected = %s, Actual = %s")
    public String patchShaMismatch(Path var1, String var2, String var3);

    @Message(value="The following errors were encountered while validating the installation:%n%s")
    public IllegalStateException patchValidationErrors(String var1);

    @Message(value="No installed patches to roll back")
    public IllegalStateException patchNoPatchesInstalledToRollback();

    @Message(value="Cannot find the infinispan-commons jar under %s")
    public IllegalStateException patchCannotFindCommons(Path var1);

    @Message(value="Cannot create patch %s with patches for %s")
    public IllegalStateException patchIncompatibleProduct(String var1, String var2);

    @Message(value="Could not write patches file")
    public IllegalStateException patchCannotWritePatchesFile(@Cause IOException var1);

    @Message(value="Rolled back patch %s")
    public String patchRollback(PatchInfo var1);

    @Message(value="[Dry run] ")
    public String patchDryRun();

    @Message(value="Backing up '%s' to '%s'")
    public String patchBackup(Path var1, Path var2);

    @Message(value="Error while creating patch")
    public RuntimeException patchCreateError(@Cause IOException var1);

    @Message(value="Adding file '%s'")
    public String patchCreateAdd(Path var1);

    @Message(value="Rolling back file '%s'")
    public String patchRollbackFile(Path var1);

    @Message(value="Could not read %s")
    public IllegalStateException patchCannotRead(Path var1, @Cause IOException var2);

    @Message(value="File '%s' already exists")
    public FileAlreadyExistsException patchFileAlreadyExists(Path var1);

    @Message(value="At least three arguments are required: the patch file, the target server path and one or more source server paths")
    public IllegalArgumentException patchCreateArgumentsRequired();

    @Message(value="You must specify the path to a patch archive")
    public IllegalArgumentException patchArchiveArgumentRequired();

    @Message(value="Cannot create a patch from identical source and target server versions: %s")
    public IllegalArgumentException patchServerAndTargetMustBeDifferent(String var1);

    @Message(value="The patch archive appears to have a corrupt entry for: %s")
    public String patchCorruptArchive(PatchOperation var1);

    @Message(value="Downloaded file '%s'")
    public String downloadedFile(String var1);

    @Message(value="Specify a username: ")
    public String userToolUsername();

    @Message(value="Set a password for the user: ")
    public String userToolPassword();

    @Message(value="Confirm the password for the user: ")
    public String userToolPasswordConfirm();

    @Message(value="User `%s` already exists")
    public IllegalStateException userToolUserExists(String var1);

    @Message(value="Error accessing file '%s'")
    public RuntimeException userToolIOError(Path var1, @Cause IOException var2);

    @Message(value="Unkown password encryption algorithm: '%s'")
    public IllegalArgumentException userToolUnknownAlgorithm(String var1);

    @Message(value="User `%s` does not exist")
    public IllegalArgumentException userToolNoSuchUser(String var1);

    @Message(value="{ username: \"%s\", realm: \"%s\", groups = %s }")
    public String userDescribe(String var1, String var2, String[] var3);

    @Message(value="Invalid Unicode sequence '%s'")
    public IOException invalidUnicodeSequence(String var1, @Cause NoSuchElementException var2);

    @Message(value="Attempt to use %s passwords, but only %s passwords are allowed")
    public IllegalArgumentException userToolIncompatibleEncrypyion(UserTool.Encryption var1, UserTool.Encryption var2);

    @Message(value="Attempted to use a different realm '%s' than the already existing one '%s'")
    public IllegalArgumentException userToolWrongRealm(String var1, String var2);

    @Message(value="Unable to load CLI configuration from `%s`. Using defaults.")
    public String configLoadFailed(String var1);

    @Message(value="Unable to store CLI configuration to '%s'.")
    public String configStoreFailed(String var1);

    @Message(value="Wrong argument count: %d.")
    public IllegalArgumentException wrongArgumentCount(int var1);

    @Message(value="Cannot find service '%s' in namespace '%s'")
    public IllegalArgumentException noSuchService(String var1, String var2);

    @Message(value="Cannot find or access generated secrets for service '%s'")
    public IllegalStateException noGeneratedSecret(String var1);

    @Message(value="A namespace was not specified and a default has not been set")
    public IllegalStateException noDefaultNamespace();

    @Message(value="Enter the password for the credential keystore: ")
    public String credentialToolPassword();

    @Message(value="Confirm the password for the credential store: ")
    public String credentialToolPasswordConfirm();

    @Message(value="Set a credential for the alias: ")
    public String credentialToolCredential();

    @Message(value="Confirm the credential: ")
    public String credentialToolCredentialConfirm();

    @Message(value="Filter rule '%s' is not in the format [ACCEPT|REJECT]/{CIDR}")
    public IllegalArgumentException illegalFilterRule(String var1);

    @Message(value="Error executing line %d: '%s'")
    public CommandException batchError(int var1, String var2, @Cause Throwable var3);

    @Message(value="Option '%s' requires option '%s'")
    public RequiredOptionException requiresAllOf(String var1, String var2);

    @Message(value="The cache name is required")
    public IllegalArgumentException missingCacheName();

    @Message(value="Could not determine catalog source")
    public IllegalStateException noCatalog();

    @Message(value="Target namespaces must be specified when not installing globally")
    public IllegalArgumentException noTargetNamespaces();

    @Message(value="Could not find a default operator namespace")
    public IllegalStateException noDefaultOperatorNamespace();

    @Message(value="Kubernetes client is unavailable in this mode")
    public IllegalStateException noKubernetes();

    @Message(value="Could not find an operator subscription in namespace '%s'")
    public IllegalStateException noOperatorSubscription(String var1);

    @Message(value="Expose type '%s' requires a port")
    public IllegalArgumentException exposeTypeRequiresPort(String var1);

    @Message(value="Encryption type '%s' requires a secret name")
    public IllegalArgumentException encryptionTypeRequiresSecret(String var1);

    @Message(value="No running pods available in service %s")
    public IllegalStateException noRunningPodsInService(String var1);

    @Message(value="A username must be specified")
    public IllegalArgumentException usernameRequired();

    @Message(value="Checksum for '%s' does not match. Supplied: %s Actual: %s")
    public SecurityException checksumFailed(String var1, String var2, String var3);

    @Message(value="Checksum for '%s' verified")
    public String checksumVerified(String var1);

    @Message(value="Artifact '%s' not found")
    public IllegalArgumentException artifactNotFound(String var1);

    @Message(value="Retry download '%d/%d'")
    public String retryDownload(int var1, int var2);
}

