/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.resources;

import java.io.IOException;
import java.util.Optional;
import org.infinispan.cli.resources.AbstractResource;
import org.infinispan.cli.resources.CacheKeyResource;
import org.infinispan.cli.resources.CachesResource;
import org.infinispan.cli.resources.Resource;

public class CacheResource
extends AbstractResource {
    public CacheResource(CachesResource parent, String name) {
        super(parent, name);
    }

    @Override
    public Iterable<String> getChildrenNames() throws IOException {
        return this.getConnection().getCacheKeys(this.getParent().getParent().getName(), this.name);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Resource getChild(String name) {
        if ("..".equals(name)) {
            return this.parent;
        }
        return new CacheKeyResource(this, name);
    }

    @Override
    public String describe() throws IOException {
        return this.getConnection().describeCache(this.getParent().getParent().getName(), this.name);
    }

    public static String cacheName(Resource resource) {
        return resource.findAncestor(CacheResource.class).getName();
    }

    public static Optional<String> findCacheName(Resource resource) {
        return resource.optionalFindAncestor(CacheResource.class).map(AbstractResource::getName);
    }
}

