/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.client.rest.impl.okhttp.ByteArrayRestEntityOkHttp;
import org.infinispan.client.rest.impl.okhttp.FileRestEntityOkHttp;
import org.infinispan.client.rest.impl.okhttp.InputStreamEntityOkHttp;
import org.infinispan.client.rest.impl.okhttp.StringRestEntityOkHttp;
import org.infinispan.commons.dataconversion.MediaType;

public interface RestEntity {
    public String getBody();

    public MediaType contentType();

    public static RestEntity create(MediaType contentType, String body) {
        return new StringRestEntityOkHttp(contentType, body);
    }

    public static RestEntity create(MediaType contentType, byte[] body) {
        return new ByteArrayRestEntityOkHttp(contentType, body);
    }

    public static RestEntity create(MediaType contentType, File file) {
        return new FileRestEntityOkHttp(contentType, file);
    }

    public static RestEntity create(MediaType contentType, InputStream inputStream) {
        return new InputStreamEntityOkHttp(contentType, inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RestEntity create(File file) {
        if (file.getName().endsWith(".yaml")) return RestEntity.create(MediaType.APPLICATION_YAML, file);
        if (file.getName().endsWith(".yml")) {
            return RestEntity.create(MediaType.APPLICATION_YAML, file);
        }
        try (FileInputStream is = new FileInputStream(file);){
            int b;
            do {
                if ((b = ((InputStream)is).read()) <= -1) return RestEntity.create(MediaType.APPLICATION_OCTET_STREAM, file);
                if (b != 123) continue;
                RestEntity restEntity = RestEntity.create(MediaType.APPLICATION_JSON, file);
                return restEntity;
            } while (b != 60);
            RestEntity restEntity = RestEntity.create(MediaType.APPLICATION_XML, file);
            return restEntity;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

