/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp.auth;

import java.io.IOException;
import java.util.Map;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.infinispan.client.rest.impl.okhttp.auth.CachingAuthenticator;

public class CachingAuthenticatorInterceptor
implements Interceptor {
    private final Map<String, CachingAuthenticator> authCache;

    public CachingAuthenticatorInterceptor(Map<String, CachingAuthenticator> authCache) {
        this.authCache = authCache;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        int responseCode;
        Route route;
        Request request = chain.request();
        String key = CachingAuthenticator.getCachingKey(request);
        CachingAuthenticator authenticator = this.authCache.get(key);
        Request authRequest = null;
        Connection connection = chain.connection();
        Route route2 = route = connection != null ? connection.route() : null;
        if (authenticator != null) {
            authRequest = authenticator.authenticateWithState(route, request);
        }
        if (authRequest == null) {
            authRequest = request;
        }
        int n = responseCode = (response = chain.proceed(authRequest)) != null ? response.code() : 0;
        if (authenticator != null && responseCode == 401 && this.authCache.remove(key) != null) {
            response.body().close();
            response = chain.proceed(request);
        }
        return response;
    }
}

