/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestClusterClient;
import org.infinispan.client.rest.RestContainerClient;
import org.infinispan.client.rest.RestCounterClient;
import org.infinispan.client.rest.RestMetricsClient;
import org.infinispan.client.rest.RestRawClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestSchemaClient;
import org.infinispan.client.rest.RestSecurityClient;
import org.infinispan.client.rest.RestServerClient;
import org.infinispan.client.rest.RestTaskClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.impl.jdk.RestCacheClientJDK;
import org.infinispan.client.rest.impl.jdk.RestClusterClientJDK;
import org.infinispan.client.rest.impl.jdk.RestContainerClientJDK;
import org.infinispan.client.rest.impl.jdk.RestCounterClientJDK;
import org.infinispan.client.rest.impl.jdk.RestMetricsClientJDK;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;
import org.infinispan.client.rest.impl.jdk.RestSchemaClientJDK;
import org.infinispan.client.rest.impl.jdk.RestSecurityClientJDK;
import org.infinispan.client.rest.impl.jdk.RestServerClientJDK;
import org.infinispan.client.rest.impl.jdk.RestTaskClientJDK;

public class RestClientJDK
implements RestClient {
    private final RestRawClientJDK rawClient;
    private final String contextPath;

    public RestClientJDK(RestClientConfiguration configuration) {
        this.contextPath = configuration.contextPath();
        this.rawClient = new RestRawClientJDK(configuration);
    }

    @Override
    public void close() throws Exception {
        this.rawClient.close();
    }

    @Override
    public RestServerClient server() {
        return new RestServerClientJDK(this.rawClient);
    }

    @Override
    public RestClusterClient cluster() {
        return new RestClusterClientJDK(this.rawClient);
    }

    @Override
    public CompletionStage<RestResponse> cacheManagers() {
        return this.rawClient.get(this.contextPath + "/v2/server/cache-managers");
    }

    @Override
    public RestContainerClient container() {
        return new RestContainerClientJDK(this.rawClient);
    }

    @Override
    public CompletionStage<RestResponse> caches() {
        return this.rawClient.get(this.contextPath + "/v2/caches");
    }

    @Override
    public CompletionStage<RestResponse> detailedCacheList() {
        return this.rawClient.get(this.contextPath + "/v2/caches?action=detailed");
    }

    @Override
    public CompletionStage<RestResponse> cachesByRole(String roleName) {
        return this.rawClient.get(this.contextPath + "/v2/caches?action=role-accessible&role=" + roleName);
    }

    @Override
    public RestCacheClient cache(String name) {
        return new RestCacheClientJDK(this.rawClient, name);
    }

    @Override
    public CompletionStage<RestResponse> counters() {
        return this.rawClient.get(this.contextPath + "/v2/counters");
    }

    @Override
    public RestCounterClient counter(String name) {
        return new RestCounterClientJDK(this.rawClient, name);
    }

    @Override
    public RestTaskClient tasks() {
        return new RestTaskClientJDK(this.rawClient);
    }

    @Override
    public RestRawClient raw() {
        return this.rawClient;
    }

    @Override
    public RestMetricsClient metrics() {
        return new RestMetricsClientJDK(this.rawClient);
    }

    @Override
    public RestSchemaClient schemas() {
        return new RestSchemaClientJDK(this.rawClient);
    }

    @Override
    public RestClientConfiguration getConfiguration() {
        return this.rawClient.getConfiguration();
    }

    @Override
    public RestSecurityClient security() {
        return new RestSecurityClientJDK(this.rawClient);
    }
}

