/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestTaskClient;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;
import org.infinispan.client.rest.impl.jdk.Util;

public class RestTaskClientJDK
implements RestTaskClient {
    private final RestRawClientJDK client;
    private final String path;

    RestTaskClientJDK(RestRawClientJDK client) {
        this.client = client;
        this.path = client.getConfiguration().contextPath() + "/v2/tasks";
    }

    @Override
    public CompletionStage<RestResponse> list(RestTaskClient.ResultType resultType) {
        return this.client.get(this.path + "?type=" + resultType.toString());
    }

    @Override
    public CompletionStage<RestResponse> exec(String taskName, String cacheName, Map<String, ?> parameters) {
        Objects.requireNonNull(taskName);
        Objects.requireNonNull(parameters);
        StringBuilder sb = new StringBuilder(this.path).append('/').append(taskName);
        sb.append("?action=exec");
        if (cacheName != null) {
            sb.append("&cache=");
            sb.append(cacheName);
        }
        for (Map.Entry<String, ?> parameter : parameters.entrySet()) {
            sb.append("&param.");
            sb.append(parameter.getKey());
            sb.append('=');
            sb.append(Util.sanitize(parameter.getValue().toString()));
        }
        return this.client.post(sb.toString());
    }

    @Override
    public CompletionStage<RestResponse> uploadScript(String taskName, RestEntity script) {
        return this.client.post(this.path + "/" + Util.sanitize(taskName), script);
    }

    @Override
    public CompletionStage<RestResponse> downloadScript(String taskName) {
        return this.client.get(this.path + "/" + Util.sanitize(taskName) + "?action=script");
    }
}

