/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk.auth;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.impl.jdk.auth.HttpAuthenticator;

public class BearerAuthenticator
extends HttpAuthenticator {
    private final String authzValue;

    public BearerAuthenticator(HttpClient client, AuthenticationConfiguration configuration) {
        super(client, configuration);
        this.authzValue = "Bearer " + configuration.username();
    }

    @Override
    public boolean supportsPreauthentication() {
        return true;
    }

    @Override
    public HttpRequest.Builder preauthenticate(HttpRequest.Builder request) {
        return request.header("Authorization", this.authzValue);
    }

    @Override
    public <T> CompletionStage<HttpResponse<T>> authenticate(HttpResponse<T> response, HttpResponse.BodyHandler<?> bodyHandler) {
        HttpRequest request = response.request();
        List<String> authorization = request.headers().allValues("Authorization");
        if (!authorization.isEmpty() && authorization.get(0).startsWith("Bearer")) {
            return null;
        }
        HttpRequest.Builder newRequest = BearerAuthenticator.copyRequest(request, (n, v) -> true).header("Authorization", this.authzValue);
        return this.client.sendAsync(newRequest.build(), bodyHandler);
    }
}

